PROGRAM geodesic(INPUT,OUTPUT);
  TYPE
    point_ptr=^point;
    point=RECORD
             x     :  REAL;
             y     :  REAL;
             z     :  REAL;
             next  :  point_ptr
          END;
  CONST
    column_if_x_equals_0 = 320.0;
    columns_per_x = 168.0;
    number_of_iterations=3;
    row_if_y_equals_0 = 99.0;
    rows_per_y = -80.0;
  VAR
    iteration_number 
                   : INTEGER;
    head_point_ptr,
    tail_point_ptr
                   : point_ptr;
    distance_between_adjacent_vertices
                   : REAL;
  PROCEDURE set_up_icosahedron(
   VAR head_point_ptr : point_ptr;
   VAR tail_point_ptr : point_ptr);
    TYPE
      vertices = ARRAY [1..12,1..3] OF REAL;
    CONST
      icosahedron : vertices =
       (( 0.000, 0.000,-1.000),( 0.000, 0.892,-0.452),( 0.848, 0.276,-0.452),
        ( 0.524,-0.721,-0.452),(-0.524,-0.721,-0.452),(-0.848, 0.276,-0.452),
        ( 0.524, 0.721, 0.452),( 0.848,-0.276, 0.452),( 0.000,-0.892, 0.452),
        (-0.848,-0.276, 0.452),(-0.524, 0.721, 0.452),( 0.000, 0.000, 1.000));
    VAR
      vertex_number
                  : INTEGER;
      current_point_ptr,
      previous_point_ptr
                  : point_ptr;
    BEGIN
      NEW(head_point_ptr);
      head_point_ptr^.x:=icosahedron[1,1];
      head_point_ptr^.y:=icosahedron[1,2];
      head_point_ptr^.z:=icosahedron[1,3];
      previous_point_ptr:=head_point_ptr;
      FOR vertex_number:=2 TO 12 DO
        BEGIN
          NEW(current_point_ptr);
          previous_point_ptr^.next:=current_point_ptr;
          current_point_ptr^.x:=icosahedron[vertex_number,1];
          current_point_ptr^.y:=icosahedron[vertex_number,2];
          current_point_ptr^.z:=icosahedron[vertex_number,3];
          previous_point_ptr:=current_point_ptr
        END;
      tail_point_ptr:=previous_point_ptr;
      tail_point_ptr^.next:=NIL
    END;
  PROCEDURE draw_a_dome(
   VAR head_point_ptr : point_ptr;
   VAR tail_point_ptr : point_ptr;
   VAR distance_between_adjacent_vertices : REAL);
    VAR
      pause
              : CHAR;
      column_1,
      column_2,
      row_1,
      row_2
              : INTEGER;
      new_point_ptr_1,
      new_point_ptr_2,
      old_point_ptr_1,
      old_point_ptr_2
              : point_ptr;
      distance_between_vertices_squared,
      magnitude,
      x1,
      x2,
      y1,
      y2,
      z1,
      z2
              : REAL;
    BEGIN
      HiRes;
      WRITELN(OUTPUT,'                                Geodesic Domes');
      old_point_ptr_1:=head_point_ptr;
      new_point_ptr_1:=tail_point_ptr;
      WHILE (old_point_ptr_1 <> tail_point_ptr) DO
        BEGIN
          x1:=old_point_ptr_1^.x;
          y1:=old_point_ptr_1^.y;
          z1:=old_point_ptr_1^.z;
          IF z1 >= 0.0 THEN
            BEGIN 
              column_1:=TRUNC(columns_per_x*x1+column_if_x_equals_0);
              row_1:=TRUNC(rows_per_y*y1+row_if_y_equals_0)
            END;
          old_point_ptr_2:=old_point_ptr_1;
          REPEAT
            old_point_ptr_2:=old_point_ptr_2^.next;
            x2:=old_point_ptr_2^.x;
            y2:=old_point_ptr_2^.y;
            z2:=old_point_ptr_2^.z;
            distance_between_vertices_squared
             :=SQR(x2-x1)+SQR(y2-y1)+SQR(z2-z1);
            IF distance_between_vertices_squared
             <= SQR(distance_between_adjacent_vertices) THEN
              BEGIN
                IF ((z1 >= 0.0) AND (z2 >= 0.0)) THEN
                  BEGIN
                    column_2
                     :=TRUNC(columns_per_x*x2+column_if_x_equals_0);
                    row_2
                     :=TRUNC(rows_per_y*y2+row_if_y_equals_0);
                    Draw(column_1,row_1,column_2,row_2,1)
                  END;
                x2:=(x2+x1)/2.0;
                y2:=(y2+y1)/2.0;
                z2:=(z2+z1)/2.0;
                magnitude:=SQRT(x2*x2+y2*y2+z2*z2);
                NEW(new_point_ptr_2);
                new_point_ptr_2^.x:=x2/magnitude;
                new_point_ptr_2^.y:=y2/magnitude;
                new_point_ptr_2^.z:=z2/magnitude;
                new_point_ptr_1^.next:=new_point_ptr_2;
                new_point_ptr_1:=new_point_ptr_2
             END
          UNTIL
            (old_point_ptr_2 = tail_point_ptr);
          old_point_ptr_1:=old_point_ptr_1^.next
        END;
      tail_point_ptr:=new_point_ptr_1;
      tail_point_ptr^.next:=NIL;
      distance_between_adjacent_vertices
       :=distance_between_adjacent_vertices/2.0;
      GotoXY(1,24);
      WRITE(OUTPUT,'Press RETURN to continue.');
      READLN(INPUT,pause)
    END;
  BEGIN
    set_up_icosahedron(head_point_ptr,tail_point_ptr);
    distance_between_adjacent_vertices:=1.5;
    FOR iteration_number:=1 TO number_of_iterations DO 
     draw_a_dome(head_point_ptr,tail_point_ptr,
      distance_between_adjacent_vertices);
    TextMode
  END.

