Program Wordprocess;
{$C-,V-,I-}
type
    TempString = string[80];

const
  Digits: array[1..10] of char = ('1','2','3','4','5','6','7','8','9','0');
  Positions: array[1..10] of integer = (1,11,21,31,41,47,55,63,69,74);
  TabPositions: array[1..12] of integer = (6,11,16,21,26,31,36,41,46,51,56,61);
var
    Keynum, Keyset, Row, Column, I, MaxRow, ScreenRow, Temp1, Temp2, Temp3,
         TopMargin, LeftMarg, RightMarg, Num, code, Style, Index, NumEnd,
         InkeyHold, Position1, Position3, DiskSpace : integer;
    Inkey, SecInkey, Choice, ch : char;
    Words : array[1..500] of TempString;
    Tabset : array[1..80] of boolean;
    TextFile : Text;
    TempWord, FileName, Test, Typeset : TempString;
    Secnum, Row_One, Insertmode, Exit, result : boolean;
    dosrec : record
               ax,bx,cx,dx,bp,si,di,ds,es,flags : integer;
             end;
    OurDTA : array [ 1..43 ] of byte;    { Data Transfer Area buffer }
    CurDTAseg,                           { DTA segment before execution }
    CurDTAofs,                           { DTA offset    "        "     }
    OurDTAseg,                           { DTA segment and offset set after }
    OurDTAofs          : integer;        { start of program }
    EPSONCHR : file;

procedure Window1;
begin
     Window(1,1,79,2);
end;

procedure Window2;
begin
     Window(1,3,79,12);
end;

procedure Window3;
begin
     Window(2,14,78,23);
end;



procedure Keyset1;
begin
     Window3;
     ClrScr;
     GotoXY(1,1);
     TextColor(15);
     Write('Keys are as normal.');
     GotoXY(60,1);
     Write('Keyset 1');
     Window2;
end;

procedure Keyset2;
begin
     Window3;
     ClrScr;
     GotoXY(1,1);
     TextColor(15);
     Write('Key alterations highlighted.');
     GotoXY(60,1);
     Write('Keyset 2');
     GotoXY(3,2);
     Write('Unshifted:');
     GotoXY(3,4);
     TextColor(7);
     Write('1 2 3 4 5 6 7 8 9 0 - =');
     GotoXY(3,3);
     TextColor(15);
     Write('q r s t u v w x y p m }');
     GotoXY(3,6);
     TextColor(7);
     Write('Q W E R T Y U I O P [ ]');
     GotoXY(3,5);
     TextColor(15);
     Write('           ');
     GotoXY(3,8);
     TextColor(7);
     Write('A S D F G H J K L ; '' ` ');
     GotoXY(3,7);
     TextColor(15);
     Write('         { g  ');
     GotoXY(3,10);
     TextColor(7);
     Write('\ Z X C V B N M , . /');
     TextColor(15);
     GotoXY(3,9);
     Write('        l n o');
     GotoXY(40,2);
     TextColor(15);
     Write('Shifted:');
     GotoXY(40,4);
     TextColor(7);
     Write('1 2 3 4 5 6 7 8 9 0 - =');
     GotoXY(40,3);
     TextColor(15);
     Write('a  c d e  f j h i  k');
     GotoXY(40,6);
     TextColor(7);
     Write('Q W E R T Y U I O P [ ]');
     TextColor(15);
     GotoXY(40,5);
     Write('           ');
     GotoXY(40,8);
     TextColor(7);
     Write('A S D F G H J K L ; '' `');
     GotoXY(40,7);
     TextColor(15);
     Write('         z b ');
     GotoXY(40,10);
     TextColor(7);
     Write('\ Z X C V B N M , . /');
     GotoXY(40,9);
     TextColor(15);
     Write('        | ~');
     Window2;
end;



procedure Keyset3;
begin
     Window3;
     ClrScr;
     GotoXY(1,1);
     TextColor(15);
     Write('Key alterations highlighted.');
     GotoXY(60,1);
     Write('Keyset 3');
     GotoXY(3,2);
     Write('Unshifted:');
     GotoXY(3,4);
     TextColor(7);
     Write('1 2 3 4 5 6 7 8 9 0 - =');
     GotoXY(3,3);
     TextColor(15);
     Write('           ');
     GotoXY(3,6);
     TextColor(7);
     Write('Q W E R T Y U I O P [ ]');
     GotoXY(3,5);
     TextColor(15);
     Write('           ');
     GotoXY(3,8);
     TextColor(7);
     Write('A S D F G H J K L ; '' `');
     GotoXY(3,7);
     TextColor(15);
     Write('           ');
     GotoXY(3,10);
     TextColor(7);
     Write('\ Z X C V B N M , . /');
     GotoXY(3,9);
     TextColor(15);
     Write('          ');
     GotoXY(40,2);
     TextColor(15);
     Write('Shifted:');
     GotoXY(40,4);
     TextColor(7);
     Write('1 2 3 4 5 6 7 8 9 0 - =');
     GotoXY(40,3);
     TextColor(15);
     Write('           ');
     GotoXY(40,6);
     TextColor(7);
     Write('Q W E R T Y U I O P [ ]');
     GotoXY(40,5);
     TextColor(15);
     Write('           ');
     GotoXY(40,8);
     TextColor(7);
     Write('A S D F G H J K L ; '' `');
     GotoXY(40,7);
     TextColor(15);
     Write('           ');
     GotoXY(40,10);
     TextColor(7);
     Write('\ Z X C V B N M , . /');
     GotoXY(40,9);
     TextColor(15);
     Write('          ');
     Window2;
end;


procedure Keyset4;
begin
     Window3;
     ClrScr;
     GotoXY(1,1);
     TextColor(15);
     Write('Key alterations highlighted.');
     GotoXY(60,1);
     Write('Keyset 4');
     GotoXY(3,2);
     Write('Unshifted:');
     GotoXY(3,4);
     TextColor(7);
     Write('Q W E R T Y U');
     GotoXY(3,3);
     TextColor(15);
     Write(Chr(1),' ',Chr(2),' ',Chr(3),' ',Chr(4),' ',Chr(5),' ',Chr(6),' ',Chr(14));
     GotoXY(3,6);
     TextColor(7);
     Write('A S D F G H J K L');
     GotoXY(3,5);
     TextColor(15);
     Write(Chr(15),' ',Chr(16),' ',Chr(17),' ',Chr(18),' ',Chr(19),' ',Chr(20),' ',Chr(21),' ',Chr(22),' ',Chr(23));
     GotoXY(3,8);
     TextColor(7);
     Write('Z X C V B N M ,');
     GotoXY(3,7);
     TextColor(15);
     Write(Chr(24),' ',Chr(25),' ',Chr(26),' ',Chr(27),' ',Chr(28),' ',Chr(29),' ',Chr(30),' ',Chr(31));
     GotoXY(40,3);
     Write('Note: Use of any other');
     GotoXY(40,4);
     Write('key will return a space.');
     Window2;
end;


procedure SpecialCase;
begin
     Case InkeyHold of
      44 : InkeyHold := 31;
      97 : InkeyHold := 15;
      98 : InkeyHold := 28;
      99 : InkeyHold := 26;
     100 : InkeyHold := 17;
     101 : InkeyHold := 3;
     102 : InkeyHold := 18;
     103 : InkeyHold := 19;
     104 : InkeyHold := 20;
     106 : InkeyHold := 21;
     107 : InkeyHold := 22;
     108 : InkeyHold := 23;
     109 : InkeyHold := 30;
     110 : InkeyHold := 29;
     113 : InkeyHold := 1;
     114 : InkeyHold := 4;
     115 : InkeyHold := 16;
     116 : InkeyHold := 5;
     117 : InkeyHold := 14;
     118 : InkeyHold := 27;
     119 : InkeyHold := 2;
     120 : InkeyHold := 25;
     121 : InkeyHold := 6;
     122 : InkeyHold := 24;
     else
     InkeyHold := 32;
     Sound(200);
     Delay(50);
     NoSound;
     end;
end;

procedure KeysDisplay;
begin
     case Keyset of
     1 : Keyset1;
     2 : Keyset2;
     3 : Keyset3;
     4 : Keyset4;
     end;
end;

procedure PrintWords;
begin
    Window2;
    TextColor(15);
    ClrScr;
    for i := 1 to 9 do begin
       if Words[i] = Test then writeln else writeln(Words[i]);
    end;
    write(Words[10]);
end;

function Replicate ( Count, Ascii : Integer ) : TempString;
var
  Temp : TempString;
   I   : Byte;

Begin
  Temp := '';
  For I := 1 to Count do
    Temp := Temp + chr(Ascii);
  Replicate := Temp;
end;

procedure ClearBuf;
var dummy : char;
begin
   while KeyPressed do read(Kbd, dummy);
end;

procedure Data_In(Line : integer;Var FileName : TempString);
var
   count, Maxcount : integer;
   Letter : char;
   NoGood, NameSet, ValidLetters, LowerCase : set of char;

begin
   FileName := '--------.---';
   count := 1;
   ValidLetters := ['!'..'~'];
   LowerCase := ['a'..'z'];
   NoGood := ['*','<'..'?','[',']',' ','.'];
   NameSet := ValidLetters - NoGood;
   GotoXY(1,Line);
   write(FileName);
   GotoXY(1,Line);
   Maxcount := Length(FileName);
   repeat
     GotoXY(count,Line);
     read(Kbd, Letter);
     if Letter in Lowercase then Letter := UpCase(Letter);
     if (Letter = ' ') or (Letter = '.') then count := maxcount - 3;
     if Letter in NameSet
        then begin
           FileName[count] := Letter;
           GotoXY(1,Line);
           Write(FileName);
           count := count + 1;
        end
     else
       if Letter = chr(8) then begin
          if count = Pos('.',FileName) + 1 then count := count - 2
             else count := count - 1;
          if count < 1 then count := 1;
          FileName[count] := '-';
          GotoXY(1,Line);
          write(FileName);
        end
     else if (Letter <> ' ') and (Letter <> chr(13)) and (ord(Letter) <> 27)
        and (Letter <> '.') then write(chr(7));
     if count = Pos('.',FileName) then count := count + 1;
  until (count = Maxcount + 1) or (Letter = chr(13)) or (ord(Letter) = 27);
  if (ord(Letter) = 27) or (count=1) then Exit := true else begin
     if Copy(Filename, Maxcount-2,1) = '-' then begin
        Filename := Copy(Filename, 1, Length(Filename)-4);
        Filename := Filename + '.FIL';
     end;
     repeat
        Delete(Filename,Pos('-',Filename),1);
     until Pos('-',Filename)=0;
     GotoXY(1,Line);
     Write('                ');
     GotoXY(1,Line);
     Write(Filename);
  end;
end;

procedure Initialize;
 begin
    CrtInit;
    GotoXY(1,25);
    TextColor(0);
    TextBackground(7);
    write('Keyset 1 ':10,'Keyset 2 ':10,'Keyset 3 ':10,'Keyset 4 ':10,'Exit ':6);
    write('InsLine':8,'DelLine':8,'Print':6,'Load':5,'Save':5);
    TextColor(7);
    TextBackground(0);
    for i := 1 to 10 do begin
       GotoXY(Positions[i], 25);
       write(Digits[i]);
     end;
    Window2;
    Row := 1;
    Column := 1;
    ScreenRow := 1;
    MaxRow := 1;
    TempWord := Replicate(65,32);
    Test := TempWord;
    for i := 1 to 500 do Words[i] := TempWord;
    TempWord := '';
    Exit := false;
    NumEnd := 1;
    Keyset := 1;
end;

procedure Printrow;
begin
   Window1;
   TextColor(7);
   GotoXY(43,1);
   writeln('LINE: ',Row : 3,'  COLUMN:  ',Column : 2);
   TextColor(15);
   Window2;
end;



procedure ClearScreen;
begin
   Temp1 := Row;
   Temp2 := ScreenRow;
   Temp3 := Column;
   Window3;
   ClrScr;
   GotoXY(1,3);
   write('Clear Memory, Erase  Text?');
   writeln;
   writeln;
   write('ARE YOU SURE? (Y/N) ');
   read(Kbd,Inkey);
   write(Inkey);
   if (Inkey = 'y') or (Inkey = 'Y') then begin
        TempWord := Replicate(65,32);
        for i := 1 to 500 do Words[i] := TempWord;
        Row := 1;
        ScreenRow := 1;
        Column := 1;
        MaxRow := 1;
     end
   else begin
       Exit := true;
       Row := Temp1;
       ScreenRow := Temp2;
       Column := Temp3;
   end;
   Window2;
end;


function GetKey(var secnum : boolean; var Inkey : char) : boolean;
begin
   if KeyPressed then begin
      result := true;
      dosrec.ax := $0800;
      msdos(dosrec);
      Inkey := chr(lo(dosrec.ax));
      InkeyHold := lo(dosrec.ax);
      Secnum := ord(Inkey) = 0;
      if Secnum then begin
         dosrec.ax := $0800;
         msdos(dosrec);
         Keynum := ord(chr(lo(dosrec.ax)));
      end
      else if ord(Inkey) <= 27 then begin
         Secnum := true;
         Keynum := ord(Inkey);
      end
      else begin
         Keynum := ord(Inkey);
         Secnum := false;
      end
   end
   else begin
      Getkey := false;
      secnum := false;
   end;
end;

procedure WordWrap;
var SpacePosition : integer;

begin
   TextColor(15);
   SpacePosition := 65;
   TempWord := Words[Row];
   Sound(400);
   Delay(20);
   NoSound;
   case Keyset of
   1 : InkeyHold := InkeyHold;
   2 : InkeyHold := InkeyHold + 64;
   3 : InkeyHold := InkeyHold + 128;
   4 : SpecialCase;
   end;
   If InkeyHold = 127 then InkeyHold := 0;
   If Inkey = Chr(32) then Inkey := Chr(32) else Inkey := Chr(InkeyHold);
   repeat
      SpacePosition := SpacePosition - 1;
   until TempWord[SpacePosition] = ' ';
   if SpacePosition < 2 then SpacePosition := 2;
   Words[Row+1] := Copy(Words[Row], SpacePosition + 1, 65-(SpacePosition+1)) +
                    Inkey + Copy(Words[Row+1], 1, SpacePosition - 2);
   Words[Row] := Copy(Words[Row], 1, SpacePosition - 1) + Replicate(66 - SpacePosition, 32);
   ScreenRow := ScreenRow + 1;
   if ScreenRow > 10 then begin
     ScreenRow := 10;
     GotoXY(1,1);
     DelLine;
     GotoXY(1, ScreenRow-1);
     writeln(Words[Row]);
     write(Words[Row+1]);
    end
   else begin
      GotoXY(1, ScreenRow-1);
      writeln(words[Row]);
      write(Words[Row+1]);
     end;
   Row := Row + 1;
   if Row > MaxRow then MaxRow := Row;
   Column := Length(Words[Row])- SpacePosition + 3;
end;

procedure Character;
begin
   TextColor(15);
   if Column = 65 then WordWrap else begin
   case Keyset of
   1 : InkeyHold := InkeyHold;
   2 : InkeyHold := InkeyHold + 64;
   3 : InkeyHold := InkeyHold + 128;
   4 : SpecialCase;
   end;
   If InkeyHold = 127 then InkeyHold := 0;
   If Inkey = Chr(32) then Inkey := Chr(32) else
   Inkey := Chr(InkeyHold);
   begin
      GotoXY(Column,ScreenRow);
      write(Inkey);
      Insert(Inkey, Words[Row], Column);
      if not Insertmode then Delete(Words[Row],Column + 1,1);
      Column := Column + 1;
   end;
 end;
end;

procedure Del;
  begin
    TextColor(15);
    ch := Copy(Words[Row], Column, 1);
    Delete(Words[Row], Column, 1);
    Words[Row] := Words[Row] + ' ';
    GotoXY(1, ScreenRow);
    if ScreenRow = 10 then write(Words[Row]) else writeln(Words[Row]);
  end;

procedure Backspace;
  begin
    if Column > 1 then begin
       Column := Column - 1;
       Del;
    end;
 end;

procedure InsertLine;
begin
   InsLine;
   for i := MaxRow + 1 downto Row do Words[i+1] := Words[i];
   Words[Row] := Replicate(65,32);
   MaxRow := MaxRow + 1;
end;

procedure Enter;
begin
  TextColor(15);
  column := 1;
  row := row + 1;
  if row > MaxRow then MaxRow := Row;
  ScreenRow := Screenrow + 1;
  if ScreenRow > 10 then begin
     GotoXY(1,1);
     DelLine;
     ScreenRow := 10;
     GotoXY(1, ScreenRow);
     write(Words[Row]);
  end;
  GotoXY(Column, Screenrow);
  if InsertMode then InsertLine;
end;

procedure CursorLeft;
begin
  column := column - 1;
  if column < 1 then begin
     column := 65;
     if Row = 1 then Row := 1 else Row := Row - 1;
     if ScreenRow = 1 then ScreenRow := 1 else ScreenRow := ScreenRow - 1;
     end
end;

procedure CursorRight;
begin
  TextColor(15);
  column := column + 1;
  If Column > 65 then begin
  Column := 1;
  Row := Row + 1;
  if Row > MaxRow then MaxRow := Row;
  If ScreenRow < 10 then ScreenRow := ScreenRow + 1 else begin
     ScreenRow := 10;
     GotoXY(1,1);
     DelLine;
     GotoXY(1, ScreenRow);
     write(Words[Row]);
    end;
  end;
end;

procedure CursorUp;
var Count : integer;
begin
   TextColor(15);
   if row = 1 then Row_One := true else Row_One := false;
   row := row - 1;
   if row < 1 then row := 1;
   if (ScreenRow = 1) and not Row_One then begin
       GotoXY(1,1);
       InsLine;
       GotoXY(1,1);
       write(Words[Row]);
   end;
   ScreenRow := ScreenRow - 1;
   if ScreenRow < 1 then ScreenRow := 1;
end;

procedure CursorDown;
begin
  TextColor(15);
  row := row + 1;
  if row > MaxRow then MaxRow := Row;
  ScreenRow := ScreenRow + 1;
  if ScreenRow > 10 then begin
     ScreenRow := 10;
     GotoXY(1,1);
     DelLine;
     GotoXY(1, ScreenRow);
     write(Words[Row]);
  end;
end;

procedure Ins;
begin
  TextColor(7);
  if Insertmode then Insertmode := false
    else Insertmode := true;
  Window1;
  GotoXY(1,1);
  if Insertmode = true then write('Insert') else write('      ');
  TextColor(15);
end;

procedure Warning;

begin
   ClrScr;
   Writeln(chr(7),'--------------  ');
   writeln('That file already');
   writeln('    exists.');
   writeln;
   writeln('Replace it (Y/N)?');
   writeln;
   writeln('---------------');
   GotoXY(19,6);
   Read(Kbd, Choice);
   GotoXY(19,6);
   write(Choice);
   if (Choice = 'n') or (Choice = 'N') then Exit := true;
   ClrScr;
end;

procedure Savefile;
var Exist : boolean;

begin
   Temp1 := Row;
   Temp2 := ScreenRow;
   Temp3 := Column;
   Window3;
   ClrScr;
   GotoXY(1,5);
   writeln('Enter File Name:');
   write('Default = .FIL');
   GotoXY(1,10);
   write('Press Esc to exit');
   Data_In(8, Filename);
   if Exit = false then begin
      GotoXY(1,10);
      Assign(TextFile, Filename);
      {$I-}
      Reset(TextFile);
      {$I+}
      Exist := (IOresult = 0);
      if Exist = true then Warning;
      if Exit = false then begin
         Rewrite(TextFile);
         Row := 1;
         for i := 1 to MaxRow + 1 do begin
            Writeln(TextFile, Words[Row]);
            Row := Row + 1;
         end;
         Close(TextFile);
      end;
   end;
   KeysDisplay;
   Window2;
   Row := Temp1;
   ScreenRow := Temp2;
   Column := Temp3;
end;

procedure Loadfile;
var  Exist : boolean;

begin
   Temp1 := Row;
   Temp2 := ScreenRow;
   Temp3 := Column;
   Window3;
   ClrScr;
   GotoXY(1,5);
   writeln('Enter File Name:');
   write('Default = .FIL');
   GotoXY(1,10);
   write('Press Esc to exit');
   Data_In(8, Filename);
   if Exit = false then begin
      GotoXY(1,10);
      Assign(TextFile, Filename);
      {$I-}
      Reset(TextFile);
      {$I+}
      Exist := (IOresult = 0);
      if Exist = true then begin
         TempWord := Test;
         ClearScreen;
         if Exit = false then begin
            While EOF(Textfile) = false do begin
               Readln(TextFile, Words[Row]);
               if Length(Words[Row]) >= 66 then Words[Row] := Copy(Words[Row], 1, 79);
               Row := Row + 1;
               end;
            Close(TextFile);
            MaxRow := Row + 1;
            Window2;
            ClrScr;
            GotoXY(1,1);
            PrintWords;
            Row := 1;
            Column := 1;
            ScreenRow := 1;
         end;
      end;
      if Exist=false then begin
         ClrScr;
         writeln(chr(7));
         writeln('File does not exist');
         Delay(1000);
         Exit := true;
      end;
   end;
   if Exit = true then begin
      Row := Temp1;
      ScreenRow := Temp2;
      Column := Temp3;
   end;
   KeysDisplay;
   Window2;
end;

procedure PrintFile;
var lines, Linespaces, j : integer;

begin
   Temp1 := Row;
   Temp2 := ScreenRow;
   Temp3 := Column;
   Window3;
   ClrScr;
   GotoXY(1,7);
   writeln('Press any key...');
   Read(Kbd,Ch);
   ClrScr;
   GotoXY(1,3);
   TextColor(White + Blink);
   writeln('Printing...');
   TextColor(White);
   writeln;
   writeln(' Press any key ');
   writeln(' to abort.     ');
   i := 0;
   Test := Replicate(65,32);
   While (not KeyPressed) and (i < MaxRow + 1) do begin
         TempWord := Test;
         i := i + 1;
         TempWord := Words[i];
         Index := 0;
         if TempWord = Test then write(Lst, chr(10)) else
               begin
               repeat
                  Index := Index + 1;
                  Write(Lst, TempWord[Index]);
               until Index >= 65;
               Write(Lst,Chr(10));
               end;
   end;
   write(lst,chr(12));
   Window2;
   Row := Temp1;
   ScreenRow := Temp2;
   Column := Temp3;
   KeysDisplay;
end;



procedure DeleteLine;
begin
   TextColor(15);
   DelLine;
   if MaxRow > Row + (11-ScreenRow) then begin
      GotoXY(1, 10);
      write(Words[Row+(11-ScreenRow)]);
   end;
   for i := Row to MaxRow + 1 do Words[i] := Words[i+1];
   MaxRow := MaxRow - 1;
   if Row > MaxRow then MaxRow := Row;
end;



procedure Tab;
begin
   if Column < 65 then begin
      repeat
        Column := Column + 1;
      until (Tabset[Column] = true) or (Column = 65);
   end;
end;



procedure Esc;
begin
   Column := 1;
   GotoXY(1, WhereY);
   ClrEol;
   Words[Row] := Replicate(79,32);
end;



procedure DrawScreen;
begin
     ClrScr;
     Window1;
     ClrScr;
     TextColor(7);
     GotoXY(1,2);
     Write(Replicate(65,250));
     for i := 1 to 65 do Tabset[i] := False;
     for i := 1 to 12 do
     begin
          GotoXY(TabPositions[i],2);
          Write(Chr(31));
          Tabset[TabPositions[i]] := True;
     end;
     GotoXY(65,2);
     Write(Chr(174));
     Window(1,1,80,25);
     GotoXY(1,13);
     Write(Chr(201));
     Write(Replicate(78,205));
     Write(Chr(187));
     for i := 14 to 23 do
     begin
          GotoXY(1,i);
          Write(Chr(186));
          GotoXY(80,i);
          Write(Chr(186));
     end;
     GotoXY(1,24);
     Write(Chr(200));
     Write(Replicate(78,205));
     Write(Chr(188));
end;




procedure HandleFunc;
  begin
     case Keynum of
        8 : Backspace;
        9 : Tab;
       13 : Enter;
       27 : Esc;
       59 : begin
            KeySet := 1;
            KeysDisplay;
            end;
       60 : begin
            KeySet := 2;
            KeysDisplay;
            end;
       61 : begin
            Keyset := 3;
            KeysDisplay;
            end;
       62 : begin
            KeySet := 4;
            KeysDisplay;
            end;
       63 : begin
            Savefile;
            NumEnd := 9999;
            end;
       64 : Insertline;
       65 : Deleteline;
       66 : Printfile;
       67 : Loadfile;
       68 : Savefile;
       72 : CursorUp;
       75 : CursorLeft;
       77 : CursorRight;
       80 : CursorDown;
       82 : Ins;
       83 : Del;
    else
      Sound(250);
      Delay(600);
      NoSound;
    end;
  end;

begin
  Initialize;
  DrawScreen;
  PrintRow;
  KeysDisplay;
  GotoXY(1,1);
  repeat
    Secnum := false;
    if Getkey(Secnum, Inkey) then begin
       if Secnum then HandleFunc else Character;
       PrintRow;
       TextColor(15);
       Exit := false;
       if Length(Words[Row]) > 65 then Words[Row] := Copy(Words[Row], 1, 65);
       if Insertmode then begin
         GotoXY(1, ScreenRow);
         if ScreenRow = 10 then write(Words[Row]) else writeln(Words[Row]);
       end;
       GotoXY(Column , ScreenRow);
    end;
    if IOresult <> 0 then NumEnd := 9999;
  until NumEnd = 9999;
  Window(1,1,80,25);
  ClrScr;
end.
                                                                                                                     