'   WINDOWS.BAS
'CONTENT:
'   This is a simple program I made just for attempting moving and
' resizing multiple windows.
'NOTE:
'   This program demonstrates how to efficiently move and resize multiple
' windows(precisely, 8). The algorithm may be useful in editor programs.
'
'Program: Gaurang Khetan
'

'variables
    DEFINT A-Z
    TYPE windowstype
        title AS STRING * 20
        x1 AS INTEGER
        y1 AS INTEGER
        x2 AS INTEGER
        y2 AS INTEGER
        edge AS STRING * 6
        used AS INTEGER
    END TYPE
    TYPE videomemtype
        colour AS INTEGER
        character AS INTEGER
    END TYPE
    DIM SHARED windows(1 TO 8) AS windowstype
    DIM SHARED videomemory(1 TO 8, 1 TO 25, 1 TO 80) AS videomemtype
    DIM SHARED desktop(1 TO 8)
    CONST SINGLELINE = "ڿ", DOUBLELINE = "ɻ"
    CONST NORMAL = -1, REVERSE = 0
    CONST TRUE = -1, FALSE = 0

'declarations
    DECLARE SUB BasicCenter (row, col1, col2, text AS STRING)
    DECLARE SUB BasicDrawBox (x1, y1, x2, y2, edge AS STRING, brdrcol)
    DECLARE SUB BasicPrintStatus (text AS STRING, func)
    DECLARE SUB WindowDraw (win)
    DECLARE SUB WindowErase (win)
    DECLARE SUB WindowClose (win)
    DECLARE SUB WindowMove (win)
    DECLARE SUB WindowResize (win)
    DECLARE FUNCTION WindowDrawNew (title AS STRING, x1, y1, x2, y2, edge AS STRING)
    DECLARE FUNCTION WindowGoto (win)
    DECLARE SUB Main ()

'initialize videomemory for use
    FOR x = 1 TO 8
        videomemory(x, 1, 1).colour = -1
    NEXT
    FOR a = 1 TO 8
        desktop(a) = FALSE
    NEXT


'Main Module
    Main

'end of program
    COLOR 7, 0
    LOCATE , , 1
    SYSTEM

SUB BasicCenter (row, col1, col2, text AS STRING)
LOCATE row, ((col1 + col2) / 2) - (LEN(text) / 2)
PRINT text;
END SUB

SUB BasicDrawBox (x1, y1, x2, y2, edge AS STRING, brdrcol)

IF brdrcol = NORMAL THEN COLOR 7, 0 ELSE COLOR 0, 7

IF x1 = x2 THEN         'horizontal line not box
    FOR a = y1 TO y2
        LOCATE x1, a: PRINT MID$(edge, 2, 1);
    NEXT
    EXIT SUB
END IF

IF y1 = y2 THEN         'vertical line not box
    FOR a = x1 TO x2
        LOCATE a, y1: PRINT MID$(edge, 1, 1);
    NEXT
    EXIT SUB
END IF

'now it's a box

'horizontal lines
    LOCATE x1, y1
    PRINT MID$(edge, 3, 1); STRING$(y2 - y1 - 1, MID$(edge, 2, 1)); MID$(edge, 4, 1);
    LOCATE x2, y1
    PRINT MID$(edge, 6, 1); STRING$(y2 - y1 - 1, MID$(edge, 2, 1)); MID$(edge, 5, 1);

'vertical lines
    IF x2 - x1 > 1 THEN
        FOR x = (x1 + 1) TO (x2 - 1)
            LOCATE x, y1: PRINT MID$(edge, 1, 1);
            LOCATE x, y2: PRINT MID$(edge, 1, 1);
        NEXT
    END IF

END SUB

SUB BasicPrintStatus (text AS STRING, func) STATIC

DIM FirstTime AS INTEGER
DIM vidmem(1 TO 80, 1 TO 2) AS INTEGER

IF func = 1 THEN
    'restore background
    FOR a = 1 TO 80
        LOCATE 24, a
        IF vidmem(a, 1) = 112 THEN COLOR 0, 7 ELSE COLOR vidmem(a, 1), 0
        PRINT CHR$(vidmem(a, 2));
    NEXT
    EXIT SUB
END IF

IF FirstTime = 0 THEN 'first time
    'store background
    FOR a = 1 TO 80
        vidmem(a, 1) = SCREEN(24, a, 1)'colour
        vidmem(a, 2) = SCREEN(24, a, 0)'ascii
    NEXT
    FirstTime = -1
END IF

IF text = "" THEN text = "O - Open ; M - Move ; S - reSize ; Num - gotoNumwin ; Esc - terminate program"

COLOR 0, 7
LOCATE 24, 1: PRINT SPACE$(79);
BasicCenter 24, 1, 80, text

END SUB

SUB Main
   
    LOCATE , , 0
    DIM actwin AS INTEGER
   
    BasicPrintStatus "", 0
    actwin = WindowDrawNew("Windows", 4, 5, 20, 75, DOUBLELINE)

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""

    SELECT CASE char$
        CASE "M", "m":      WindowMove actwin
        CASE "S", "s":      WindowResize actwin
        CASE "O", "o":      actwin = WindowDrawNew("Windows", 4, 5, 20, 75, DOUBLELINE)
        CASE "1" TO "8":    IF windows(VAL(char$)).used THEN actwin = WindowGoto(VAL(char$))
        CASE CHR$(27):      EXIT DO
    END SELECT
LOOP

topwin = 9
FOR a = 1 TO 8
    IF desktop(a) = FALSE THEN topwin = a - 1: EXIT FOR
NEXT

FOR a = topwin TO 1 STEP -1
    WindowErase desktop(a)
NEXT

BasicPrintStatus "", 1

END SUB

SUB WindowClose (win)
   
    WindowErase win

'set the window variables for reuse
    windows(win).used = FALSE
    videomemory(win, 1, 1).colour = -1
    FOR a = 1 TO 8
        IF desktop(a) = win THEN desktop(a) = FALSE: EXIT FOR
    NEXT

END SUB

SUB WindowDraw (win)
'draws a window win using its stored coordinates and info

x1 = windows(win).x1
y1 = windows(win).y1
x2 = windows(win).x2
y2 = windows(win).y2
edge$ = windows(win).edge
title$ = windows(win).title

'save screen behind the window in videomemory array
    videomemory(win, 1, 1).colour = 0
    FOR x = x1 TO x2
        FOR y = y1 TO y2
            videomemory(win, x, y).colour = SCREEN(x, y, 1)
            videomemory(win, x, y).character = SCREEN(x, y, 0)
        NEXT
    NEXT

'draw a box
    BasicDrawBox x1, y1, x2, y2, edge$, REVERSE

'paint interior of the box in normal colour
    COLOR 7, 0
    IF x2 - x1 > 1 THEN
        FOR x = (x1 + 1) TO (x2 - 1)
            LOCATE x, y1 + 1: PRINT STRING$(y2 - y1 - 1, " ")
        NEXT
    END IF

'draw title bar
    COLOR 0, 7
    LOCATE x1 + 1, y1 + 1: PRINT STRING$(y2 - y1 - 1, " ");
  
    BasicCenter x1 + 1, y1, y2, "-" + RTRIM$(title$) + "-"    'title

    COLOR 7, 0
    LOCATE x1 + 1, y1 + 2: PRINT "";

'print window number
    COLOR 0, 7
    LOCATE x1, y2 - 3: PRINT win;

END SUB

FUNCTION WindowDrawNew (title AS STRING, x1, y1, x2, y2, edge AS STRING)

FOR p = 1 TO 8
    IF NOT windows(a).used THEN a = p: EXIT FOR
NEXT
IF a = 0 THEN EXIT FUNCTION
windows(a).used = TRUE
windows(a).title = title
windows(a).x1 = x1
windows(a).y1 = y1
windows(a).x2 = x2
windows(a).y2 = y2
windows(a).edge = edge

WindowDraw a

FOR b = 1 TO 8
    IF desktop(b) = FALSE THEN desktop(b) = a: EXIT FOR
NEXT

WindowDrawNew = a

END FUNCTION

SUB WindowErase (win)

'to restore the screen behind the window win

FOR x = windows(win).x1 TO windows(win).x2
    FOR y = windows(win).y1 TO windows(win).y2
        IF videomemory(win, x, y).colour = 112 THEN
            COLOR 0, 7
        ELSE
            COLOR videomemory(win, x, y).colour, 0
        END IF
        LOCATE x, y: PRINT CHR$(videomemory(win, x, y).character);
    NEXT
NEXT

END SUB

FUNCTION WindowGoto (win)

WindowGoto = win

topwin = 8
FOR a = 1 TO 8
    IF desktop(a) = FALSE THEN topwin = a - 1: EXIT FOR
NEXT

FOR a = 1 TO 8
    IF desktop(a) = win THEN winpos = a: EXIT FOR
NEXT

IF topwin = winpos THEN EXIT FUNCTION

FOR a = topwin TO winpos STEP -1
    WindowErase desktop(a)
NEXT

FOR a = winpos + 1 TO topwin
    WindowDraw desktop(a)
    desktop(a - 1) = desktop(a)
NEXT

WindowDraw win

desktop(topwin) = win

END FUNCTION

SUB WindowMove (win)

BasicPrintStatus " Arrow keys to move window ; Enter to indicate completion", 0

DIM boxvidmem(1 TO 210, 1 TO 2) AS INTEGER

x1 = windows(win).x1: y1 = windows(win).y1: x2 = windows(win).x2: y2 = windows(win).y2
x3 = x1: y3 = y1: x4 = x2: y4 = y2
GOSUB ScreenSave
BasicDrawBox x1, y1, x2, y2, SINGLELINE, NORMAL

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    SELECT CASE char$
        CASE CHR$(0) + "H":     IF x1 > 1 THEN x3 = x1 - 1: x4 = x2 - 1
        CASE CHR$(0) + "P":     IF x2 < 23 THEN x3 = x1 + 1: x4 = x2 + 1
        CASE CHR$(0) + "M":     IF y2 < 79 THEN y3 = y1 + 1: y4 = y2 + 1
        CASE CHR$(0) + "K":     IF y1 > 1 THEN y3 = y1 - 1: y4 = y2 - 1
        CASE CHR$(13):          EXIT DO
    END SELECT
    GOSUB ScreenRestore
    GOSUB ScreenSave
    BasicDrawBox x3, y3, x4, y4, SINGLELINE, NORMAL
    x1 = x3: x2 = x4: y1 = y3: y2 = y4
LOOP

GOSUB ScreenRestore

WindowErase win
windows(win).x1 = x1: windows(win).y1 = y1
windows(win).x2 = x2: windows(win).y2 = y2
WindowDraw win

BasicPrintStatus "", 0

EXIT SUB

ScreenSave:
    count = 0
    FOR x = y3 TO y4
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x3, x, 1)  'colour
        boxvidmem(count, 2) = SCREEN(x3, x, 0)  'ascii
    NEXT
    FOR x = x3 + 1 TO x4
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x, y4, 1)
        boxvidmem(count, 2) = SCREEN(x, y4, 0)
    NEXT
    FOR x = y4 - 1 TO y3 STEP -1
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x4, x, 1)
        boxvidmem(count, 2) = SCREEN(x4, x, 0)
    NEXT
    FOR x = x4 - 1 TO x3 + 1 STEP -1
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x, y3, 1)
        boxvidmem(count, 2) = SCREEN(x, y3, 0)
    NEXT
    RETURN

ScreenRestore:
    count = 0
    FOR x = y1 TO y2
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 7, 0
        LOCATE x1, x: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    FOR x = x1 + 1 TO x2
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 0
        LOCATE x, y2: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    FOR x = y2 - 1 TO y1 STEP -1
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 0
        LOCATE x2, x: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    FOR x = x2 - 1 TO x1 + 1 STEP -1
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 0
        LOCATE x, y1: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    RETURN
   
END SUB

SUB WindowResize (win)

BasicPrintStatus "Press one arrow key to indicate side to be moved", 0

DIM boxvidmem(1 TO 210, 1 TO 2) AS INTEGER

x1 = windows(win).x1: y1 = windows(win).y1: x2 = windows(win).x2: y2 = windows(win).y2
x3 = x1: y3 = y1: x4 = x2: y4 = y2

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    SELECT CASE char$
        CASE CHR$(0) + "H":     side = 1    'UP
        CASE CHR$(0) + "P":     side = 2    'DOWN
        CASE CHR$(0) + "M":     side = 3    'RIGHT
        CASE CHR$(0) + "K":     side = 4    'LEFT
    END SELECT
    IF side THEN EXIT DO
LOOP

BasicPrintStatus "Arrow keys - to move the side chosen ; Enter - indicates completion", 0

GOSUB SaveScreen
BasicDrawBox x1, y1, x2, y2, SINGLELINE, NORMAL

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    SELECT CASE char$
        CASE CHR$(0) + "H":                 'up
            IF side = 1 THEN                'top line
                IF x1 > 1 THEN x3 = x1 - 1
            ELSEIF side = 2 THEN            'bottom line
                IF x2 - x1 > 3 THEN x4 = x2 - 1
            END IF
        CASE CHR$(0) + "P":                 'down
            IF side = 1 THEN                'top line
                IF x2 - x1 > 3 THEN x3 = x1 + 1
            ELSEIF side = 2 THEN            'bottom line
                IF x2 < 23 THEN x4 = x2 + 1
            END IF
        CASE CHR$(0) + "M":                 'right
            IF side = 3 THEN                'right side
                IF y2 < 79 THEN y4 = y2 + 1
            ELSEIF side = 4 THEN            'left line
                IF y2 - y1 > 25 THEN y3 = y1 + 1
            END IF
        CASE CHR$(0) + "K":                 'left
            IF side = 3 THEN                'right line
                IF y2 - y1 > 25 THEN y4 = y2 - 1
            ELSEIF side = 4 THEN            'left line
                IF y1 > 1 THEN y3 = y1 - 1
            END IF
        CASE CHR$(13):  EXIT DO
    END SELECT
    GOSUB RestoreScreen
    GOSUB SaveScreen
    BasicDrawBox x3, y3, x4, y4, SINGLELINE, NORMAL
    x1 = x3: x2 = x4: y1 = y3: y2 = y4
LOOP

GOSUB RestoreScreen

WindowErase win
windows(win).x1 = x1: windows(win).y1 = y1
windows(win).x2 = x2: windows(win).y2 = y2
WindowDraw win

BasicPrintStatus "", 0

EXIT SUB

SaveScreen:
    count = 0
    FOR x = y3 TO y4
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x3, x, 1)  'colour
        boxvidmem(count, 2) = SCREEN(x3, x, 0)  'ascii
    NEXT
    FOR x = x3 + 1 TO x4
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x, y4, 1)
        boxvidmem(count, 2) = SCREEN(x, y4, 0)
    NEXT
    FOR x = y4 - 1 TO y3 STEP -1
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x4, x, 1)
        boxvidmem(count, 2) = SCREEN(x4, x, 0)
    NEXT
    FOR x = x4 - 1 TO x3 + 1 STEP -1
        count = count + 1
        boxvidmem(count, 1) = SCREEN(x, y3, 1)
        boxvidmem(count, 2) = SCREEN(x, y3, 0)
    NEXT
    RETURN

RestoreScreen:
    count = 0
    FOR x = y1 TO y2
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 0
        LOCATE x1, x: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    FOR x = x1 + 1 TO x2
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 0
        LOCATE x, y2: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    FOR x = y2 - 1 TO y1 STEP -1
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 0
        LOCATE x2, x: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    FOR x = x2 - 1 TO x1 + 1 STEP -1
        count = count + 1
        IF boxvidmem(count, 1) = 112 THEN COLOR 0, 7 ELSE COLOR boxvidmem(count, 1), 0
        LOCATE x, y1: PRINT CHR$(boxvidmem(count, 2));
    NEXT
    RETURN


END SUB

