'               TICTAC.BAS
'CONTENT:
'   This program is a game of tic-tac-toe. The main feature of the program
' is that it enables the computer to play tic-tac-toe with the user. The
' computer calculates all the possibilities, and hence cannot be defeated
' by any player of whatever skill and intelligence. It also can arrange a
' game between two players.
'
'NOTE:
'   In this program, the use of recursive funtion Evaluate() is extremely
' illustrative. This function needs a sub to call the function for the
' first time which in this program is fulfilled by CompMove Function.
' How easily the recursive property is used for calculating all the
' possibilities at a given position is fascinating and interesting.
'   The rest of the program contains nothing. However, the function
' Answer() is very useful for a question of two alternatives. It may be
' copied to other programs.
'
' Program : Gaurang Khetan
'
'variables
    DEFINT A-Z
    TYPE playerstype
        player AS STRING * 8
        shape AS STRING * 1
    END TYPE
    DIM SHARED grid(1 TO 9)
    DIM SHARED players(1 TO 2) AS playerstype
    DIM SHARED humannum, compnum
    CONST CROSS = "X", ROUND = "O"
    CONST TRUE = -1, FALSE = 0
    CONST SHOWSCORES = 0

'declarations
    DECLARE SUB PutOnPos (playernum, position)
    DECLARE SUB InitDisp ()
    DECLARE FUNCTION IsWon (playernum, t())
    DECLARE FUNCTION GetMove (playernum)
    DECLARE FUNCTION GridFull (workgrid())
    DECLARE FUNCTION GridEmpty (workgrid())
    DECLARE FUNCTION Evaluate (position, tgrid())
    DECLARE FUNCTION CompMove ()
    DECLARE FUNCTION Answer (row, col, prompt$, ans1$, ans2$)

'code
    InitDisp
   
    num = 1
    DO                                          'MAIN LOOP
        PutOnPos num, GetMove(num)
        IF IsWon(num, grid()) THEN
            LOCATE 13, 25: PRINT "WON BY PLAYER"; num; " - "; RTRIM$(players(num).player); " : "; players(num).shape
            EXIT DO
        ELSEIF GridFull(grid()) THEN
            LOCATE 13, 35: PRINT "GAME DRAWN."
            EXIT DO
        END IF
       
        IF num = 1 THEN num = 2 ELSE num = 1
    LOOP

'end
    LOCATE , , 1
    ans = Answer(18, 28, "Do you want to play again? ", "Yes", "No")
    IF ans = 1 THEN RUN
    SYSTEM

FUNCTION Answer (row, col, prompt$, ans1$, ans2$)

LOCATE , , 0
a = INT(LEN(prompt$) / 2) - 3
LOCATE row, col: PRINT prompt$
LOCATE row + 1, col + a: PRINT "-> "; ans1$
LOCATE row + 2, col + a: PRINT "   "; ans2$
choice = 1
DO
    ans$ = INKEY$
    SELECT CASE ans$
        CASE CHR$(0) + "H"
            IF choice <> 1 THEN
                LOCATE row + 2, col + a: PRINT "  "
                LOCATE row + 1, col + a: PRINT "->"
                choice = 1
            END IF
        CASE CHR$(0) + "P"
            IF choice <> 2 THEN
                LOCATE row + 1, col + a: PRINT "  "
                LOCATE row + 2, col + a: PRINT "->"
                choice = 2
            END IF
        CASE CHR$(13)
            EXIT DO
    END SELECT
LOOP

Answer = choice
LOCATE , , 1
END FUNCTION

FUNCTION CompMove

IF SHOWSCORES THEN LOCATE 23, 1: PRINT SPACE$(79): LOCATE 23, 1

IF GridEmpty(grid()) THEN           'if first move, then, to
    RANDOMIZE TIMER                 'save time, comp chooses
    rand = INT(RND * 4)             'randomly one of four
    SELECT CASE rand                'corners, as a corner move
        CASE 0:     rand = 7        'is the best first move.
        CASE 2:     rand = 9
    END SELECT
    CompMove = rand
    EXIT FUNCTION
END IF

FOR a = 1 TO 9
    IF grid(a) = 0 THEN
        b = Evaluate(a, grid())
        IF b >= highscore THEN move = a: highscore = b
        IF SHOWSCORES THEN PRINT a; "-"; b;
    END IF
NEXT a

CompMove = move

END FUNCTION

FUNCTION Evaluate (position, tgrid())

DIM highscore1, highscore2

tgrid(position) = compnum    'play comp move at asked pos in the tgrid array

IF IsWon(compnum, tgrid()) THEN Evaluate = 100: GOTO EndOfFunction
IF GridFull(tgrid()) THEN Evaluate = 50: GOTO EndOfFunction

highscore1 = 100
FOR a = 1 TO 9
IF tgrid(a) = 0 THEN            'play human move
    tgrid(a) = humannum
    IF IsWon(humannum, tgrid()) THEN
        highscore1 = 0
        tgrid(a) = 0: EXIT FOR
    ELSEIF GridFull(tgrid()) THEN
        highscore1 = 50
        tgrid(a) = 0: EXIT FOR
    END IF
    highscore2 = 0
    FOR b = 1 TO 9
        IF tgrid(b) = 0 THEN                'play comp move
                t = Evaluate(b, tgrid())
                IF t = 100 THEN highscore2 = 100: EXIT FOR
                IF t >= highscore2 THEN highscore2 = t
        END IF
    NEXT
    IF highscore2 <= highscore1 THEN highscore1 = highscore2
    tgrid(a) = 0
    IF highscore1 = 0 THEN EXIT FOR
END IF
NEXT

Evaluate = highscore1

EndOfFunction:

tgrid(position) = 0

END FUNCTION

FUNCTION GetMove (playernum)

LOCATE 3, 1: PRINT "PLAYER"; playernum; "- "; RTRIM$(players(playernum).player); " : "; players(playernum).shape

SELECT CASE players(playernum).player
   
    CASE "HUMAN   ":
        LOCATE 4, 1
        PRINT "Hit a number at which you want to play (1-9, 0=QUIT)"
       
        DO
            char$ = INPUT$(1)
            IF (ASC(char$) >= 48 AND ASC(char$) <= 57) THEN
                IF VAL(char$) = 0 THEN SYSTEM
                IF grid(VAL(char$)) = 0 THEN EXIT DO
            END IF
        LOOP
        GetMove = VAL(char$)
   
    CASE "COMPUTER":
        LOCATE 4, 1
        PRINT "Computer thinking ..."

        GetMove = CompMove

END SELECT

LOCATE 3, 1: PRINT SPACE$(79)
LOCATE 4, 1: PRINT SPACE$(79)

END FUNCTION

FUNCTION GridEmpty (workgrid())

flag = TRUE
FOR a = 1 TO 9
    IF workgrid(a) <> 0 THEN flag = FALSE
NEXT a
GridEmpty = flag

END FUNCTION

FUNCTION GridFull (workgrid())
    flag = TRUE
    FOR a = 1 TO 9
        IF workgrid(a) = 0 THEN flag = FALSE
    NEXT
    GridFull = flag
END FUNCTION

SUB InitDisp
       
CLS

'print title
    COLOR 16, 7
    LOCATE 3, 25: PRINT " T I C   -    T A C   -    T O E "
    COLOR 7, 0
    LOCATE 5, 45: PRINT "-- Gaurang Khetan"

'ask whether 2-player or 1-player
    ans = Answer(8, 25, "Which type of Game?", "1-Player Game", "2-Player Game")
    IF ans = 1 THEN
        ans = Answer(12, 25, "Do you want to play first?", "Yes", "No")
        IF ans = 1 THEN a = 1: b = 2 ELSE a = 2: b = 1
        humannum = a: compnum = b
        players(compnum).player = "COMPUTER"
        players(humannum).player = "HUMAN"
    ELSE
        players(1).player = "HUMAN"
        players(2).player = "HUMAN"
    END IF
    players(1).shape = CROSS
    players(2).shape = ROUND

CLS
COLOR 0, 7
LOCATE 1, 25: PRINT " T I C   -    T A C   -    T O E "
COLOR 7, 0

LOCATE , , 0

'print grid numbers
    COLOR 2, 0
    FOR a = 1 TO 3: FOR b = 1 TO 3
        position = (a - 1) * 3 + b
        r = (position \ 3) + 1
        c = position MOD 3
        IF c = 0 THEN c = 3: r = r - 1
        LOCATE 8 + r, 35 + (2 * c): PRINT LTRIM$(STR$(position))
    NEXT b, a
    COLOR 7, 0

END SUB

FUNCTION IsWon (playernum, t())

IsWon = TRUE

'diagonal
    IF t(1) = t(5) AND t(1) = t(9) AND t(1) = playernum THEN EXIT FUNCTION
    IF t(3) = t(5) AND t(3) = t(7) AND t(3) = playernum THEN EXIT FUNCTION

'horizontal
    IF t(1) = t(2) AND t(1) = t(3) AND t(1) = playernum THEN EXIT FUNCTION
    IF t(4) = t(5) AND t(4) = t(6) AND t(4) = playernum THEN EXIT FUNCTION
    IF t(7) = t(8) AND t(7) = t(9) AND t(7) = playernum THEN EXIT FUNCTION

'vertical
    IF t(1) = t(4) AND t(1) = t(7) AND t(1) = playernum THEN EXIT FUNCTION
    IF t(2) = t(5) AND t(2) = t(8) AND t(2) = playernum THEN EXIT FUNCTION
    IF t(3) = t(6) AND t(3) = t(9) AND t(3) = playernum THEN EXIT FUNCTION

IsWon = FALSE

END FUNCTION

SUB PutOnPos (playernum, position)

r = (position \ 3) + 1
c = position MOD 3
IF c = 0 THEN c = 3: r = r - 1

LOCATE 8 + r, 35 + (2 * c)

COLOR 15, 0
PRINT players(playernum).shape
COLOR 7, 0

grid(position) = playernum

END SUB

