'
'                               TETRIS.BAS
'CONTENT:
'   The program is a game of Tetris (also called Bricks). Although
' there are few advanced functions available in the game, still it
' is sufficiently advanced so as to be called a good computer program
' by an amateur. I was very satisfied on seeing the output from the
' program.
'
'NOTE:
'   The introducing screen graphics are very well made and the tactics
' could be helpful in making more attractive graphics presentations.
'   The TIMER library function is put to good use in delaying the fall
' of bricks. In this case, this function was used instead of regular
' delay FOR-NEXT loop. This was because in the case of delay loop, the
' key presses during the time of looping cannot be trapped. So the response
' to pressing of keys was not immediate and took some time. But in the
' system used, the trapping of key presses is kept enabled for the whole
' time.
'   However, yet one bug remains. The ANSI.SYS settings imply that keeping
' the key pressed does not send the signal repeatedly, but for a certain
' delay time, it only sends a signal once which is sent as soon as the
' key is pressed. This makes the controlling of bricks not fully on command.
' For overcoming this a keyboard ISR(interrupt service routine) must be
' be made which is difficult in BASIC. However, if this program would have
' been in C/C++, I would have certainly took the trouble of creating the ISR.
'
'   Program : Gaurang Khetan
'

DEFINT A-Z
CONST EMPTY = 0, LIGHT = 1, DARK = 2, FILLED = 3, BRIGHT = 4
CONST t = 1, FOUR = 2, REVFOUR = 3, SQUARE = 4, ROD = 5, L = 6, REVL = 7
CONST TRUE = -1, FALSE = NOT TRUE     'i.e 0
CONST CLOCKWISE = -1, ANTICLOCKWISE = 0
DIM SHARED screenmap(1 TO 25, 1 TO 16)
DIM SHARED box1(20), box2(20)
DIM SHARED box3(20), box4(20)
DIM SHARED objects(1 TO 7, 1 TO 4, 1 TO 4, 1 TO 4)
DIM SHARED curobject(1 TO 4, 1 TO 4)
DIM SHARED endofgame
DIM SHARED changedmode
DIM SHARED mode

'* Declaration Of Subs and Funcs *

DECLARE SUB Rest (delay)
DECLARE SUB Center (row, text AS STRING)
DECLARE SUB Intro (speed, level)
DECLARE SUB GetBoxFigure ()
DECLARE SUB DrawBoxAt (row, col, colour)
DECLARE SUB DrawScreen (level)
DECLARE SUB StoreObjects ()
DECLARE SUB DrawObject (x, y, colour)
DECLARE SUB TurnObject (obj, var)
DECLARE SUB PlayGame (level, speed)
DECLARE SUB AssignObject (object, variation)
DECLARE SUB CheckFullLines (score, lines)
DECLARE SUB DispNextObject (obj, var)
DECLARE FUNCTION FallComplete (row, col)
DECLARE FUNCTION TouchedRightWall (row, col)
DECLARE FUNCTION TouchedLeftWall (row, col)
DECLARE FUNCTION InvalidTurn (row, col)

ON KEY(1) GOSUB changerotatemode
ON ERROR GOTO screenmodeerror
    SCREEN 1
ON ERROR GOTO 0

GetBoxFigure

Intro speed, level

CLS

StoreObjects
DrawScreen level

PlayGame level, speed

CLS
INPUT "Want to play Again(y/n):", ans$
IF ans$ = "N" OR ans$ = "n" THEN
    IF changedmode THEN SHELL "mode mono"
    SYSTEM
ELSE
    CLEAR
    RUN
END IF

screenmodeerror:
    PRINT "Your computer does not support graphics!!!"
    SYSTEM
    RESUME

changerotatemode:
    mode = NOT mode
    LOCATE 25, 1: PRINT SPACE$(13);
    LOCATE 25, 1
    SELECT CASE mode
        CASE CLOCKWISE:     PRINT "ClockWise";
        CASE ANTICLOCKWISE: PRINT "AntiClockWise";
    END SELECT
    RETURN

SUB AssignObject (object, variation)

FOR a = 1 TO 4: FOR b = 1 TO 4
    curobject(a, b) = objects(object, variation, a, b)
NEXT b, a

END SUB

SUB Center (row, text AS STRING)

LOCATE row, 1
PRINT SPACE$(39);
LOCATE row, 21 - LEN(text) / 2
PRINT text;

END SUB

SUB CheckFullLines (score, lines)

plines = lines

row = 25
DO WHILE row > 3
    row = row - 1
    lineformed = TRUE
    brickspresent = FALSE
    FOR col = 2 TO 15
        IF screenmap(row, col) <> DARK THEN lineformed = FALSE
        IF screenmap(row, col) = DARK THEN brickspresent = TRUE
    NEXT
    IF NOT brickspresent THEN EXIT DO
    IF lineformed THEN
        lines = lines + 1
        FOR a = 2 TO 15
            DrawBoxAt row, a, DARK
            screenmap(row, a) = EMPTY
        NEXT
        FOR b = (row) TO 3 STEP -1
            FOR a = 2 TO 15
                IF screenmap(b - 1, a) = DARK THEN
                    DrawBoxAt b, a, DARK
                    screenmap(b, a) = DARK
                    DrawBoxAt b - 1, a, DARK
                    screenmap(b - 1, a) = EMPTY
                END IF
            NEXT a
        NEXT b
        row = row + 1
        FOR a = 1 TO 30000: NEXT
    END IF
LOOP

SELECT CASE (lines - plines)
    CASE 1:     score = score + 100
    CASE 2:     score = score + 400
    CASE 3:     score = score + 900
    CASE 4:     score = score + 1500
END SELECT

END SUB

SUB DispNextObject (obj, var)

FOR a = 1 TO 4: FOR b = 1 TO 4
    IF objects(obj, var, a, b) = FILLED THEN
        PUT ((((b - 1) * 7) + 20), (((a - 1) * 7) + 24)), box1, PSET
    ELSE
        PUT ((((b - 1) * 7) + 20), (((a - 1) * 7) + 24)), box3, PSET
    END IF
NEXT b, a

END SUB

SUB DrawBoxAt (row, col, colour)
    x = 96 + ((col - 1) * 9)
    y = 10 + ((row - 1) * 7)
    SELECT CASE colour
        CASE LIGHT:     PUT (x, y), box1
        CASE DARK:      PUT (x, y), box2
        CASE BRIGHT:    PUT (x, y), box4
        CASE EMPTY:     PUT (x, y), box3, PSET
    END SELECT
END SUB

SUB DrawObject (x, y, colour)
    FOR a = 1 TO 4: FOR b = 1 TO 4
        IF curobject(a, b) = FILLED THEN
            p = x + a - 1: q = y + b - 1
            SELECT CASE colour
                CASE LIGHT:
                    DrawBoxAt p, q, LIGHT
                    IF screenmap(p, q) = LIGHT THEN
                        screenmap(p, q) = EMPTY
                    ELSEIF screenmap(p, q) = EMPTY THEN
                        screenmap(p, q) = LIGHT
                    ELSE
                        endofgame = TRUE
                    END IF
                CASE DARK:
                    DrawBoxAt p, q, DARK
                    IF screenmap(p, q) = DARK THEN
                        screenmap(p, q) = EMPTY
                    ELSEIF screenmap(p, q) = EMPTY THEN
                        screenmap(p, q) = DARK
                    END IF
            END SELECT
        END IF
    NEXT b, a
END SUB

SUB DrawScreen (level)
   
    FOR a = 1 TO 16
        DrawBoxAt 1, a, BRIGHT: screenmap(1, a) = DARK
        DrawBoxAt 25, a, BRIGHT: screenmap(25, a) = DARK
    NEXT
    FOR a = 2 TO 24
        DrawBoxAt a, 1, BRIGHT: screenmap(a, 1) = DARK
        DrawBoxAt a, 16, BRIGHT: screenmap(a, 16) = DARK
    NEXT
    LOCATE 2, 1: PRINT "NEXT:"
    LOCATE 9, 1: PRINT "Score:"
    LOCATE 12, 1: PRINT "Lines:"
    LOCATE 15, 1: PRINT "Level:"
    LOCATE 18, 1: PRINT "Speed:"
    LOCATE 24, 1: PRINT "Rotation: ";
   
    'level
    IF level > 1 THEN
        FOR a = 24 TO (26 - (level * 2)) STEP -1
            FOR b = 2 TO 15
                IF RND > .5 THEN
                    DrawBoxAt a, b, DARK
                    screenmap(a, b) = DARK
                END IF
            NEXT
        NEXT
    END IF

END SUB

FUNCTION FallComplete (row, col)

FallComplete = FALSE
FOR a = 1 TO 4: FOR b = 1 TO 4
    IF curobject(a, b) = FILLED THEN
        IF screenmap(a + row, b + col - 1) = DARK THEN
            FallComplete = TRUE
            EXIT FUNCTION
        END IF
    END IF
NEXT b, a

END FUNCTION

SUB GetBoxFigure

    CLS
    LINE (156, 97)-(164, 103), 1, B 'light box
    PAINT (160, 100), CHR$(100) + CHR$(101) + CHR$(102), 1
    GET (156, 97)-(164, 103), box1
    PUT (156, 97), box1
   
    LINE (156, 97)-(164, 103), 2, B 'dark box
    PAINT (160, 100), CHR$(200) + CHR$(100) + CHR$(150), 2
    GET (156, 97)-(164, 103), box2
    PUT (156, 97), box2
   
    GET (156, 97)-(164, 103), box3  'blank box
   
    LINE (156, 97)-(164, 103), 2, B 'bright box
    PAINT (160, 100), CHR$(255), 2
    GET (156, 97)-(164, 103), box4
    PUT (156, 97), box4

END SUB

SUB Intro (speed, level)

CLS
DO: LOOP UNTIL INKEY$ = ""

'movement of name
    DIM namefig(175)
    DIM movement
    Center 25, "Gaurang Khetan's"
    GET (90, 190)-(225, 199), namefig
    r = 190: nr = r: movement = 1
    DO
        Rest 8000
        SELECT CASE movement
            CASE 1: nr = r - 1: IF nr <= 100 THEN movement = 2
            CASE 2: nr = r + 1: IF nr >= 120 THEN movement = 3
            CASE 3: nr = r - 1: IF nr <= 20 THEN EXIT DO
        END SELECT
        PUT (90, r), namefig    'erase
        PUT (90, nr), namefig   'redraw
        r = nr
    LOOP
    ERASE namefig
    IF INKEY$ <> "" THEN GOTO questions
   
'settling of bricks
    FOR layer = 1 TO 5
        IF INKEY$ <> "" THEN GOTO questions
        FOR a = 1 TO 35: PUT ((a - 1) * 9, 1), box4: NEXT
        FOR r = 8 TO (78 - (layer - 1) * 7) STEP 7
            Rest 30000
            FOR a = 1 TO 35: PUT ((a - 1) * 9, r - 7), box4: NEXT   'erase
            FOR a = 1 TO 35: PUT ((a - 1) * 9, r), box4: NEXT       'draw
        NEXT
    NEXT
    

'falling of bricks
    DIM namemap(1 TO 5, 1 TO 35)
    namestring$ = "000000000000000"
    namestring$ = namestring$ + "000001000010000111111000010000"    'T
    namestring$ = namestring$ + "00000111111010110101"              'E
    namestring$ = namestring$ + "000001000010000111111000010000"    'T
    namestring$ = namestring$ + "0000011111101101010111101"         'R
    namestring$ = namestring$ + "00000100011111110001"              'I
    namestring$ = namestring$ + "00000111011010110111"              'S
    namestring$ = namestring$ + "000000000000000"
   
    FOR b = 1 TO 35: FOR a = 1 TO 5
        namemap(a, b) = VAL(MID$(namestring$, (b - 1) * 5 + a, 1))
    NEXT a, b
   
    FOR layer = 1 TO 5
        IF INKEY$ <> "" THEN GOTO questions
        initpos = 78 - (layer - 1) * 7
        FOR a = 1 TO 35
            IF namemap(6 - layer, a) = 0 THEN
                PUT ((a - 1) * 9, initpos), box4
            ELSE
                IF layer MOD 2 THEN
                    PUT ((a - 1) * 9, initpos), box2, PSET
                ELSE
                    PUT ((a - 1) * 9, initpos), box1, PSET
                END IF
            END IF
        NEXT
        FOR r = initpos TO 120 STEP 7
            FOR a = 1 TO 35
                IF namemap(6 - layer, a) = 0 THEN PUT ((a - 1) * 9, r), box4
            NEXT   'draw
            Rest 30000
            FOR a = 1 TO 35
                IF namemap(6 - layer, a) = 0 THEN PUT ((a - 1) * 9, r), box4
            NEXT   'erase
        NEXT
    NEXT
    ERASE namemap
    IF INKEY$ <> "" THEN GOTO questions

    'type out instructions
    DIM inst(1 TO 8) AS STRING
    inst(1) = "Bricks having particular shapes are"
    inst(2) = "falling. You can move them sideways"
    inst(3) = "using arrow keys. You can rotate"
    inst(4) = "them using space bar. Don't fill"
    inst(5) = "them upto the top. You have to fill"
    inst(6) = "horizontal lines by bricks which are"
    inst(7) = "automatically deleted thus bringing"
    inst(8) = "the level of the bricks down."

    FOR a = 1 TO 8
        IF INKEY$ <> "" THEN GOTO questions
        initpos = 21 - (LEN(inst(a)) / 2)
        LOCATE a + 14, initpos
        FOR b = 1 TO LEN(inst(a))
            Rest 30000
            PRINT MID$(inst(a), b, 1);
        NEXT
    NEXT

    Center 24, "Press any key to continue . . ."
    DO: LOOP WHILE INKEY$ = ""
   
questions:
CLS
DO
    Center 11, "Speed(0-5): "
    DO: Inp$ = INKEY$: LOOP WHILE Inp$ = ""
LOOP UNTIL Inp$ >= "0" AND Inp$ <= "5"
PRINT Inp$
speed = VAL(Inp$)

DO
    Center 13, "Level(0-9): "
    DO: Inp$ = INKEY$: LOOP WHILE Inp$ = ""
LOOP UNTIL Inp$ >= "0" AND Inp$ <= "9"
PRINT Inp$
level = VAL(Inp$)


END SUB

FUNCTION InvalidTurn (row, col)

InvalidTurn = FALSE
FOR a = 1 TO 4: FOR b = 1 TO 4
    IF curobject(a, b) = FILLED THEN
        p = a + row - 1: q = b + col - 1
        IF p > 0 AND q > 0 AND p < 26 AND q < 16 THEN
            IF screenmap(p, q) = DARK THEN
                InvalidTurn = TRUE
                EXIT FUNCTION
            END IF
        ELSE
            InvalidTurn = TRUE
            EXIT FUNCTION
        END IF
    END IF
NEXT b, a

END FUNCTION

SUB PlayGame (level, speed)

DIM t(1 TO 4, 1 TO 4)
DIM score, lines, Inc
DIM StartTime AS SINGLE, TimeLap AS SINGLE

endofgame = FALSE
mode = CLOCKWISE
KEY(0) ON

LOCATE 15, 7: PRINT LTRIM$(STR$(level))
LOCATE 18, 7: PRINT LTRIM$(STR$(speed))
LOCATE 25, 1: PRINT "ClockWise";

'decide object
RANDOMIZE TIMER
Nobj = INT(RND * 7) + 1
Nvariation = INT(RND * 4) + 1

DO
    LOCATE 9, 7: PRINT LTRIM$(STR$(score))
    LOCATE 12, 7: PRINT LTRIM$(STR$(lines))
    IF score >= 5000 * (Inc + 1) THEN
        Inc = Inc + 1
        IF speed = 5 THEN speed = 1 ELSE speed = speed + 1
        LOCATE 18, 7: PRINT LTRIM$(STR$(speed))
    END IF

   'decide object
    RANDOMIZE TIMER
    obj = Nobj: variation = Nvariation
    AssignObject obj, variation
    Nobj = INT(RND * 7) + 1
    Nvariation = INT(RND * 4) + 1
    DispNextObject Nobj, Nvariation
   
    'make it fall
    DO: LOOP UNTIL INKEY$ = ""
    row = 2: col = 6
    DrawObject row, col, LIGHT
    StartTime = TIMER
    TimeLap = .5 - (speed * .1)

    DO
        Inp$ = INKEY$
        SELECT CASE Inp$
            CASE CHR$(0) + "M"  'right
                IF NOT TouchedRightWall(row, col) THEN
                    DrawObject row, col, LIGHT
                    col = col + 1
                    DrawObject row, col, LIGHT
                END IF
            CASE CHR$(0) + "K"  'left
                IF NOT TouchedLeftWall(row, col) THEN
                    DrawObject row, col, LIGHT
                    col = col - 1
                    DrawObject row, col, LIGHT
                END IF
            CASE CHR$(0) + "P"  'down
                IF FallComplete(row, col) THEN EXIT DO
                DrawObject row, col, LIGHT
                row = row + 1
                DrawObject row, col, LIGHT
            CASE CHR$(32)       'space
                DrawObject row, col, LIGHT
                TurnObject obj, variation
                IF InvalidTurn(row, col) THEN
                    mode = NOT mode
                    TurnObject obj, variation
                    mode = NOT mode
                END IF
                DrawObject row, col, LIGHT
            CASE CHR$(27)       'esc
                IF changedmode THEN SHELL "mode mono"
                SYSTEM
        END SELECT
        IF TIMER - StartTime >= TimeLap THEN
            IF FallComplete(row, col) THEN EXIT DO
            DrawObject row, col, LIGHT      'erase
            row = row + 1
            DrawObject row, col, LIGHT      'draw
            StartTime = TIMER
        END IF
    LOOP
    DrawObject row, col, LIGHT      'erase
    DrawObject row, col, DARK
    CheckFullLines score, lines
    IF endofgame THEN EXIT DO
LOOP


END SUB

SUB Rest (delay)
FOR a = 1 TO delay: NEXT
END SUB

SUB StoreObjects
'**T**
   'var1
    objects(t, 1, 2, 3) = FILLED: objects(t, 1, 3, 3) = FILLED
    objects(t, 1, 4, 3) = FILLED: objects(t, 1, 3, 2) = FILLED
   'var2
    objects(t, 2, 3, 2) = FILLED: objects(t, 2, 3, 3) = FILLED
    objects(t, 2, 3, 4) = FILLED: objects(t, 2, 2, 3) = FILLED
   'var3
    objects(t, 3, 2, 3) = FILLED: objects(t, 3, 3, 3) = FILLED
    objects(t, 3, 4, 3) = FILLED: objects(t, 3, 3, 4) = FILLED
   'var4
    objects(t, 4, 3, 2) = FILLED: objects(t, 4, 3, 3) = FILLED
    objects(t, 4, 4, 3) = FILLED: objects(t, 4, 3, 4) = FILLED
'*FOUR*
   'var1
    objects(FOUR, 1, 2, 2) = FILLED: objects(FOUR, 1, 3, 2) = FILLED
    objects(FOUR, 1, 3, 3) = FILLED: objects(FOUR, 1, 4, 3) = FILLED
   'var2
    objects(FOUR, 2, 2, 3) = FILLED: objects(FOUR, 2, 2, 4) = FILLED
    objects(FOUR, 2, 3, 2) = FILLED: objects(FOUR, 2, 3, 3) = FILLED
   'var3 & var4
    FOR a = 1 TO 4: FOR b = 1 TO 4
        objects(FOUR, 3, a, b) = objects(FOUR, 1, a, b)
        objects(FOUR, 4, a, b) = objects(FOUR, 2, a, b)
    NEXT b, a

'*REVFOUR*
   'var1
    objects(REVFOUR, 1, 2, 3) = FILLED: objects(REVFOUR, 1, 3, 2) = FILLED
    objects(REVFOUR, 1, 3, 3) = FILLED: objects(REVFOUR, 1, 4, 2) = FILLED
   'var2
    objects(REVFOUR, 2, 2, 2) = FILLED: objects(REVFOUR, 2, 2, 3) = FILLED
    objects(REVFOUR, 2, 3, 3) = FILLED: objects(REVFOUR, 2, 3, 4) = FILLED
   'var3 & var4
    FOR a = 1 TO 4: FOR b = 1 TO 4
        objects(REVFOUR, 3, a, b) = objects(REVFOUR, 1, a, b)
        objects(REVFOUR, 4, a, b) = objects(REVFOUR, 2, a, b)
    NEXT b, a

'*SQUARE*
   'var1
    objects(SQUARE, 1, 2, 2) = FILLED: objects(SQUARE, 1, 2, 3) = FILLED
    objects(SQUARE, 1, 3, 2) = FILLED: objects(SQUARE, 1, 3, 3) = FILLED
   'var2 & var3 & var4
    FOR a = 1 TO 4: FOR b = 1 TO 4
        objects(SQUARE, 2, a, b) = objects(SQUARE, 1, a, b)
        objects(SQUARE, 3, a, b) = objects(SQUARE, 1, a, b)
        objects(SQUARE, 4, a, b) = objects(SQUARE, 1, a, b)
    NEXT b, a
  
'*ROD*
   'var1
    FOR a = 1 TO 4: objects(ROD, 1, a, 2) = FILLED: NEXT
   'var2
    FOR a = 1 TO 4: objects(ROD, 2, 3, a) = FILLED: NEXT
   'var3
    FOR a = 1 TO 4: objects(ROD, 3, a, 2) = FILLED: NEXT
   'var4
    FOR a = 1 TO 4: objects(ROD, 4, 3, a) = FILLED: NEXT

'*L*
   'var1
    FOR a = 1 TO 3: objects(L, 1, a, 2) = FILLED: NEXT
    objects(L, 1, 3, 3) = FILLED
   'var2
    FOR a = 2 TO 4: objects(L, 2, 2, a) = FILLED: NEXT
    objects(L, 2, 3, 2) = FILLED
   'var3
    FOR a = 2 TO 4: objects(L, 3, a, 3) = FILLED: NEXT
    objects(L, 3, 2, 2) = FILLED
   'var4
    FOR a = 1 TO 3: objects(L, 4, 3, a) = FILLED: NEXT
    objects(L, 4, 2, 3) = FILLED

'*REVL*
   'var1
    FOR a = 1 TO 3: objects(REVL, 1, a, 3) = FILLED: NEXT
    objects(REVL, 1, 3, 2) = FILLED
   'var2
    FOR a = 2 TO 4: objects(REVL, 2, 3, a) = FILLED: NEXT
    objects(REVL, 2, 2, 2) = FILLED
   'var3
    FOR a = 2 TO 4: objects(REVL, 3, a, 2) = FILLED: NEXT
    objects(REVL, 3, 2, 3) = FILLED
   'var4
    FOR a = 1 TO 3: objects(REVL, 4, 2, a) = FILLED: NEXT
    objects(REVL, 4, 3, 3) = FILLED

END SUB

FUNCTION TouchedLeftWall (row, col)

TouchedLeftWall = FALSE
FOR a = 1 TO 4: FOR b = 1 TO 4
    IF curobject(a, b) = FILLED THEN
        IF screenmap(a + row - 1, b + col - 2) = DARK THEN
            TouchedLeftWall = TRUE
            EXIT FUNCTION
        END IF
    END IF
NEXT b, a

END FUNCTION

FUNCTION TouchedRightWall (row, col)

TouchedRightWall = FALSE
FOR a = 1 TO 4: FOR b = 1 TO 4
    IF curobject(a, b) = FILLED THEN
        IF screenmap(a + row - 1, b + col) = DARK THEN
            TouchedRightWall = TRUE
            EXIT FUNCTION
        END IF
    END IF
NEXT b, a

END FUNCTION

SUB TurnObject (obj, var)

SELECT CASE mode
    CASE CLOCKWISE
        IF var = 4 THEN var = 1 ELSE var = var + 1
    CASE ANTICLOCKWISE
        IF var = 1 THEN var = 4 ELSE var = var - 1
END SELECT
FOR a = 1 TO 4: FOR b = 1 TO 4
    curobject(a, b) = objects(obj, var, a, b)
NEXT b, a

END SUB

