'
''*********GAME - SOLITAIRE*******************[text mode]
'   This is a single deck solitaire - having exactly same rules as the
' game played with cards. The suits of cards are drawn using ASCII characters
' and the cards are also drawn with ASCII box drawing characters.

'default data type
DEFINT A-Y: DEFSTR Z

'structures
TYPE memtype
    char AS STRING * 1: colour AS STRING * 1
END TYPE
TYPE cardtype
    row AS INTEGER: col AS INTEGER
    suit AS INTEGER: value AS INTEGER
    suitstr AS STRING * 1: valstr AS STRING * 2
    status AS INTEGER               'whether FACEUP or FACEDOWN
    parameter AS INTEGER            'whether restricted or free
END TYPE

'constants
CONST CURSOR = ""  '22                                     'general
CONST TRUE = -1, FALSE = 0
CONST CARDHEIGHT = 8, CARDWIDTH = 9                         'cardrelated
CONST FACEUP = 1, FACEDOWN = 2
CONST SINGLELINE = "ڿĳ", DOUBLELINE = "ɻȼͺ"
CONST RESTRICTED = 1, FREE = 2
CONST NEXTCARD = 1, PREVIOUSCARD = 2                        'arguments
CONST REMOVEONE = 1, REMOVEALL = 2
CONST WON = 1, NOTWON = 2
CONST RIGHT = 1, LEFT = 2, UP = 3, DOWN = 4, SAME = 5
CONST ONLYERASE = 1, ONLYDRAW = 2
CONST NORMAL = 7, REVERSE = 112, BRIGHT = 15, GREY = 71     'colours
CONST FUCARDBOR = REVERSE, FUCARDCON = REVERSE, FUCARDLINE = DOUBLELINE
CONST FDCARDBOR = 99, FDCARDCON = 99, FDCARDLINE = SINGLELINE
CONST BACKGRCOL = 32
CONST DPILEROW = 18, DPILECOL = 60                          'screen speci.
CONST FPILEROW = 18
CONST CONSTRAINT = 17   'row cards are not drawn below this row
CONST MAXCARDS = CONSTRAINT - 3'only maxcards cards canbe in norm rowdraw mode

'declarations
DECLARE SUB Main ()
DECLARE SUB Intro ()
DECLARE SUB colour (col)
DECLARE SUB Initialize ()
DECLARE SUB DrawScreen ()
DECLARE SUB CursorNext (curpos, upordown, parameter1, parameter2)
DECLARE SUB PrintSelCard (selected)
DECLARE FUNCTION IsValid (r, card2)
DECLARE FUNCTION NumOfCardsUp ()
DECLARE SUB NumOfCardsLeft ()
DECLARE SUB CardBox (r1, c1, r2, c2, brdrcol, concol, Zedge)
DECLARE SUB CardDraw (cardnum)
DECLARE SUB CardErase (cardnum)
DECLARE SUB DPileDraw ()
DECLARE FUNCTION DPileRemove ()
DECLARE FUNCTION DPileAdd ()
DECLARE SUB DPileNext ()
DECLARE SUB DPileShift ()
DECLARE FUNCTION FPileAdd (num)
DECLARE FUNCTION RowAdd (num)
DECLARE SUB RowDraw (num)
DECLARE SUB RowErase (num)
DECLARE FUNCTION RowRemove (num, parameter)
DECLARE SUB RowTurnTopCard (num)
DECLARE SUB GameEnd ()
DECLARE SUB GameWon ()

'global data
REM $DYNAMIC

DIM SHARED deck(1 TO 52) AS cardtype
DIM SHARED memory(1 TO 52, 1 TO CARDHEIGHT, 1 TO CARDWIDTH) AS memtype
DIM SHARED ans(1 TO 14)         'used to transfer list of cards betn functions
DIM SHARED flag    'if only 1 card is picked from many faceups in a row,  TRUE

DIM SHARED drawpile(1 TO 24)
DIM SHARED dpilecurcard, dpilelastcard

DIM SHARED row(1 TO 7, 1 TO 19)
DIM SHARED rowlastcard(1 TO 7)

DIM SHARED finalpile(1 TO 4, 1 TO 13)
DIM SHARED fpilelastcard(1 TO 4)

'*code
10 Main         'linenumber is for RUN statement

SYSTEM

'Internal Working of program
' the 7 piles where the cards are placed in reverse order are called as rows
' the cards in hand are called as draw pile
' the final destination of the cards (4 piles) are called as final piles
' global variables take care of cards present in the piles
' as well as the lastcards in them
' there is arr deck, which consists of cards of type cardtype which keep
' track of each card's row, col, parameter, value, suit etc
' a card is identified by a number from 1 to 52, in which spades, hearts
' clubs and diamonds are kept in increasing order respectively
' paramter is free or restricted where restricted maens the card cannot be
' displayed below constraint constant and free can be disp everywhere
' carddraw and carderase are customized to obey this rule.
' the row cards are restricted because they are not to be displayed below
' constraint because dpiles and fpiles are drawn there. Other cards are free
' there is a secret key ctrl+rgt arrow which renews the pos of cards in dpile
' Card subs are responsible for drawing the cards
' Colour sets the colour acc to screen return values
' Dpile, Fpile, Row subs take care of entities mentioned in their names
' Intro displays the name of game before game starts

REM $STATIC
'
SUB CardBox (r1, c1, r2, c2, brdrcol, concol, Zedge)

wide = c2 - c1 - 1

colour brdrcol

'*print horizontal lines
LOCATE r2, c1
PRINT MID$(Zedge, 3, 1); STRING$(wide, MID$(Zedge, 5, 1)); MID$(Zedge, 4, 1);
LOCATE r1, c1
PRINT MID$(Zedge, 1, 1); STRING$(wide, MID$(Zedge, 5, 1)); MID$(Zedge, 2, 1);

'*print vertical lines
FOR a = (r1 + 1) TO (r2 - 1)
    LOCATE a, c1
    PRINT MID$(Zedge, 6, 1);
    LOCATE a, c2: PRINT MID$(Zedge, 6, 1);
NEXT a

'*paint interior
colour concol

FOR a = (r1 + 1) TO (r2 - 1)
    LOCATE a, c1 + 1
    PRINT SPACE$(wide);
NEXT

colour NORMAL

END SUB

'   Store behind screen and draw the card
SUB CardDraw (cardnum)

r1 = deck(cardnum).row: c1 = deck(cardnum).col
r2 = r1 + CARDHEIGHT - 1: c2 = c1 + CARDWIDTH - 1

'*store screen in memory
FOR a = 1 TO CARDHEIGHT
    FOR b = 1 TO CARDWIDTH
        p = r1 + a - 1: q = c1 + b - 1
        IF deck(cardnum).parameter = RESTRICTED THEN
            IF p > CONSTRAINT THEN GOTO escape  'not to store screen behind
        END IF
        memory(cardnum, a, b).char = CHR$(SCREEN(p, q, 0))
        memory(cardnum, a, b).colour = CHR$(SCREEN(p, q, 1))
    NEXT
NEXT
escape:   'just a way to come out of the nested FOR loops

'*draw box
IF deck(cardnum).parameter = RESTRICTED THEN
    IF r2 > CONSTRAINT THEN r2 = CONSTRAINT
END IF
SELECT CASE deck(cardnum).status
    CASE FACEUP:    CardBox r1, c1, r2, c2, FUCARDBOR, FUCARDCON, FUCARDLINE
    CASE FACEDOWN:  CardBox r1, c1, r2, c2, FDCARDBOR, FDCARDCON, FDCARDLINE
END SELECT

'*if face down, then names do not appear
IF deck(cardnum).status = FACEDOWN THEN EXIT SUB

'*display names at lefttop corner and rightbottom corner
SELECT CASE deck(cardnum).suit
    CASE 1, 3:  colour 112
    CASE 2, 4:  colour 116
END SELECT
'colour FUCARDCON
LOCATE r1 + 1, c1 + 1
PRINT deck(cardnum).suitstr; deck(cardnum).valstr;
IF deck(cardnum).value = 10 THEN
    LOCATE r2 - 1, c2 - 3
ELSE
    LOCATE r2 - 1, c2 - 2
END IF
PRINT deck(cardnum).suitstr; RTRIM$(deck(cardnum).valstr);

'*display name on the top line
'colour FUCARDBOR
IF deck(cardnum).value = 10 THEN
    LOCATE r1, c2 - 3
ELSE
    LOCATE r1, c2 - 2
END IF
PRINT deck(cardnum).suitstr; RTRIM$(deck(cardnum).valstr);

colour NORMAL

END SUB

'       Release memory
SUB CardErase (cardnum)

r = deck(cardnum).row: c = deck(cardnum).col

FOR a = 1 TO CARDHEIGHT
    LOCATE r + a - 1, c
    FOR b = 1 TO CARDWIDTH
        colour ASC(memory(cardnum, a, b).colour)
        PRINT memory(cardnum, a, b).char;
    NEXT
    IF deck(cardnum).status = RESTRICTED THEN
        IF (r + a - 1) = CONSTRAINT THEN EXIT FOR
    END IF
NEXT

END SUB

' it sets the col colour acc to SCREEN return values
SUB colour (col)

IF col <= 127 THEN
    COLOR col MOD 16, col \ 16
ELSE
    col = col - 128
    COLOR (col MOD 16) + 16, col \ 16
END IF

END SUB

' this moves the cursor acc to the key pressed received as parameter1
' The positions are as: (var curpos keeps track of it)
'       1 to 7 for rows, 8 to 11 for finalpiles, 12 to 13 for drawpile
' upordown keeps track of whether cursor is on all the faceup cards
' in the row or the only the topmost card
' paramter2: ONLYERASE,ONLYDRAW,NORMAL
SUB CursorNext (curpos, upordown, parameter1, parameter2)

STATIC prevrow, prevcol, prevcolour, prevchar$  'store screen behind

'*erase previous cursor
IF parameter2 <> ONLYDRAW THEN
    colour prevcolour
    LOCATE prevrow, prevcol: PRINT prevchar$;
END IF
IF parameter2 = ONLYERASE THEN EXIT SUB

'*decide on next position of cursor
SELECT CASE parameter1
    CASE START:     'no change
    CASE LEFT:  IF curpos = 1 THEN curpos = 13 ELSE curpos = curpos - 1
    CASE RIGHT: IF curpos = 13 THEN curpos = 1 ELSE curpos = curpos + 1
    CASE UP:
        SELECT CASE curpos
            CASE 1 TO 7:    upordown = UP
            CASE 8 TO 11:   curpos = curpos - 7
            CASE 12 TO 13:  curpos = curpos - 6
        END SELECT
    CASE DOWN:
        IF curpos >= 1 AND curpos <= 7 THEN
            IF upordown = UP THEN
                upordown = DOWN
            ELSE
                IF curpos <= 5 THEN inc = 7 ELSE inc = 6
                curpos = curpos + inc
            END IF
        END IF
END SELECT

'*find new cursor screen coordinates
SELECT CASE curpos
    CASE 1 TO 7:
        IF rowlastcard(curpos) = 0 THEN
            r = 4: c = ((curpos - 1) * 11) + 7
        ELSE
            IF deck(row(curpos, rowlastcard(curpos))).status = FACEDOWN THEN
                r = deck(row(curpos, rowlastcard(curpos))).row + 3
                c = deck(row(curpos, rowlastcard(curpos))).col + 4
            ELSE
                IF upordown = UP THEN
                    FOR a = 1 TO rowlastcard(curpos)
                        IF deck(row(curpos, a)).status = FACEUP THEN
                            firstfaceupcard = a
                            EXIT FOR
                        END IF
                    NEXT
                    r = deck(row(curpos, firstfaceupcard)).row
                    c = deck(row(curpos, firstfaceupcard)).col + 4
                ELSEIF upordown = DOWN THEN
                    r = deck(row(curpos, rowlastcard(curpos))).row + 3
                    c = deck(row(curpos, rowlastcard(curpos))).col + 4
                    IF r > CONSTRAINT THEN r = CONSTRAINT
                END IF
            END IF
        END IF
    CASE 8 TO 11:       r = FPILEROW + 1: c = 5 + ((curpos - 8) * 11)
    CASE 12:            r = DPILEROW + 1: c = DPILECOL + 4
    CASE 13:            r = 19: c = 74
END SELECT

'*draw new cursor
prevrow = r: prevcol = c
prevcolour = SCREEN(r, c, 1)
prevchar$ = CHR$(SCREEN(r, c, 0))

colour SCREEN(r, c, 1)
LOCATE r, c: PRINT CURSOR
colour NORMAL

END SUB

' if no card is drawn in the dpile base then this function will add
' the card in ans() var. This will happen only when the card picked up
' from the draw pile is returned.
' Otherwise any other attempt to add will yield a FALSE value since
' when the picked up card is placed anywhere a new card is drawn in drawpile
FUNCTION DPileAdd

' check the above mentioned conditions
DPileAdd = FALSE
IF SCREEN(DPILEROW + 1, DPILECOL + 1, 1) <> NORMAL THEN EXIT FUNCTION
IF dpilelastcard = 0 THEN EXIT FUNCTION 'no card in dpile.:.it is NORMAL col
DPileAdd = TRUE

'*draw the card again
CardDraw drawpile(dpilecurcard)

'there is no need to adjust memory as it has not been altered in DPileRemove

END FUNCTION

' It sets the next curcard of dpile adjusting screen display also
SUB DPileDraw

IF dpilelastcard <= 3 THEN EXIT SUB     'since this card does not vary

'*erase current card form screen
IF dpilecurcard THEN    'if it has been drawn
    CardErase drawpile(dpilecurcard)
END IF

'*adjust memory
IF dpilecurcard = dpilelastcard THEN
    dpilecurcard = 3
ELSE
    dpilecurcard = dpilecurcard + 3
    IF dpilecurcard > dpilelastcard THEN dpilecurcard = dpilelastcard
END IF

'*draw new current card
CardDraw drawpile(dpilecurcard)

END SUB

'if just now picked up dpile card has been placed then only this will run
'if available draw the next card adjusting screen
'and adjust memory removing the cur card which has been placed
SUB DPileNext

IF SCREEN(DPILEROW + 1, DPILECOL + 1, 1) <> NORMAL THEN EXIT SUB
IF dpilelastcard = 0 THEN NumOfCardsLeft: EXIT SUB

'*if cards finished so no need to draw next card
IF dpilelastcard = 1 THEN
    drawpile(1) = 0
    dpilecurcard = 0: dpilelastcard = 0
    EXIT SUB
END IF

'*adjust memory
FOR a = dpilecurcard TO dpilelastcard
    IF a = dpilelastcard THEN
        drawpile(a) = 0
    ELSE
        drawpile(a) = drawpile(a + 1)
    END IF
NEXT
dpilelastcard = dpilelastcard - 1
IF dpilecurcard = 1 THEN
    dpilecurcard = dpilelastcard
ELSE
    dpilecurcard = dpilecurcard - 1
END IF

'*draw next card on screen
CardDraw drawpile(dpilecurcard)

NumOfCardsLeft

END SUB

' if available erases the current card and return it into ans()
FUNCTION DPileRemove

DPileRemove = FALSE
IF dpilecurcard = 0 THEN EXIT FUNCTION  'no current draw pile card
DPileRemove = TRUE

'*adjust return values
ans(1) = drawpile(dpilecurcard)
ans(2) = 0

'*erase from screen
CardErase drawpile(dpilecurcard)

END FUNCTION

' To shift cards in the draw pile by one
' supposed to be a minor form of cheating
' but the key for this is secret and only persons knowing it can access this
SUB DPileShift

IF dpilelastcard < 2 THEN EXIT SUB

CardErase drawpile(dpilecurcard)

temp = drawpile(1)
FOR a = 1 TO dpilelastcard - 1
    drawpile(a) = drawpile(a + 1)
NEXT
drawpile(dpilelastcard) = temp

CardDraw drawpile(dpilecurcard)

END SUB

'draws the game scren
SUB DrawScreen

CLS
colour BACKGRCOL
FOR a = 1 TO 25
    LOCATE a, 1: PRINT STRING$(80, " ");
NEXT
LOCATE , , 0        'render cursor invisible throughout the program

'*draw bases for final piles
FOR a = 1 TO 4
    c1 = ((a - 1) * 11) + 1
    CardBox FPILEROW, c1, FPILEROW + 7, c1 + 8, NORMAL, NORMAL, SINGLELINE
    LOCATE FPILEROW + 2, c1 + 3: PRINT "Put";
    LOCATE FPILEROW + 3, c1 + 4: PRINT deck(13 * a).suitstr;
    LOCATE FPILEROW + 4, c1 + 2: PRINT "cards"
    LOCATE FPILEROW + 5, c1 + 2: PRINT "here."
NEXT

'*draw base for facing up card of draw pile
CardBox DPILEROW, DPILECOL, DPILEROW + 7, DPILECOL + 8, NORMAL, NORMAL, SINGLELINE
LOCATE DPILEROW + 2, DPILECOL + 1: PRINT "This is"
LOCATE DPILEROW + 3, DPILECOL + 1: PRINT " draw  "
LOCATE DPILEROW + 4, DPILECOL + 1: PRINT " pile. "
CardBox 18, 71, 20, 76, NORMAL, REVERSE, SINGLELINE
colour REVERSE
LOCATE 19, 72: PRINT "DRAW"

'*draw bases for rows
FOR a = 1 TO 7
    b = 3 + ((a - 1) * 11)
    CardBox 1, b, 8, b + 8, NORMAL, NORMAL, SINGLELINE
NEXT

'*draw all rows of deck
FOR a = 1 TO 7
    RowDraw a
NEXT

'*print name of game
CardBox 20, 44, 24, 58, NORMAL, BRIGHT, DOUBLELINE
colour BRIGHT
LOCATE 21, 45: PRINT "Gaurang's   "
LOCATE 23, 45: PRINT "   SOLITAIRE "

'*print no of cards left and up
t = NumOfCardsUp
NumOfCardsLeft

END SUB

' adds a card to the fpile by rules & checks for game win
FUNCTION FPileAdd (num)

'*is it correct by rules?
FPileAdd = FALSE
IF ans(2) <> 0 THEN EXIT FUNCTION   'more than one cards are in hand
IF deck(ans(1)).suit <> num THEN EXIT FUNCTION
IF deck(ans(1)).value <> (fpilelastcard(num) + 1) THEN EXIT FUNCTION
FPileAdd = TRUE
IF flag THEN flag = FALSE

'*draw the new card
fpilelastcard(num) = fpilelastcard(num) + 1
deck(ans(1)).row = FPILEROW
deck(ans(1)).col = 1 + ((num - 1) * 11)
deck(ans(1)).status = FACEUP
deck(ans(1)).parameter = FREE
CardDraw ans(1)

IF NumOfCardsUp = 52 THEN GameWon

END FUNCTION

'after a game ends either by aborting of game or after winning game
SUB GameEnd

CLS
colour NORMAL

PRINT "Do you want to play again?(Y/N)"
DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    char$ = UCASE$(char$)
LOOP UNTIL char$ = "Y" OR char$ = "N"

IF char$ = "Y" THEN RUN ELSE SYSTEM

END SUB

' Game is won
SUB GameWon

colour BRIGHT
LOCATE 15, 10: PRINT "You won! Press a key..."
SLEEP
GameEnd

END SUB

'   put random cards into drawpile and row arrays, initializing vars
SUB Initialize

DIM temp(1 TO 52)

'*initialize suit and value of all cards
FOR a = 1 TO 4
    FOR b = 1 TO 13
        c = ((a - 1) * 13) + b
        deck(c).suit = a
        deck(c).value = b
        SELECT CASE deck(c).suit
            CASE 1:     deck(c).suitstr = CHR$(6)
            CASE 2:     deck(c).suitstr = CHR$(3)
            CASE 3:     deck(c).suitstr = CHR$(5)
            CASE 4:     deck(c).suitstr = CHR$(4)
        END SELECT
        SELECT CASE deck(c).value
            CASE 1:         deck(c).valstr = "A"
            CASE IS <= 9:   deck(c).valstr = LTRIM$(STR$(deck(c).value)) + " "
            CASE 10:        deck(c).valstr = "10"
            CASE 11:        deck(c).valstr = "J "
            CASE 12:        deck(c).valstr = "Q "
            CASE 13:        deck(c).valstr = "K "
        END SELECT
    NEXT
NEXT

'*fill random cards into row and drawpile arrays
'*accordingly initializing them
a = 1: b = 1: c = 1: part = 1
RANDOMIZE TIMER
DO
    rand = INT(RND * 52) + 1
    IF NOT temp(rand) THEN
        temp(rand) = TRUE
        SELECT CASE part
            CASE 1:   'row
                row(a, b) = rand
                deck(rand).parameter = RESTRICTED
            CASE 2:   'drawpile
                drawpile(c) = rand
                deck(rand).parameter = FREE
                deck(rand).status = FACEUP
                deck(rand).row = DPILEROW
                deck(rand).col = DPILECOL
        END SELECT
        IF part = 1 THEN
            IF b = a THEN
                rowlastcard(a) = a
                deck(row(a, b)).status = FACEUP
                IF a = 7 THEN
                    RANDOMIZE TIMER   'part 1 job over
                    part = 2         ' so switch to part 2
                ELSE
                    a = a + 1:  b = 1   'another row
                END IF
            ELSE
                deck(row(a, b)).status = FACEDOWN
                b = b + 1
            END IF
        ELSE
            IF c = 24 THEN EXIT DO
            c = c + 1
        END IF
    END IF
LOOP

FOR a = 1 TO 4
    fpilelastcard(a) = 0
    FOR b = 1 TO 13
        finalpile(a, b) = 0
    NEXT
NEXT

dpilecurcard = 0
dpilelastcard = 24
flag = FALSE

END SUB

' displays intro screen
SUB Intro

CLS

'*generate random dots
RANDOMIZE TIMER
i = 0: del = 500
DO WHILE i < 1000
    i = i + 1
    GOSUB Delay
    row = INT(RND * 25) + 1
    col = INT(RND * 80) + 1
    LOCATE row, col: PRINT "";
LOOP

IF INKEY$ <> "" THEN GOTO endsub

'*make "gaurang's" condense and expand
r = 10: c = 31: del = 9500
strng1$ = "G a u r a n g ' s": strng2$ = "s ' g n a r u a G"
LOCATE r, c: PRINT strng1$
GOSUB Delay
t = LEN(strng1$) \ 2
FOR b = 1 TO 4
    IF INKEY$ <> "" THEN GOTO endsub
    IF b = 2 OR b = 3 THEN strng$ = strng2$ ELSE strng$ = strng1$
    IF b MOD 2 = 1 THEN u = 1: v = t: w = 1 ELSE u = t: v = 1: w = -1
    FOR a = u TO v STEP w
        GOSUB Delay
        LOCATE r, c: PRINT SPACE$(a); LEFT$(strng$, t + 1 - a);
        LOCATE r, c + t + 1: PRINT RIGHT$(strng$, t + 1 - a); SPACE$(a);
    NEXT
NEXT b
LOCATE r, c: PRINT strng1$;

'*write solitair
strng$ = " S O L I T A I R E"
r = 15: c = 29: del = 4000
FOR a = LEN(strng$) TO 1 STEP -1
    IF INKEY$ <> "" THEN GOTO endsub
    LOCATE r, c
    d$ = MID$(strng$, a, 1)
    FOR b = c TO (c + a - 1)
        GOSUB Delay
        PRINT d$;
    NEXT
NEXT

'*draw cards in design
del = 4000
FOR a = 1 TO 17
    GOSUB Delay
    CardBox a, 10, a + CARDHEIGHT - 1, 10 + CARDWIDTH - 1, NORMAL, NORMAL, SINGLELINE
    CardBox 18 - a, 61, 18 - a + CARDHEIGHT - 1, 61 + CARDWIDTH - 1, GREY, GREY, SINGLELINE
NEXT
FOR a = 19 TO 53 STEP 2
    GOSUB Delay
    CardBox 1, 71 - a, 1 + CARDHEIGHT - 1, 71 - a + CARDWIDTH - 1, GREY, GREY, SINGLELINE
    CardBox 17, a, 17 + CARDHEIGHT - 1, a + CARDWIDTH - 1, NORMAL, NORMAL, SINGLELINE
NEXT

'end
LOCATE 25, 1
PRINT "Press any key...";
SLEEP

endsub:      'free inkey buffer and end intro on press of a key
    DO
        char$ = INKEY$
    LOOP UNTIL char$ = ""

EXIT SUB

Delay:       'causes delay acc to del variable
    FOR x = 1 TO del: NEXT
    RETURN

END SUB

' Checks whether the card2 can be placed in row r
FUNCTION IsValid (r, card2)

IsValid = FALSE

IF flag THEN
    'a single card had been picked,allow it to be put on it's init row only
    IF flag = r THEN IsValid = TRUE: flag = FALSE 'card is being returned
    EXIT FUNCTION
END IF

IF rowlastcard(r) = 0 THEN
    'no card in row
    b = 3 + ((r - 1) * 11)
    IF SCREEN(3, b + 1, 0) <> 32 THEN
        'sentence written indicating that only kings can be placed there
        IF deck(card2).value = 13 THEN IsValid = TRUE
    ELSE
        'last card is being returned to this row and it needs not be a king
        IsValid = TRUE
    END IF
    EXIT FUNCTION
END IF

IF deck(row(r, rowlastcard(r))).status = FACEDOWN THEN
    IsValid = TRUE      'card is being returned
    EXIT FUNCTION
END IF

'*check acc to game rules
card1 = row(r, rowlastcard(r))
suit1 = deck(card1).suit: value1 = deck(card1).value
suit2 = deck(card2).suit: value2 = deck(card2).value

IF suit1 = suit2 THEN EXIT FUNCTION
IF (suit1 = 1 AND suit2 = 3) OR (suit1 = 3 AND suit2 = 1) THEN EXIT FUNCTION
IF (suit1 = 2 AND suit2 = 4) OR (suit1 = 4 AND suit2 = 2) THEN EXIT FUNCTION
IF value1 - value2 <> 1 THEN EXIT FUNCTION

IsValid = TRUE

END FUNCTION

' The Main Routine of the game. The entire game runs here
SUB Main

Intro
Initialize
DrawScreen

'******* MAIN LOOP *****************

DIM curpos, upordown        'to keep track of cursor position
DIM selected                'selected card(s) or not
selected = FALSE
curpos = 1: upordown = DOWN

CursorNext curpos, upordown, SAME, ONLYDRAW
DPileDraw

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    SELECT CASE char$
        CASE CHR$(0) + "H": CursorNext curpos, upordown, UP, NORMAL
        CASE CHR$(0) + "P": CursorNext curpos, upordown, DOWN, NORMAL
        CASE CHR$(0) + "M": CursorNext curpos, upordown, RIGHT, NORMAL
        CASE CHR$(0) + "K": CursorNext curpos, upordown, LEFT, NORMAL
        CASE CHR$(27):      GameEnd
        CASE CHR$(0) + "t":
            CursorNext curpos, upordown, SAME, ONLYERASE
            DPileShift
            CursorNext curpos, upordown, SAME, ONLYDRAW
        CASE CHR$(13):  IF NOT selected THEN IF curpos = 13 THEN DPileDraw
        CASE CHR$(0) + CHR$(83):    'delete -- pick up cards
            IF NOT selected THEN
                CursorNext curpos, upordown, SAME, ONLYERASE
                IF ((curpos >= 1) AND (curpos <= 7)) THEN
                    IF upordown = UP THEN temp = REMOVEALL
                    IF upordown = DOWN THEN temp = REMOVEONE
                    IF RowRemove(curpos, temp) THEN selected = TRUE
                END IF
                IF curpos = 12 THEN IF DPileRemove THEN selected = TRUE
                CursorNext curpos, upordown, SAME, ONLYDRAW
            END IF
        CASE CHR$(0) + CHR$(82):    'insert -- place cards
            IF selected THEN
                CursorNext curpos, upordown, SAME, ONLYERASE
                IF ((curpos >= 1) AND (curpos <= 7)) THEN
                    IF RowAdd(curpos) THEN selected = FALSE
                END IF
                IF curpos >= 8 AND curpos <= 11 THEN
                    IF FPileAdd(curpos - 7) THEN selected = FALSE
                END IF
                IF curpos = 12 THEN
                    IF DPileAdd THEN selected = FALSE
                END IF
                IF NOT selected THEN    'card has been placed
                    FOR a = 1 TO 7      'so turn all top downface cards
                        RowTurnTopCard a
                    NEXT
                    DPileNext  'and if itwas a dpilecard then next dpile card
                END IF
                CursorNext curpos, upordown, SAME, ONLYDRAW
            END IF
    END SELECT
   
    PrintSelCard selected  'if selected then print the selected card on screen

LOOP

END SUB

'prints the number of cards left in the draw pile
SUB NumOfCardsLeft

colour BACKGRCOL
LOCATE 25, 70: PRINT "Left:";
LOCATE 25, 75: PRINT LTRIM$(STR$(dpilelastcard));
IF POS(0) <> 80 THEN PRINT " ";
colour NORMAL

END SUB

'prints the number of cards in all fpile together and returns it
FUNCTION NumOfCardsUp

total = fpilelastcard(1) + fpilelastcard(2) + fpilelastcard(3) + fpilelastcard(4)
NumOfCardsUp = total

colour BACKGRCOL
LOCATE 25, 44: PRINT "Up:";
LOCATE 25, 47: PRINT LTRIM$(STR$(total));
colour NORMAL

END FUNCTION

'prints the selected card on screen
SUB PrintSelCard (selected)

IF selected THEN
    LOCATE 18, 46
    colour 64
    PRINT "In Hand: "; deck(ans(1)).suitstr; deck(ans(1)).valstr
ELSE
    LOCATE 18, 46
    colour BACKGRCOL
    PRINT "             ";
END IF

colour NORMAL

END SUB

' add card(s) to row num
FUNCTION RowAdd (num)

'*check whether the adding is according to rules
RowAdd = FALSE
IF NOT IsValid(num, ans(1)) THEN EXIT FUNCTION
RowAdd = TRUE

'*how many cards to add
FOR a = 1 TO 14
    IF ans(a) = 0 THEN cardstoadd = a - 1: EXIT FOR
NEXT

'*check whether there is need to change the drawing mode of a row
changemode = FALSE
IF rowlastcard(num) <= MAXCARDS AND (rowlastcard(num) + cardstoadd) > MAXCARDS THEN
    changemode = TRUE 'there is need to change the drawing mode
END IF          'so we will erase and redraw the complete row

'*add

IF changemode THEN RowErase num

FOR i = 1 TO cardstoadd
    'adjust screen display
    IF NOT changemode THEN
        IF rowlastcard(num) THEN
            deck(ans(i)).row = deck(row(num, rowlastcard(num))).row + 1
            deck(ans(i)).col = deck(row(num, rowlastcard(num))).col
        ELSE    'no card in row
            deck(ans(i)).row = 1
            deck(ans(i)).col = 3 + ((num - 1) * 11)
        END IF
        deck(ans(i)).status = FACEUP
        deck(ans(i)).parameter = RESTRICTED
        CardDraw ans(i)
    END IF

    'adjust row var in memory
    rowlastcard(num) = rowlastcard(num) + 1
    row(num, rowlastcard(num)) = ans(i)
NEXT

IF changemode THEN
    FOR a = 1 TO cardstoadd
        deck(ans(a)).status = FACEUP
        deck(ans(a)).parameter = RESTRICTED
    NEXT
    RowDraw num
END IF

END FUNCTION

' Draws a asked row of cards.
SUB RowDraw (num)

IF rowlastcard(num) = 0 THEN EXIT SUB

r = 1: c = 3 + ((num - 1) * 11)

IF rowlastcard(num) <= MAXCARDS THEN    'cards fit in the available space
    FOR i = 1 TO rowlastcard(num)
       deck(row(num, i)).row = r + i - 1   'set row and col elements
       deck(row(num, i)).col = c           'of the card to be drawn.
       deck(row(num, i)).parameter = RESTRICTED
       CardDraw row(num, i)                 'draw
    NEXT
    EXIT SUB
END IF

'*if rowlastcard(num) is greater than MAXCARDS then cannot fit the screen

'find number of cards facing down and print it on the top
facedowncount = 0
DO
    IF deck(row(num, facedowncount + 1)).status = FACEDOWN THEN
        facedowncount = facedowncount + 1
        deck(row(num, facedowncount)).row = 0
        deck(row(num, facedowncount)).col = 0
        IF facedowncount = rowlastcard(num) THEN EXIT DO
    ELSE
        EXIT DO
    END IF
LOOP
LOCATE 1, c: PRINT "Closed="; LTRIM$(STR$(facedowncount));
   
'draw the rest of the cards
FOR i = (facedowncount + 1) TO rowlastcard(num)
    deck(row(num, i)).row = r + i - facedowncount
    deck(row(num, i)).col = c
    deck(row(num, i)).parameter = RESTRICTED
    CardDraw row(num, i)
NEXT

END SUB

'Erases all the cards in the row
SUB RowErase (num)

i = rowlastcard(num)
DO WHILE i <> 0
    IF deck(row(num, i)).row = 0 THEN    'row is in condensed form
        b = 3 + ((num - 1) * 11)  'redraw the damaged row base box
        CardBox 1, b, 8, b + 8, NORMAL, NORMAL, SINGLELINE
        'PRINT ""; STRING$(CARDWIDTH - 2, ""); ""
        EXIT DO
    ELSE
        CardErase row(num, i)
    END IF
    i = i - 1
LOOP

END SUB

'ONE means remove one card from top of row
'REMOVEALL means remove all face up cards from the top of the row
FUNCTION RowRemove (num, parameter)

RowRemove = FALSE
IF rowlastcard(num) = 0 THEN EXIT FUNCTION      'empty row
RowRemove = TRUE

'*find number of cards to remove
FOR a = 1 TO rowlastcard(num)
    IF deck(row(num, a)).status = FACEUP THEN EXIT FOR
NEXT
firstfaceupcard = a
IF parameter = REMOVEALL THEN
    cardstoremove = rowlastcard(num) - firstfaceupcard + 1
ELSE
    cardstoremove = 1
END IF

'*check whether there is need to change the drawing mode of row
changemode = FALSE
IF rowlastcard(num) > MAXCARDS AND (rowlastcard(num) - cardstoremove) <= MAXCARDS THEN
    changemode = TRUE 'there is need to change the drawing mode
END IF          'so we will erase and redraw the complete row

IF changemode THEN RowErase num

SELECT CASE parameter
   
    CASE REMOVEONE:
        '*if picked up one of many faceup cards available then
         'then adjust flag so that it cannot be put on another row
        IF (rowlastcard(num) - firstfaceupcard + 1) > cardstoremove THEN
            flag = num
        END IF
      
       '*adjust return values
        ans(1) = row(num, rowlastcard(num)): ans(2) = 0
       
       '*erase card from screen
        IF NOT changemode THEN
            CardErase row(num, rowlastcard(num))
        END IF
      
       '*adjust row variables in memory
        row(num, rowlastcard(num)) = 0
        rowlastcard(num) = rowlastcard(num) - 1

    CASE REMOVEALL:
       '*erase each card from first face up card to last card
            'adjust return values
            FOR a = firstfaceupcard TO rowlastcard(num)
                ans(a - firstfaceupcard + 1) = row(num, a)
            NEXT
            ans(rowlastcard(num) - firstfaceupcard + 2) = 0
            
            'erase each card from screen
            IF NOT changemode THEN
                FOR a = rowlastcard(num) TO firstfaceupcard STEP -1
                    CardErase row(num, a)
                NEXT
            END IF

            'adjust row variables in memory
            FOR a = firstfaceupcard TO rowlastcard(num)
                row(num, a) = 0
            NEXT
            rowlastcard(num) = firstfaceupcard - 1
END SELECT

IF changemode THEN RowDraw num

END FUNCTION

'Turn top card if facedown. Done automatically after a user has placed a card
SUB RowTurnTopCard (num)

IF rowlastcard(num) = 0 THEN
    b = 3 + ((num - 1) * 11)    'all cards in a row have been placed
    LOCATE 3, b + 1: PRINT "You can"; 'so write the leftmentioned sentence
    LOCATE 4, b + 1: PRINT " put a "; 'which will be used while checking
    LOCATE 5, b + 1: PRINT " KING  "; 'an attempt to place a card there
    LOCATE 6, b + 1: PRINT " here  "; 'later on
    EXIT SUB
END IF

IF deck(row(num, rowlastcard(num))).status = FACEUP THEN EXIT SUB

CardErase row(num, rowlastcard(num))
deck(row(num, rowlastcard(num))).status = FACEUP
CardDraw row(num, rowlastcard(num))

END SUB

