DEFINT A-Z
CONST INITIAL = 1, SHUFFLE = 2
CONST TRUE = -1, FALSE = 0

DIM SHARED grid(1 TO 4, 1 TO 4)
DIM SHARED emphole AS STRING * 2

DECLARE SUB Arrange (func)
DECLARE SUB DrawGrid ()
DECLARE SUB PlaceNumbers ()
DECLARE SUB Place (r, c, num)
DECLARE SUB PlayGame ()
DECLARE SUB EndGame ()
DECLARE FUNCTION Row ()
DECLARE FUNCTION Col ()
DECLARE FUNCTION add$ (num1, num2)
DECLARE FUNCTION Won ()

Arrange SHUFFLE
DrawGrid
PlaceNumbers
PlayGame

FUNCTION add$ (num1, num2)

add$ = LTRIM$(STR$(num1)) + LTRIM$(STR$(num2))

END FUNCTION

SUB Arrange (func)

FOR a = 1 TO 4: FOR b = 1 TO 4
    grid(a, b) = -1
NEXT b, a

FOR a = 1 TO 4
    FOR b = 1 TO 4
        SELECT CASE func
            CASE INITIAL: 
                num = ((a - 1) * 4) + b
                IF num = 16 THEN
                    grid(a, b) = 0
                    emphole = add$(a, b)
                ELSE
                    grid(a, b) = num
                END IF

            CASE SHUFFLE: 
                DO
                    RANDOMIZE TIMER
                    num = INT(RND * 16)
                    flag = FALSE
                    FOR c = 1 TO 4: FOR d = 1 TO 4
                        IF num = grid(c, d) THEN flag = TRUE
                    NEXT d, c
                    IF flag = FALSE THEN
                        grid(a, b) = num
                        IF num = 0 THEN
                            emphole = add$(a, b)
                        END IF
                        EXIT DO
                    END IF
                LOOP
        END SELECT
    NEXT
NEXT

END SUB

FUNCTION Col
Col = VAL(RIGHT$(emphole, 1))
END FUNCTION

SUB DrawGrid

    CLS
    FOR a = 1 TO 5
        FOR b = 1 TO 4
            LOCATE 8 + b * 2, 30 + a * 3
            PRINT ""
        NEXT
    NEXT
    FOR a = 1 TO 4
        FOR b = 1 TO 5
            LOCATE 7 + b * 2, 31 + a * 3
            PRINT ""
        NEXT
    NEXT

    LOCATE 1, 3: PRINT "R - Restart Game ; Esc - End Game"
END SUB

SUB EndGame

LOCATE 3, 1
PRINT "You Win!"
PRINT "Do you want to play again (Y/N)"
DO: ans$ = UCASE$(INKEY$): LOOP UNTIL (ans$ = "Y" OR ans$ = "N")
IF ans$ = "N" THEN SYSTEM ELSE RUN

END SUB

SUB Place (r, c, num)

LOCATE 8 + (r * 2), 31 + (c * 3)
IF num = 0 THEN
    PRINT "  "
ELSE
    PRINT USING "##"; num
END IF

END SUB

SUB PlaceNumbers

FOR a = 1 TO 4
    FOR b = 1 TO 4
        Place a, b, grid(a, b)
    NEXT
NEXT

END SUB

SUB PlayGame

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    flag = TRUE
    SELECT CASE char$
        CASE CHR$(0) + "H":     'up
            IF Row <> 4 THEN
                grid(Row, Col) = grid(Row + 1, Col)
                grid(Row + 1, Col) = 0
                emphole = add$(Row + 1, Col)
            END IF
        CASE CHR$(0) + "P":     'down
            IF Row <> 1 THEN
                grid(Row, Col) = grid(Row - 1, Col)
                grid(Row - 1, Col) = 0
                emphole = add$(Row - 1, Col)
            END IF
        CASE CHR$(0) + "K":     'left
            IF Col <> 4 THEN
                grid(Row, Col) = grid(Row, Col + 1)
                grid(Row, Col + 1) = 0
                emphole = add$(Row, Col + 1)
            END IF
        CASE CHR$(0) + "M":     'right
            IF Col <> 1 THEN
                grid(Row, Col) = grid(Row, Col - 1)
                grid(Row, Col - 1) = 0
                emphole = add$(Row, Col - 1)
            END IF
        CASE CHR$(27):  END
        CASE "R", "r":  RUN
        CASE ELSE:      flag = FALSE
    END SELECT
    IF flag THEN
        PlaceNumbers
        IF Won = TRUE THEN EndGame
    END IF
LOOP

END SUB

FUNCTION Row
Row = VAL(LEFT$(emphole, 1))
END FUNCTION

FUNCTION Won

flag = TRUE

FOR a = 1 TO 4: FOR b = 1 TO 4
    IF a <> 4 OR b <> 4 THEN
        IF grid(a, b) <> (((a - 1) * 4) + b) THEN
            flag = FALSE
        END IF
    END IF
NEXT b, a

Won = flag

END FUNCTION

