'' GAME OF LIFE:
'    a starting pattern is selected
'  Every cell has 8 neighbours.
'  A cell is either living or dead
'  If a living cell has 2 or 3 neighbours then it continues to live
'  otherwise it dies
'  If a dead cell has 3 neighbours then it is born and starts living
'  Thus this process continues

DEFINT A-Z
CONST TRUE = -1, FALSE = 0
CONST ASCDOWNCLL = 220, ASCUPCLL = 223, ASCFULLCLL = 219
CONST DOWNCELL = "", UPCELL = "", FULLCELL = ""

DECLARE SUB Main ()
DECLARE SUB CellDraw (r, c)
DECLARE SUB CellErase (r, c)
DECLARE SUB CellNextState (r, c)
DECLARE SUB GenerationNext ()
DECLARE SUB ArenaDisp ()
DECLARE SUB ArenaInitiate ()
DECLARE SUB ScreenDraw ()
DECLARE SUB GameEnd ()
DECLARE SUB SetArenaBoundaries ()
DECLARE FUNCTION OccupiedRow (r)
DECLARE FUNCTION OccupiedColumn (c)
DECLARE FUNCTION CellNeighbours (r, c)

DIM SHARED Arena(1 TO 50, 1 TO 80)
DIM SHARED ArenaTemp(1 TO 50, 1 TO 80)
DIM SHARED r1, c1, r2, c2

Main

SYSTEM

SUB ArenaDisp

FOR a = r1 TO r2
FOR b = c1 TO c2
    IF Arena(a, b) THEN CellDraw a, b
NEXT
NEXT

END SUB

SUB ArenaInitiate

pattern$ = "InvU"

SELECT CASE pattern$
    CASE "InvU"
        Arena(24, 39) = TRUE: Arena(25, 39) = TRUE: Arena(26, 39) = TRUE
        Arena(24, 40) = TRUE
        Arena(24, 41) = TRUE: Arena(25, 41) = TRUE: Arena(26, 41) = TRUE
        r1 = 1: c1 = 1: r2 = 50: c2 = 80
        'r1 = 24: r2 = 26: c1 = 39: c2 = 41
    CASE "Semaphore"
        Arena(24, 40) = TRUE: Arena(25, 40) = TRUE: Arena(26, 40) = TRUE
        r1 = 24: r2 = 26: c1 = 40: c2 = 40
    CASE "Block"
        Arena(24, 39) = TRUE: Arena(24, 40) = TRUE
        Arena(25, 39) = TRUE: Arena(25, 40) = TRUE
        r1 = 24: r2 = 25: c1 = 39: c2 = 40
    CASE "Stable"
        Arena(24, 39) = TRUE: Arena(25, 39) = TRUE: Arena(26, 39) = TRUE
        Arena(26, 40) = TRUE: Arena(23, 40) = TRUE
        Arena(24, 41) = TRUE: Arena(25, 41) = TRUE: Arena(26, 41) = TRUE
        r1 = 23: r2 = 26: c1 = 39: c2 = 41
END SELECT

END SUB

SUB CellDraw (r, c)

x = (r + 1) \ 2
y = c
ch = SCREEN(x, y)
IF ch = ASCFULLCLL THEN EXIT SUB

LOCATE x, y
IF r MOD 2 = 1 THEN     'upper box
    IF ch = ASCDOWNCLL THEN PRINT FULLCELL;  ELSE PRINT UPCELL;
ELSE                    'lower box
    IF ch = ASCUPCLL THEN PRINT FULLCELL;  ELSE PRINT DOWNCELL;
END IF

END SUB

SUB CellErase (r, c)

x = (r + 1) \ 2
y = c
ch = SCREEN(x, y)
IF ch <> 219 AND ch <> 223 AND ch <> 220 THEN EXIT SUB

LOCATE x, y
IF r MOD 2 = 1 THEN     'upper box
    IF ch = ASCFULLCLL THEN PRINT DOWNCELL;
    IF ch = ASCUPCELL THEN PRINT " ";
ELSE                    'lower box
    IF ch = ASCFULLCLL THEN PRINT UPCELL;
    IF ch = ASCDOWNCLL THEN PRINT " ";
END IF

END SUB

FUNCTION CellNeighbours (r, c)

count = 0
FOR a = (r - 1) TO (r + 1)
FOR b = (c - 1) TO (c + 1)
    IF a > 0 AND a < 51 AND b > 0 AND b < 81 THEN
        IF Arena(a, b) THEN count = count + 1   'skip outofscreen coordinates
    END IF
NEXT b
NEXT a

IF Arena(r, c) THEN count = count - 1   'self counted

CellNeighbours = count

END FUNCTION

SUB CellNextState (r, c)

SELECT CASE Arena(r, c)
    CASE TRUE:
        n = CellNeighbours(r, c)
        IF n = 2 OR n = 3 THEN
            ArenaTemp(r, c) = TRUE
        ELSE
            ArenaTemp(r, c) = FALSE
        END IF
    CASE FALSE:
        n = CellNeighbours(r, c)
        IF n = 3 THEN
            ArenaTemp(r, c) = TRUE
        ELSE
            ArenaTemp(r, c) = FALSE
        END IF
END SELECT

END SUB

SUB GameEnd

CLS
SYSTEM

END SUB

SUB GenerationNext

FOR a = (r1 - 1) TO (r2 + 1)
    FOR b = (c1 - 1) TO (c2 + 1)
        IF a > 0 AND a < 51 AND b > 0 AND b < 81 THEN
            CellNextState a, b      'calculate next state for all cells
        END IF
    NEXT
NEXT

'SetArenaBoundaries

FOR a = 1 TO 50: FOR b = 1 TO 80
    Arena(a, b) = ArenaTemp(a, b)       'acknowledge current changes
NEXT b, a

CLS
ArenaDisp    'redraw arena

END SUB

SUB Main

ScreenDraw

ArenaInitiate
ArenaDisp

DO
'    DO: char$ = INKEY$: LOOP WHILE char$ = ""
'    IF char$ = CHR$(27) THEN
'        GameEnd
'    ELSE
        GenerationNext
'    END IF
LOOP

END SUB

FUNCTION OccupiedColumn (c)

OccupiedColumn = TRUE

FOR a = 1 TO 50
    IF ArenaTemp(a, c) THEN EXIT FUNCTION
NEXT

OccupiedColumn = FALSE

END FUNCTION

FUNCTION OccupiedRow (r)

OccupiedRow = TRUE

FOR b = 1 TO 80
    IF ArenaTemp(r, b) THEN EXIT FUNCTION
NEXT

OccupiedRow = FALSE

END FUNCTION

SUB ScreenDraw

CLS

END SUB

SUB SetArenaBoundaries
'r1 = 1: c1 = 1: r2 = 50: c2 = 80
EXIT SUB
'r1
IF OccupiedRow(r1 - 1) THEN
    r1 = r1 - 1
ELSE
    IF NOT OccupiedRow(r1) THEN r1 = r1 + 1
END IF

'r2
IF OccupiedRow(r2 + 1) THEN
    r2 = r2 + 1
ELSE
    IF NOT OccupiedRow(r2) THEN r2 = r2 - 1
END IF

'c1
IF OccupiedColumn(c1 - 1) THEN
    c1 = c1 - 1
ELSE
    IF NOT OccupiedColumn(c1) THEN c1 = c1 + 1
END IF

'c2
IF OccupiedColumn(c2 + 1) THEN
    c2 = c2 + 1
ELSE
    IF NOT OccupiedColumn(c2) THEN c2 = c2 - 1
END IF

END SUB

