'************ PROGRAM : DISPLAY BINARY FILE IN HEX **********

DEFINT A-Z
CONST CHARLINES = 10, CHARINLINE = 16
CONST CHARROW1 = 8, CHARCOL1 = 5, CHARCOLGAP = 3, CHARROWGAP = 1
CONST ASCCOL = 60
DIM SHARED filename AS STRING   'shared file(1 to filelength) has been
DIM SHARED filelength AS LONG   'declared in ReadFile gosub routine

DECLARE SUB Main ()
DECLARE SUB InitScreen ()
DECLARE SUB Show (startpos AS LONG)
DECLARE FUNCTION MyHex$ (dec AS INTEGER)
DECLARE FUNCTION MyChr$ (dec AS INTEGER)
DECLARE SUB ScrollDown (FirstByte AS LONG)
DECLARE SUB ScrollUp (FirstByte AS LONG)
DECLARE FUNCTION HexToDec (Hexa AS STRING)

'* get file name from user *
CLS
PRINT
PRINT " This program views a file in hex(usually for a binary file)."
PRINT
INPUT " Enter a filename: ", filename
ON ERROR GOTO ErrorHandler
    OPEN filename FOR INPUT AS #1
    CLOSE #1
ON ERROR GOTO 0

GOSUB Readfile

Main

SYSTEM

ErrorHandler: 'in case of error on opening file
    PRINT "Invalid File."
    SYSTEM

Readfile:   'to read file into memory
    PRINT "Reading "; filename; " ...";

    OPEN filename FOR BINARY AS #1
        filelength = LOF(1)
        IF filelength > 30000 THEN
            PRINT "File longer than 30,000 bytes!"
            SYSTEM
        END IF
        DIM SHARED file(1 TO filelength) AS STRING * 1
        FOR i = 1 TO filelength
            GET #1, i, file(i)
        NEXT
    CLOSE #1
   
    PRINT filelength; "bytes read."
    RETURN

FUNCTION HexToDec (Hexa AS STRING)

sum = 0

FOR a = 1 TO 2
    temp = ASC(MID$(Hexa, a, 1))
    SELECT CASE temp
        CASE 48 TO 57:      sum = sum + temp - 48
        CASE 65 TO 70:      sum = sum + temp - 55
        CASE 97 TO 102:     sum = sum + temp - 87
        CASE ELSE:          HexToDec = 0: EXIT FUNCTION
    END SELECT
    IF a = 1 THEN sum = sum * 16
NEXT
HexToDec = sum

END FUNCTION

SUB InitScreen

LOCATE 1, 1: PRINT "FILE: "; filename
LOCATE 2, 1: PRINT "FILE LENGTH: "; filelength

LOCATE CHARROW1 - 4, 1
PRINT "********** : File Position Of Cursor"

'* Upper line *
LOCATE CHARROW1 - 2
FOR x = 1 TO CHARINLINE
    LOCATE , CHARCOL1 + ((x - 1) * CHARCOLGAP)
    PRINT MyHex$(x - 1);
NEXT
LOCATE CHARROW1 - 1, CHARCOL1 - 1
PRINT STRING$(((CHARINLINE - 1) * CHARCOLGAP) + 4, "-")

'* Side Line *

FOR y = 1 TO CHARLINES
    LOCATE CHARROW1 + ((y - 1) * CHARROWGAP), CHARCOL1 - 4
    PRINT MyHex$(y - 1);
    PRINT TAB(CHARCOL1 - 1); "|"
NEXT
END SUB

SUB Main

DIM StartByte AS LONG
DIM currow, curcol
DIM Affected        'for flagging change to the file

StartByte = 1
currow = 0: curcol = 0

CLS
InitScreen
Show StartByte

DO
    LOCATE CHARROW1 - 4, 1
    PRINT USING "**########"; StartByte + currow * CHARINLINE + curcol
   
    LOCATE CHARROW1 - 4, 50
    PRINT "In decimal: ";
    IF (StartByte + currow * CHARINLINE + curcol) <= filelength THEN
        PRINT ASC(file(StartByte + currow * CHARINLINE + curcol)); "  ";
    ELSE
        PRINT "         ";
    END IF

    LOCATE CHARROW1 + currow * CHARROWGAP, CHARCOL1 + curcol * CHARCOLGAP, 1
   
    DO: CHAR$ = INKEY$: LOOP WHILE CHAR$ = ""
    SELECT CASE CHAR$
       
        CASE CHR$(0) + "P"
            IF currow < (CHARLINES - 1) THEN
                currow = currow + 1
            ELSE
                ScrollDown StartByte
            END IF
       
        CASE CHR$(0) + "H"
            IF currow > 0 THEN
                currow = currow - 1
            ELSE
                ScrollUp StartByte
            END IF

        CASE CHR$(0) + "M"
            IF curcol < (CHARINLINE - 1) THEN
                curcol = curcol + 1
            END IF
        CASE CHR$(0) + "K"
            IF curcol > 0 THEN
                curcol = curcol - 1
            END IF

        CASE "M", "m":
            LOCATE 20, 2
            INPUT "Enter the byte you want to see: ", seebyte
            IF seebyte < filelength THEN
                StartByte = (seebyte / CHARINLINE) * CHARINLINE
            END IF
            LOCATE 20, 2: PRINT SPACE$(79);
            Show StartByte
        CASE CHR$(13)
            IF NOT Affected THEN Affected = TRUE
            LOCATE 20, 2
            INPUT "Enter Replacement Byte In Ascii: ", a$
            file(StartByte + curcol + currow * CHARINLINE) = a$
            Show StartByte
            'file(StartByte + curcol + currow * CHARINLINE) = CHR$(HexToDec(a$))
            LOCATE 20, 2: PRINT SPACE$(79);
        CASE "s", "S":
            OPEN filename FOR OUTPUT AS #1
            FOR a& = 1 TO filelength
                PRINT #1, file(a&);
            NEXT
            CLOSE

        CASE CHR$(27)
            IF NOT Affected THEN SYSTEM
            LOCATE 20, 2
            INPUT "Write to file?(y/n): ", a$
            IF a$ = "Y" OR a$ = "y" THEN
                OPEN filename FOR OUTPUT AS #1
                FOR a& = 1 TO filelength
                    PRINT #1, file(a&);
                NEXT
                CLOSE
            END IF
            SYSTEM
    END SELECT
LOOP

END SUB

FUNCTION MyChr$ (dec AS INTEGER)

IF dec >= 32 AND dec <> 255 THEN
    MyChr$ = CHR$(dec)
ELSE
    MyChr$ = "."
END IF

END FUNCTION

FUNCTION MyHex$ (dec AS INTEGER)

temp$ = HEX$(dec)
IF LEN(temp$) = 1 THEN temp$ = "0" + temp$

MyHex$ = temp$

END FUNCTION

SUB ScrollDown (FirstByte AS LONG)

IF FirstByte > (filelength - CHARINLINE) THEN EXIT SUB

FirstByte = FirstByte + CHARINLINE
Show FirstByte

END SUB

SUB ScrollUp (FirstByte AS LONG)

IF FirstByte = 1 THEN EXIT SUB

FirstByte = FirstByte - CHARINLINE
Show FirstByte

END SUB

SUB Show (startpos AS LONG)

DIM curpos AS LONG, x, y

LOCATE , , 0
x = 1: curpos = startpos
DO
    y = 1
    DO
        LOCATE CHARROW1 + ((x - 1) * CHARROWGAP), CHARCOL1 + ((y - 1) * CHARCOLGAP)
       
        IF curpos > filelength THEN GOTO EndSub
        PRINT MyHex$(ASC(file(curpos)));
       
        LOCATE CHARROW1 + ((x - 1) * CHARROWGAP), ASCCOL + y - 1
        PRINT MyChr$(ASC(file(curpos)));
       
        curpos = curpos + 1
       
        IF y = CHARINLINE THEN EXIT DO
        y = y + 1
    LOOP
    IF x = CHARLINES THEN EXIT DO
    x = x + 1
LOOP

EXIT SUB

EndSub:
IF x <> CHARLINES OR y <> CHARINLINE THEN
    '*blank the remaining line*
    PRINT SPACE$((CHARINLINE - y) * CHARCOLGAP + 2);
    LOCATE , ASCCOL + y - 1
    PRINT SPACE$(CHARINLINE - y + 1)
    x = x + 1

    '*blank remaining lines*
    IF x <= CHARLINES THEN
        FOR i% = x TO CHARLINES
            LOCATE CHARROW1 + ((x - 1) * CHARROWGAP), CHARCOL1
            PRINT SPACE$(((CHARINLINE - 1) * CHARCOLGAP) + 2);
            LOCATE , ASCCOL
            PRINT SPACE$(CHARINLINE + 1);
        NEXT
    END IF
END IF

LOCATE , , 1
END SUB

