'CONTENT
'   This program contains subroutines cGET and cPUT  duplicating the
' functions of GET and PUT graphic statements to a certain extent.

'NOTE:
' 1> The GET and PUT library functions store pixels on the screen as bits.
' 2> Integers are alloted two bytes of memory space i.e. they are represented
' by 16 bits. The address given by VARPTR() library function is that of the
' second byte(less significant byte). The first byte(most significant byte)
' is stored in immediately following memory location. The first digit of
' first byte determines the sign of the number. If it is 1, the number is
' negative.
'   The actual storing of negative numbers is a little complicated.
' For converting decimal negative number into binary, the absolute value
' of the number is decreased by 1 and the binary value of the resulting
' number is fully toggled so that 1 automatically comes into the first bit
' position.
'   For converting binary form of negative decimal numbers, exactly
' reverse procedure is followed.
'   Technically speaking, numbers are stored in two-complement's notation.
'   This program contains nothing special although the routines for
' converting binary to decimal and vice versa may be useful in some
' programs.
'
'  Program : Gaurang Khetan

'variables and declarations of subs and funcs
DEFINT A-Z
DIM SHARED test(1 TO 100)
DIM SHARED test1(1 TO 100)
CONST TRUE = -1, FALSE = 0

DECLARE SUB cGET (c1, r1, c2, r2)
DECLARE SUB cPUT (c1, r1)
DECLARE FUNCTION InDec (ttstr$)
DECLARE FUNCTION InBin$ (num)
DECLARE FUNCTION Toggle$ (tstr$)

'code
CLS
SCREEN 2

CIRCLE (320, 100), 20
PAINT (320, 100), 1

cGET 300, 92, 340, 108
cPUT 300, 92

cPUT 1, 1

END

SUB cGET (c1, r1, c2, r2)

IF UBOUND(test, 1) < 3 THEN PRINT "Small Array": END

test(1) = c2 - c1 + 1: test(2) = r2 - r1 + 1
c = c1: r = r1: count = 2: flag = FALSE

DO
    count = count + 1
    tstr$ = ""
    FOR a = 1 TO 16
        tstr$ = tstr$ + LTRIM$(STR$(POINT(c, r)))
        IF c < c2 THEN
            c = c + 1
        ELSE
            IF r = r2 THEN flag = TRUE: EXIT FOR
            c = c1: r = r + 1
        END IF
    NEXT
    test(count) = InDec(tstr$)
    IF flag THEN EXIT SUB
    IF count = UBOUND(test, 1) THEN PRINT "Small Array": END
LOOP

END SUB

SUB cPUT (c1, r1)

c2 = c1 + test(1) - 1: r2 = r1 + test(2) - 1
c = c1: r = r1: count = 2: flag = FALSE

DO
    count = count + 1
    num = test(count)
    tstr$ = InBin$(num)
    FOR a = 1 TO 16
        col = VAL(MID$(tstr$, a, 1))
        IF col = 1 THEN
            IF POINT(c, r) = 1 THEN
                PSET (c, r), 0
            ELSEIF POINT(c, r) = 0 THEN
                PSET (c, r), 1
            END IF
        END IF
        IF c < c2 THEN
            c = c + 1
        ELSE
            IF r = r2 THEN flag = TRUE: EXIT SUB
            c = c1: r = r + 1
        END IF
    NEXT
LOOP

END SUB

FUNCTION InBin$ (num)

IF num < 0 THEN tnum = ABS(num): tnum = tnum - 1 ELSE tnum = num
tstr$ = ""

DO
    nextnum = tnum \ 2
    remainder = tnum MOD 2
    tstr$ = LTRIM$(STR$(remainder)) + tstr$
    IF nextnum = 0 THEN EXIT DO ELSE tnum = nextnum
LOOP

IF LEN(tstr$) < 16 THEN tstr$ = STRING$(16 - LEN(tstr$), "0") + tstr$

IF num < 0 THEN tstr$ = Toggle$(tstr$)

InBin$ = tstr$

END FUNCTION

FUNCTION InDec (ttstr$)

flag = FALSE
tstr$ = ttstr$

'if length is less than 16, then add following zeroes so as to make it 16
    IF LEN(tstr$) < 16 THEN tstr$ = tstr$ + STRING$(16 - LEN(tstr$), "0")

IF MID$(tstr$, 1, 1) = "1" THEN flag = TRUE: tstr$ = Toggle$(tstr$)

tot = 0
FOR a = 1 TO 16
    tot = tot + ((2 ^ (a - 1)) * VAL(MID$(tstr$, 17 - a, 1)))
NEXT

IF flag = TRUE THEN tot = -tot: tot = tot - 1

InDec = tot

END FUNCTION

FUNCTION Toggle$ (tstr$)

ttstr$ = tstr$

FOR a = 1 TO 16
    t$ = MID$(ttstr$, a, 1)
    IF t$ = "1" THEN
        t$ = "0"
    ELSE
        t$ = "1"
    END IF
    MID$(ttstr$, a, 1) = t$
NEXT

Toggle$ = ttstr$

END FUNCTION

