'' A Game

'data
DEFINT A-Z
CONST TRUE = -1, FALSE = 0
CONST EMPBOXROW = 5
CONST GRIDCOL = 105, GRIDROW = 36
CONST CELLWDTH = 24, CELLHGHT = 16
CONST RESULTCOL = GRIDCOL + (4 * CELLWDTH) + 10
CONST RESULTRAD = 4, RESULTDIFF = 15
CONST MAXSHAPES = 7

DECLARE SUB DrawScreen ()
DECLARE SUB DrawShape (row, col, shape)
DECLARE SUB CursorDraw (row, col)
DECLARE SUB CursorErase (row, col)
DECLARE SUB Reply (row, fullhits, halfhits)
DECLARE FUNCTION Tally (row, computer(), player())
DECLARE SUB Main ()
DECLARE SUB Disclose (computer())

ON ERROR GOTO ErrorHandler
DrawScreen                'trap error for screen mode(if not graphics scrn)
ON ERROR GOTO 0


Main


SYSTEM

ErrorHandler:
    PRINT "Error: "; ERR; " occured."
    SYSTEM

'
' This sub draws a highlight cursor at the given box
'
SUB CursorDraw (row, col)

x% = GRIDCOL + ((col - 1) * CELLWDTH)
IF row = 0 THEN y% = EMPBOXROW ELSE y% = GRIDROW + ((row - 1) * CELLHGHT)

LINE (x% + 1, y% + 1)-(x% + CELLWDTH - 1, y% + CELLHGHT - 1), 3, B

END SUB

'
' This sub erases the highlight cursor drawn by CursorDraw at given box
'
SUB CursorErase (row, col)

x = GRIDCOL + ((col - 1) * CELLWDTH)
IF row = 0 THEN y = EMPBOXROW ELSE y = GRIDROW + ((row - 1) * CELLHGHT)

LINE (x + 1, y + 1)-(x + CELLWDTH - 1, y + CELLHGHT - 1), 0, B

END SUB

'
'   This sub discloses the shapes selected randomly by the computer
'
SUB Disclose (computer())

FOR i% = 1 TO 4
    DrawShape 0, i%, computer(i%)
NEXT

END SUB

'
'   This sub draws the initial background screen consisting of grids.
'
SUB DrawScreen

CLS
SCREEN 1
COLOR 1

'draw 4 empty boxes
FOR i% = 1 TO 4
    x% = GRIDCOL + ((i% - 1) * CELLWDTH)
    LINE (x%, EMPBOXROW)-(x% + CELLWDTH, EMPBOXROW + CELLHGHT), , B
NEXT

'draw answer grid
FOR i% = 1 TO 4
    FOR j% = 1 TO 10
        x% = GRIDCOL + ((i% - 1) * CELLWDTH)
        y% = GRIDROW + ((j% - 1) * CELLHGHT)
        LINE (x%, y%)-(x% + CELLWDTH, y% + CELLHGHT), , B
    NEXT
NEXT

END SUB

'
' This sub draws the asked shape in the given box.
' Each shape is denoted by a number.
'
SUB DrawShape (row, col, shape)

DIM x AS INTEGER, y AS INTEGER

x = GRIDCOL + ((col - 1) * CELLWDTH)
IF row = 0 THEN y = EMPBOXROW ELSE y = GRIDROW + ((row - 1) * CELLHGHT)

SELECT CASE shape
   
    CASE 0
        LINE (x + 2, y + 2)-(x + CELLWDTH - 2, y + CELLHGHT - 2), 0, BF
   
    CASE 1
        CIRCLE (x + (CELLWDTH \ 2), y + (CELLHGHT \ 2)), (CELLWDTH \ 4) - 1, 2
   
    CASE 2
        CIRCLE (x + (CELLWDTH \ 2), y + (CELLHGHT \ 2)), (CELLWDTH \ 4) - 1, 2
        PAINT (x + (CELLWDTH \ 2), y + (CELLHGHT \ 2)), 1, 2
   
    CASE 3
        CIRCLE (x + (CELLWDTH \ 2), y + (CELLHGHT \ 2)), (CELLWDTH \ 4) - 1, 1
        PAINT (x + (CELLWDTH \ 2), y + (CELLHGHT \ 2)), 2, 1
   
    CASE 4
        LINE (x + 3, y + 3)-(x + CELLWDTH - 3, y + CELLHGHT - 3), 1, B
   
    CASE 5
        LINE (x + 3, y + 3)-(x + CELLWDTH - 3, y + CELLHGHT - 3), 1, B
        PAINT (x + 4, y + 4), 2, 1

    CASE 6
        LINE (x + 3, y + 3)-(x + CELLWDTH - 3, y + CELLHGHT - 3), 2, B
        PAINT (x + 4, y + 4), 1, 2

END SELECT

END SUB

'
'  MAIN LOOP OF PROGRAM
'
SUB Main

DIM hidden(1 TO 4)
DIM curshape(1 TO 4)

'put random values into the computer grid
RANDOMIZE TIMER
FOR i% = 1 TO 4
    hidden(i%) = INT(RND * MAXSHAPES)
NEXT

currow = 0
DO WHILE currow < 10
    currow = currow + 1
   
    curcol = 1
    curshape(1) = 0: curshape(2) = 0: curshape(3) = 0: curshape(4) = 0
    CursorDraw currow, curcol
    DO
        DO: char$ = INKEY$: LOOP WHILE char$ = ""
       
        SELECT CASE char$
           
            CASE CHR$(0) + "M"  'right
                CursorErase currow, curcol
                IF curcol < 4 THEN curcol = curcol + 1 ELSE curcol = 1
                CursorDraw currow, curcol
           
            CASE CHR$(0) + "K"  'left
                CursorErase currow, curcol
                IF curcol > 1 THEN curcol = curcol - 1 ELSE curcol = 4
                CursorDraw currow, curcol
           
            CASE CHR$(32)
                IF curshape(curcol) = (MAXSHAPES - 1) THEN
                    curshape(curcol) = 0
                ELSE
                    curshape(curcol) = curshape(curcol) + 1
                END IF
                DrawShape currow, curcol, 0    'erase previous shape
                DrawShape currow, curcol, curshape(curcol)
           
            CASE CHR$(13)   'enter
                CursorErase currow, curcol
                IF Tally(currow, hidden(), curshape()) THEN GOTO GameWon
                EXIT DO
            CASE CHR$(27)
                SYSTEM
        END SELECT
    LOOP
LOOP

GameLost:
    LOCATE 1, 1: PRINT "You Lost!"
    GOTO GameEnd

GameWon:
    LOCATE 1, 1: PRINT "You won!!"

GameEnd:
    Disclose hidden()
    LOCATE 2, 1
    PRINT "Play again?"
    a$ = UCASE$(INPUT$(1))
    IF a$ = "Y" THEN RUN ELSE SYSTEM

END SUB

'
'  This sub indicates the reply calculated by Tally in figures(circles)
'
SUB Reply (row, fullhits, halfhits)

IF fullhits = 0 AND halfhits = 0 THEN EXIT SUB

x% = RESULTCOL
y% = GRIDROW + ((row - 1) * CELLHGHT) + (CELLHGHT \ 2)
rad% = RESULTRAD

DO UNTIL ((fullhits = 0) AND (halfhits = 0))
    CIRCLE (x%, y%), rad%, 1
    IF fullhits THEN PAINT (x%, y%), 1, 1

    IF fullhits THEN fullhits = fullhits - 1 ELSE halfhits = halfhits - 1
    x% = x% + RESULTDIFF
LOOP

END SUB

'
' This function checks how many hits are present in the player's
' guess. It returns TRUE if all are fully correct i.e a win
'
FUNCTION Tally (row, computer(), player())

DIM half, full
DIM array1(1 TO 4), array2(1 TO 4)

half = 0: full = 0

'check for full hits
FOR i = 1 TO 4
    IF computer(i) = player(i) THEN
        full = full + 1
        array1(i) = TRUE: array2(i) = TRUE
    END IF
NEXT

'check for half hits
FOR i = 1 TO 4
    IF NOT array1(i) THEN
        FOR j = 1 TO 4
            IF NOT array2(j) THEN
                IF computer(i) = player(j) THEN
                    half = half + 1
                    array1(i) = TRUE: array2(j) = TRUE
                    EXIT FOR
                END IF
            END IF
        NEXT
    END IF
NEXT

IF full = 4 THEN Tally = TRUE ELSE Tally = FALSE

Reply row, full, half

END FUNCTION

