'
' CONTENT:
'   This encrypter can be used to encrypt files which can be decrypted using
' DECRYPT.BAS. It is a simple, easy-to-use program that uses the simplest
' technique to encrypt but is an effective tool.
'
' NOTE:
'   In this program, two things are to be observed:
'1> The use of environ variables and batch file arguments could
' be used to simulate arguments on the command-line. The batch file
' allows the use of arguments which could be used for assigning the
' special environment variables, eventually being read directly from
' Dos in the program. This serves as a very effective and attractive
' logic for using qbasic-interpreted code similar to a compiled code.
'2> The function FileValid() and the way it is used is noteworthy.
' It demonstrates how the existence of a file and validity of the
' filename can be checked through ON ERROR and OPEN commands.
'
'
'To encrypt Files
'Variables:
    DEFINT A-Z
    DIM SHARED filename AS STRING
    DIM SHARED newname AS STRING
    DIM SHARED password AS STRING
    DIM SHARED valid AS INTEGER
    CONST FALSE = 0, TRUE = -1
    CONST CHECKNAME = 1, CHECKEXISTENCE = 2

'Declarations:
    DECLARE SUB Encrypt ()
    DECLARE SUB Initiate ()
    DECLARE SUB ErrorMessage (row, message AS STRING)
    DECLARE FUNCTION UserInput$ (row, col, prompt AS STRING, maxlen)
    DECLARE FUNCTION FileValid (testfilename AS STRING, func)

'Main:
    Initiate
    PRINT
    PRINT "Encrypting . . .";
    Encrypt
    PRINT "Done."

EndOfProgram:
    LOCATE 24
    FOR a = 1 TO 5: PRINT : NEXT
    SYSTEM

FileErr:
    valid = FALSE
    RESUME NEXT

SUB Encrypt
    OPEN filename FOR INPUT AS #1
    OPEN "grk.grk" FOR OUTPUT AS #2

    'print password at the start of file
        PRINT #2, LTRIM$(STR$(LEN(password)));
        FOR z = 1 TO LEN(password)
            char = ASC(MID$(password, z, 1)) + z
            PRINT #2, CHR$(char);
        NEXT

    DO UNTIL EOF(1)
        IF t = LEN(password) THEN t = 1 ELSE t = t + 1    't - new variable
        char = ASC(INPUT$(1, #1)) + ASC(MID$(password, t, 1))
        IF char > 255 THEN char = char - 255
        PRINT #2, CHR$(char);
    LOOP
    CLOSE #1, #2

    KILL filename
    NAME "grk.grk" AS newname
END SUB

SUB ErrorMessage (row, message AS STRING)

col = 41 - (LEN(message) / 2)

COLOR 16, 7

LOCATE row, col
PRINT message;

COLOR 7, 0

SLEEP

LOCATE row, col
PRINT SPACE$(LEN(message));

IF INKEY$ = CHR$(27) THEN CLS : SYSTEM

END SUB

FUNCTION FileValid (testfilename AS STRING, func)

valid = TRUE

ON ERROR GOTO FileErr

SELECT CASE func
    CASE CHECKEXISTENCE:    OPEN testfilename FOR INPUT AS #1
    CASE CHECKNAME:         OPEN testfilename FOR APPEND AS #1
END SELECT

ON ERROR GOTO 0

IF valid AND func = CHECKNAME THEN
    IF LOF(1) = 0 THEN
        CLOSE #1
        KILL testfilename
    END IF
END IF

CLOSE #1

FileValid = valid

END FUNCTION

SUB Initiate
   
    CLS
    SCREEN 0

    COLOR 9, 0
    LOCATE 7, 30: PRINT "GAURANG'S ENCRYPTER"
    COLOR 7, 0
    LOCATE 24, 30: PRINT "Press Escape to Quit";

AskFileName:
    IF flag = FALSE THEN filename = ENVIRON$("FILENAME")
    IF filename = "" THEN
        filename = UserInput$(11, 15, "Enter Name Of File: ", 12)
    END IF
    IF NOT FileValid(filename, CHECKNAME) THEN
        ErrorMessage 13, "File Name Invalid. Press any key to continue . . "
        flag = TRUE
        filename = ""
        GOTO AskFileName
    ELSE
        IF NOT FileValid(filename, CHECKEXISTENCE) THEN
            ErrorMessage 13, "File Does Not Exist. Press any key to continue . ."
            flag = TRUE
            filename = ""
            GOTO AskFileName
        END IF
    END IF
    flag = FALSE

AskPassword:
    IF flag = FALSE THEN password = ENVIRON$("PASSWORD")
    IF password = "" THEN
        password = UserInput$(12, 18, "Enter Password: ", 9)
    END IF
    IF password = "" THEN
        ErrorMessage 14, "Password Invalid. Press any key to continue . ."
        flag = TRUE
        password = ""
        GOTO AskPassword
    END IF
    flag = FALSE

AskNewName:
    IF ENVIRON$("FILENAME") <> "" AND flag = FALSE THEN
        newname = ENVIRON$("NEWNAME")
        IF LEFT$(newname, 1) = CHR$(32) THEN newname = ""   'undiscovered
    ELSE
        newname = UserInput$(13, 16, "Enter New Name Of File: ", 12)
    END IF
    IF newname = "" THEN
        newname = filename
    ELSEIF newname <> filename THEN
        IF NOT FileValid(newname, CHECKNAME) THEN
            ErrorMessage 15, "File Name Invalid. Press any key to continue . . "
            newname = ""
            flag = TRUE
            GOTO AskNewName
        ELSE
            IF FileValid(newname, CHECKEXISTENCE) THEN
                ErrorMessage 15, "File Exists. Press any key to continue . . "
                newname = ""
                flag = TRUE
                GOTO AskNewName
            END IF
        END IF
    END IF
    flag = FALSE

END SUB

FUNCTION UserInput$ (row, col, prompt AS STRING, maxlen)

DIM char AS STRING, ans AS STRING

LOCATE row, col
PRINT prompt; SPACE$(maxlen + 1);
LOCATE row, col + LEN(prompt)
PRINT "_"

DO
    DO: char = INKEY$: LOOP WHILE char = ""
    SELECT CASE char
        CASE "a" TO "z", "A" TO "Z", "0" TO "9", ".", ":", "\":
                        IF LEN(ans) < maxlen THEN ans = ans + char
        CASE CHR$(27):  CLS : SYSTEM
        CASE CHR$(13):  EXIT DO
        CASE CHR$(8):   IF LEN(ans) > 0 THEN ans = LEFT$(ans, LEN(ans) - 1)
        CASE ELSE:  BEEP
    END SELECT
    LOCATE row, col + LEN(prompt)
    PRINT ans; "_"; " ";
LOOP

LOCATE row, col + LEN(prompt) + LEN(ans): PRINT " ";
UserInput$ = ans

END FUNCTION

