'
'EDIT.BAS --- A small EDITOR
'
'CONTENT:
'   This is a program for a small editor. The editor has pull down menus
' and multi-windowing facility. There are however some major limitations
' to it. It can not open a file longer than 310 lines, with each line
' containing a max of 200 characters. This is basically due to lack of
' linked-list facility in BASIC for storage of file in memory.
'
'NOTE:
'   This program consists of good learnable things in monumental
' numbers. Almost all of the algorithms do something interesting.
'   The handling of windows is to be seen as a base of good creations
' of the future. The way the file is stored in memory and maintained
' should be carefully observed.
'   The handling of menus is easy, as can be seen in the program.
'   I hope that the effort put into this program proves useful for
' the user.
'
'   Program by: Gaurang Ramakant Khetan
'
DEFINT A-Y
DEFSTR Z
CONST FALSE = 0, TRUE = NOT FALSE '-1
CONST MAXLEN = 200, MAXLINES = 310
CONST SINGLELINE = "ڿĳ", DOUBLELINE = "ɻȼͺ"
CONST NORMAL = 7, REVERSE = 112, BRIGHT = 15
CONST MAXFILEWINDOWS = 3, MAXOTHERWIND = 3


TYPE videomemtype
	Colour AS STRING * 1
	character AS STRING * 1
END TYPE
TYPE filewindowtype
	desktopnum AS INTEGER      'indicates the position in desktop array
							   'which means the position it is on the desktop
	x1 AS INTEGER
	y1 AS INTEGER
	x2 AS INTEGER
	y2 AS INTEGER
	length AS INTEGER
	wide AS INTEGER
	toplinefit AS INTEGER

	startline AS INTEGER
	startchar AS INTEGER
	curx AS INTEGER
	cury AS INTEGER
	curline AS INTEGER
END TYPE
TYPE memlinetype
	linenum AS INTEGER
   
	text AS STRING * MAXLEN
	lastchar AS INTEGER
   
	pline AS INTEGER
	nline AS INTEGER
END TYPE
TYPE memfiletype
	filename AS STRING * 30
	onlyfilename AS STRING * 12
	tailline AS INTEGER
	taillinenum AS INTEGER
END TYPE

DECLARE SUB BasicInput (row, col, Zprompt, Zvar, maxwidth)
DECLARE SUB BasicCenter (row, col1, col2, Ztext)
DECLARE SUB BasicDrawScreen ()
DECLARE SUB BasicFillScreen (x1, y1, x2, y2, Zchar)
DECLARE SUB BasicGetFileName (Ztit)
DECLARE SUB BasicPrintStatus (Ztext)
DECLARE SUB BasicBox (x1, y1, x2, y2, ZBrdrLine, BrdrCol)
DECLARE SUB Colour (col)
DECLARE SUB DispCursor ()
DECLARE SUB DispCursorPos ()
DECLARE SUB DispLine (row, linenum)
DECLARE SUB DispFile ()
DECLARE SUB EditCharIns (character)
DECLARE SUB EditCharNorm (character)
DECLARE SUB EditCharDel ()
DECLARE SUB EditCharBkSpc ()
DECLARE SUB EditEnter ()
DECLARE SUB EditLineDel (prevline)
DECLARE FUNCTION EditLineCreate (prevline)
DECLARE SUB EditTab ()
DECLARE SUB FileWindowDraw (win)
DECLARE SUB FileWindowInit (a)
DECLARE SUB FileWindowClose ()
DECLARE SUB FileWindowNew ()
DECLARE SUB FileWindowErase (win)
DECLARE SUB FileWindowOpen (win)
DECLARE SUB FileWindowUpdate ()
DECLARE SUB Initialize ()
DECLARE SUB Main ()
DECLARE SUB Menu (num)
DECLARE SUB MenuFileSave ()
DECLARE SUB MenuFileOpen (Zname)
DECLARE SUB MenuFileNew ()
DECLARE SUB MenuFileSaveAs ()
DECLARE SUB MenuFileExit ()
DECLARE SUB MenuWin (choice)
DECLARE SUB MenuWinMove ()
DECLARE SUB MenuWinResize ()
DECLARE SUB NaviLeft ()
DECLARE SUB NaviUp ()
DECLARE SUB NaviRight ()
DECLARE SUB NaviDown ()
DECLARE SUB NaviScrollRight ()
DECLARE SUB NaviScrollLeft ()
DECLARE SUB NaviScrollUp ()
DECLARE SUB NaviScrollDown ()
DECLARE SUB NaviPgUp ()
DECLARE SUB NaviPgDn ()
DECLARE SUB NaviGoYPos (charpos)
DECLARE SUB NaviHome ()
DECLARE SUB NaviEnd ()
DECLARE SUB NaviWordLeft ()
DECLARE SUB NaviWordRight ()
DECLARE SUB NaviStartOfFile ()
DECLARE SUB NaviEndOfFile ()
DECLARE SUB NaviScreenRight ()
DECLARE SUB NaviScreenLeft ()
DECLARE SUB NaviStaOfNxtLine ()
DECLARE SUB ReadFile ()
DECLARE FUNCTION ReadLine$ (filenum)
DECLARE SUB WinBox (x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr)
DECLARE SUB WinPopUp (win, x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr, Zfunc)
DECLARE FUNCTION WinMessage$ (Ztitle, Zmsg1, Zmsg2)

ON ERROR GOTO ErrorHandler
REM $DYNAMIC
DIM SHARED memfile AS memfiletype
DIM SHARED memline(0 TO MAXLINES) AS memlinetype
DIM SHARED fwin(1 TO MAXFILEWINDOWS) AS filewindowtype
DIM SHARED videomem(1 TO MAXFILEWINDOWS + MAXOTHERWIND, 1 TO 23, 1 TO 80) AS videomemtype
DIM SHARED menus(1 TO 5, 0 TO 7) AS STRING
DIM SHARED menuinfo(1 TO 5, 1 TO 3)
DIM SHARED desktop(1 TO MAXFILEWINDOWS)
DIM SHARED cwin, btmwindow, midwindow, topwindow
DIM SHARED FileStatus
	'   1 -- old file
	'   2 -- new file (empty)
	'   3 -- error in filename
	'   4 -- error in path or access not possible

'***Code***

Initialize
t$ = WinMessage$("greeting", "WELCOME!", SPACE$(10) + UCASE$("This is the qbasic-editor") + SPACE$(10))

MenuFileOpen "Untitled"
Main

SLEEP
CLS : Colour NORMAL
SYSTEM

DATA File,New,Open,Save,"save As",Print,eXit,""
DATA Edit,Cut,cOpy,Paste,cLear,""
DATA Search,Find,Repeat,Change,""
DATA Windows,New,Resize,Move,Open,Close,""
DATA Options,Display,About,""

FileErr:                  'error while opening file
	SELECT CASE ERR
		CASE 64:
			FileStatus = 3  'indicates faulty filename
		CASE 53:
			FileStatus = 2  'indicates a new file
		CASE 25, 75, 76, 71:
			FileStatus = 4  'indicates a path error
		CASE ELSE: GOTO ErrorHandler
	END SELECT
	RESUME NEXT

ErrorHandler:             'unexpected error
	IF ErrorOccured = FALSE AND (ERR = 14 OR ERR = 7) THEN
		ERASE menus, menuinfo, fwin, desktop
	END IF
	IF ErrorOccured = FALSE THEN
		t$ = WinMessage$("ERROR", "!!Unexpected Error" + STR$(ERR) + "!! Terminating...", "If you press Y now, program will try to store loaded file...")
		IF t$ <> "y" AND t$ <> "Y" THEN SYSTEM
		ErrorOccured = TRUE
		MenuFileSave
		t$ = WinMessage$("MESSAGE", "File Saved!", "Ending...")
		SYSTEM
	END IF
	IF ErrorOccured = TRUE THEN
		ERASE memline
		t$ = WinMessage$("ERROR", "!!!SORRY!!! Ending...", "Cannot save file.")
		SYSTEM
	END IF

REM $STATIC
SUB BasicBox (x1, y1, x2, y2, ZBrdrLine, BrdrCol)
'Draws a box without painting it's interior

Colour BrdrCol

'*print horizontal lines
LOCATE x1, y1, 0
PRINT MID$(ZBrdrLine, 1, 1); STRING$(y2 - y1 - 1, MID$(ZBrdrLine, 5, 1)); MID$(ZBrdrLine, 2, 1);
LOCATE x2, y1, 0
PRINT MID$(ZBrdrLine, 3, 1); STRING$(y2 - y1 - 1, MID$(ZBrdrLine, 5, 1)); MID$(ZBrdrLine, 4, 1);

'*print vertical lines
FOR a = (x1 + 1) TO (x2 - 1)
	LOCATE a, y1, 0: PRINT MID$(ZBrdrLine, 6, 1);
	LOCATE a, y2, 0: PRINT MID$(ZBrdrLine, 6, 1);
NEXT a

END SUB

SUB BasicCenter (row, col1, col2, Ztext)
	LOCATE row, (col1) + ((col2 - col1) \ 2) - (LEN(Ztext) \ 2), 0
	PRINT Ztext;
END SUB

SUB BasicDrawScreen

CLS : LOCATE , , 0
BasicFillScreen 2, 1, 23, 80, " "

Colour REVERSE
FOR a = 1 TO 80
	LOCATE 1, a: PRINT CHR$(32);
NEXT

col = 5
FOR a = 1 TO 5
	LOCATE 1, col
	PRINT menus(a, 0)
	col = col + LEN(menus(a, 0)) + 4
NEXT

Colour BRIGHT
BasicCenter 2, 1, 80, "Q B A S I C   E D I T O R"

Colour NORMAL

END SUB

SUB BasicFillScreen (x1, y1, x2, y2, Zchar)

Colour NORMAL
LOCATE , , 0
FOR a = x1 TO x2: FOR b = y1 TO y2
	LOCATE a, b
	PRINT Zchar;
NEXT b, a

END SUB

SUB BasicGetFileName (Ztit)

Colour REVERSE

WinPopUp 0, 10, 1, 13, 80, SINGLELINE, REVERSE, REVERSE, "dyf"
BasicCenter 10, 1, 80, Ztit

LOCATE 11, 2
PRINT "Current Path: "; : SHELL "cd"
done = TRUE
DO
	FileStatus = 1
	
	LOCATE 12, 2: PRINT SPACE$(78)
	BasicInput 12, 2, "Enter filename: ", memfile.filename, 30
   
	ON ERROR GOTO FileErr
		OPEN memfile.filename FOR INPUT AS #1
		CLOSE #1
	ON ERROR GOTO ErrorHandler
	
	'Inform the user of the error
	IF FileStatus = 3 OR FileStatus = 4 THEN
		SELECT CASE FileStatus
			CASE 3:     t$ = WinMessage$("ERROR", "Invalid Filename!", "")
			CASE 4:     t$ = WinMessage$("ERROR", "Inaccessible file!!", "Check the path.")
		END SELECT
		done = FALSE
	ELSE
		done = TRUE
	END IF

LOOP UNTIL done

WinPopUp 0, 10, 1, 13, 80, SINGLELINE, NORMAL, REVERSE, "ef"

'Find the  actual file name in the filename variable
'to be displayed on the top of the window.

Zfilename = RTRIM$(UCASE$(memfile.filename))
DO WHILE (INSTR(1, Zfilename, "\") OR INSTR(1, Zfilename, ":"))
	IF INSTR(1, Zfilename, "\") THEN
		Zfilename = MID$(Zfilename, INSTR(1, Zfilename, "\") + 1)
	END IF
	IF INSTR(1, Zfilename, ":") THEN
		Zfilename = MID$(Zfilename, INSTR(1, Zfilename, ":") + 1)
	END IF
LOOP
memfile.onlyfilename = RTRIM$(Zfilename)

END SUB

SUB BasicInput (row, col, Zprompt, Zvar, maxwidth)

Zrep = ""
LOCATE row, col
PRINT Zprompt;
col = col + LEN(Zprompt)
DO
	LOCATE row, col: PRINT SPACE$(maxwidth + 1)
	LOCATE row, col: PRINT Zrep; "_"
	DO: Zchar = INKEY$: LOOP WHILE Zchar = ""
	SELECT CASE Zchar
		CASE CHR$(13):  Zvar = Zrep: EXIT SUB
		CASE CHR$(8):   IF LEN(Zrep) > 0 THEN Zrep = LEFT$(Zrep, LEN(Zrep) - 1)
		CASE CHR$(27):  Zrep = ""
		CASE IS >= " ": IF LEN(Zrep) < maxwidth THEN Zrep = Zrep + UCASE$(Zchar)
		CASE ELSE:      BEEP
	END SELECT
LOOP

END SUB

SUB BasicPrintStatus (Ztext)

IF Ztext = "" THEN Ztext = "F1-FullScreen  F2-Open File  F3-Repeat Find "
Colour REVERSE
LOCATE 24, 1, 0
PRINT SPACE$(80);
BasicCenter 24, 1, 80, Ztext
Colour NORMAL

END SUB

SUB Colour (col)
SELECT CASE col
	CASE NORMAL:        COLOR 7, 0
	CASE REVERSE:       COLOR 0, 7
	CASE BRIGHT:        COLOR 15, 0
END SELECT

END SUB

SUB DispCursor

LOCATE fwin(cwin).x1 + fwin(cwin).curx, fwin(cwin).y1 + fwin(cwin).cury, 1

END SUB

SUB DispCursorPos

' prints the cursor position (w.r.t. start of file) at the top left corner.

DIM Zrowstr, Zcolstr

Zrowstr = LTRIM$(STR$(memline(fwin(cwin).startline).linenum + fwin(cwin).curx - 1))
Zcolstr = LTRIM$(STR$(fwin(cwin).startchar + fwin(cwin).cury - 1))

Zrowstr = STRING$(3 - LEN(Zrowstr), "0") + Zrowstr
Zcolstr = STRING$(3 - LEN(Zcolstr), "0") + Zcolstr

Colour REVERSE

LOCATE fwin(cwin).x1, fwin(cwin).y1 + 1, 0: PRINT Zrowstr; ","; Zcolstr

Colour NORMAL

END SUB

SUB DispFile

row = fwin(cwin).x1: curline = memline(fwin(cwin).startline).pline

DO
	row = row + 1
	curline = memline(curline).nline
	DispLine row, curline
	IF curline = memfile.tailline AND row < fwin(cwin).x2 - 1 THEN
		DO
			row = row + 1
			LOCATE row, fwin(cwin).y1 + 1, 0
			PRINT SPACE$(fwin(cwin).wide)
		LOOP UNTIL row = fwin(cwin).x2 - 1
	END IF
LOOP UNTIL curline = memfile.tailline OR row = fwin(cwin).x2 - 1

END SUB

SUB DispLine (row, linenum)

LOCATE row, fwin(cwin).y1 + 1, 0

IF memline(linenum).lastchar <= fwin(cwin).startchar THEN
	Ztemp = SPACE$(fwin(cwin).wide)
ELSE
	Ztemp = MID$(memline(linenum).text, fwin(cwin).startchar, memline(linenum).lastchar - fwin(cwin).startchar)
END IF

IF LEN(Ztemp) > fwin(cwin).wide THEN
		PRINT LEFT$(Ztemp, fwin(cwin).wide);
	ELSEIF LEN(Ztemp) < fwin(cwin).wide THEN
		PRINT Ztemp; SPACE$(fwin(cwin).wide - LEN(Ztemp));
	ELSE
		PRINT Ztemp;
END IF

END SUB

SUB EditCharBkSpc

IF fwin(cwin).startchar + fwin(cwin).cury - 1 = 1 THEN
	IF fwin(cwin).curline = memline(0).nline THEN EXIT SUB  'first file line
	NaviUp
	NaviEnd
ELSE
	NaviLeft
END IF

IF fwin(cwin).startchar + fwin(cwin).cury - 1 <= memline(fwin(cwin).curline).lastchar THEN
	EditCharDel
END IF

END SUB

SUB EditCharDel

CharNum = fwin(cwin).startchar + fwin(cwin).cury - 1
nline = memline(fwin(cwin).curline).nline
curline = fwin(cwin).curline

IF CharNum < memline(curline).lastchar THEN
	FOR a = (fwin(cwin).startchar + fwin(cwin).cury - 1) TO memline(fwin(cwin).curline).lastchar
		MID$(memline(curline).text, a, 1) = MID$(memline(curline).text, a + 1, 1)
	NEXT
	memline(curline).lastchar = memline(curline).lastchar - 1
   
	DispLine fwin(cwin).curx + fwin(cwin).x1, curline
   
	EXIT SUB
END IF

IF curline = memfile.tailline THEN EXIT SUB

IF CharNum > memline(curline).lastchar THEN
	'insert spaces till the location of pressing the del key
	count = memline(curline).lastchar - 1
	DO
		count = count + 1
		MID$(memline(curline).text, count, 1) = " "
		memline(curline).lastchar = memline(curline).lastchar + 1
	LOOP UNTIL CharNum = memline(curline).lastchar
END IF

IF CharNum = memline(curline).lastchar THEN
   'copy next line onto this line
	FOR a = 1 TO memline(nline).lastchar
		MID$(memline(curline).text, CharNum + a - 1, 1) = MID$(memline(nline).text, a, 1)
	NEXT
	memline(curline).lastchar = CharNum + a - 2
	
   'del next line and display the file
	EditLineDel curline
	DispFile
END IF

END SUB

SUB EditCharIns (character)
   
IF fwin(cwin).startchar + fwin(cwin).cury - 1 >= memline(fwin(cwin).curline).lastchar THEN
	'if the character is after the last character of the line
	MID$(memline(fwin(cwin).curline).text, memline(fwin(cwin).curline).lastchar, 1) = CHR$(32)
	memline(fwin(cwin).curline).lastchar = fwin(cwin).startchar + fwin(cwin).cury
	MID$(memline(fwin(cwin).curline).text, memline(fwin(cwin).curline).lastchar, 1) = CHR$(13)
END IF
MID$(memline(fwin(cwin).curline).text, fwin(cwin).startchar + fwin(cwin).cury - 1, 1) = CHR$(character)

LOCATE fwin(cwin).x1 + fwin(cwin).curx, fwin(cwin).y1 + fwin(cwin).cury
PRINT CHR$(character)
NaviRight

END SUB

SUB EditCharNorm (character)

IF fwin(cwin).startchar + fwin(cwin).cury - 1 >= memline(fwin(cwin).curline).lastchar THEN
	EditCharIns character
	EXIT SUB
END IF

FOR a = memline(fwin(cwin).curline).lastchar TO fwin(cwin).startchar + fwin(cwin).cury - 1 STEP -1
	MID$(memline(fwin(cwin).curline).text, a + 1, 1) = MID$(memline(fwin(cwin).curline).text, a, 1)
NEXT

memline(fwin(cwin).curline).lastchar = memline(fwin(cwin).curline).lastchar + 1

DispLine fwin(cwin).x1 + fwin(cwin).curx, fwin(cwin).curline

EditCharIns character

END SUB

SUB EditEnter

t = EditLineCreate(fwin(cwin).curline)
IF t = FALSE THEN EXIT SUB      'indicates file is already MAXLINES in length

CharNum = fwin(cwin).startchar + fwin(cwin).cury - 1
IF CharNum < memline(fwin(cwin).curline).lastchar THEN
	curline = fwin(cwin).curline: nline = memline(curline).nline
	count = 0
	DO
		count = count + 1
		MID$(memline(nline).text, count, 1) = MID$(memline(curline).text, CharNum + count - 1, 1)
		MID$(memline(curline).text, CharNum + count - 1, 1) = " "
		IF CharNum + count - 1 = memline(curline).lastchar THEN EXIT DO
	LOOP
	MID$(memline(curline).text, CharNum, 1) = CHR$(13)
	memline(curline).lastchar = CharNum
	memline(nline).lastchar = count
END IF

DispFile

NaviStaOfNxtLine

END SUB

FUNCTION EditLineCreate (prevline)
'creates an empty line after prevline

EditLineCreate = TRUE

'search for empty element in memline array
	num = MAXLINES + 1
	FOR a = 1 TO MAXLINES
		IF memline(a).lastchar = 0 THEN num = a: EXIT FOR
	NEXT
	IF num = MAXLINES + 1 THEN
		t$ = WinMessage$("error", "Too long file to fit in memory!", "File should be less than " + STR$(MAXLINES) + " lines in length.")
		EditLineCreate = FALSE
		EXIT FUNCTION
	END IF

'initialize the new line
	memline(num).text = CHR$(13)
	memline(num).lastchar = 1

'adjust pointers
	IF prevline = memfile.tailline THEN 'create line after last file line
		memline(prevline).nline = num
		memline(num).pline = prevline
		memline(num).linenum = memline(prevline).linenum + 1
		memfile.tailline = num
		memfile.taillinenum = memline(num).linenum
		EXIT FUNCTION
	END IF
	nline = memline(prevline).nline
	memline(num).nline = nline
	memline(num).pline = prevline
	memline(nline).pline = num
	memline(prevline).nline = num
	memline(num).linenum = memline(prevline).linenum + 1
   
'adjust line numbers
	curline = num
	DO
		curline = memline(curline).nline
		memline(curline).linenum = memline(curline).linenum + 1
		IF curline = memfile.tailline THEN EXIT DO
	LOOP
	memfile.taillinenum = memfile.taillinenum + 1

END FUNCTION

SUB EditLineDel (prevline)
'deletes the line following <prevline>, in memory.

IF prevline = memfile.tailline THEN EXIT SUB

linetodel = memline(prevline).nline

'initialize line for reuse
memline(linetodel).text = SPACE$(MAXLEN)
memline(linetodel).pline = 0
memline(linetodel).lastchar = 0
memline(linetodel).linenum = 0

'if line to be deleted is last file line
IF linetodel = memfile.tailline THEN
	memfile.tailline = prevline
	memfile.taillinenum = memfile.taillinenum
	memline(prevline).nline = 0
	memline(linetodel).nline = 0
	EXIT SUB
END IF

'adjust pointers
memline(prevline).nline = memline(linetodel).nline
memline(memline(linetodel).nline).pline = prevline
memline(linetodel).nline = 0

'update line numbers
curline = memline(prevline).nline
DO
	memline(curline).linenum = memline(curline).linenum - 1
	IF curline = memfile.tailline THEN EXIT DO
	curline = memline(curline).nline
LOOP
memfile.taillinenum = memfile.taillinenum - 1

END SUB

SUB EditTab

CharNum1 = fwin(cwin).startchar + fwin(cwin).cury - 1
a = (CharNum1 - 1) \ 4
CharNum2 = (a + 1) * 4 + 1

FOR a = CharNum1 TO (CharNum2 - 1)
	EditCharNorm 32     'space
NEXT

END SUB

SUB FileWindowClose

IF fwin(cwin).desktopnum = 1 THEN
	t$ = WinMessage$("NO", "You cannot close the last window.", "")
	EXIT SUB
END IF

FileWindowErase cwin

desktop(fwin(cwin).desktopnum) = 0
fwin(cwin).x1 = 0

cwin = desktop(fwin(cwin).desktopnum - 1)

FileWindowUpdate

Colour NORMAL
DispFile

END SUB

SUB FileWindowDraw (win)

pwin = cwin
cwin = win

x1 = fwin(win).x1: y1 = fwin(win).y1
x2 = fwin(win).x2: y2 = fwin(win).y2

WinPopUp win, x1, y1, x2, y2, SINGLELINE, REVERSE, NORMAL, "dnf"

DispCursorPos
Colour REVERSE
LOCATE x1, y2 - 3, 0
PRINT USING "##"; win   'fwin(win).desktopnum
IF fwin(win).toplinefit THEN
	BasicCenter x1, y1, y2, " " + RTRIM$(memfile.onlyfilename) + " "
END IF
Colour NORMAL

DispFile

cwin = pwin

END SUB

SUB FileWindowErase (win)

x1 = fwin(win).x1
y1 = fwin(win).y1
x2 = fwin(win).x2
y2 = fwin(win).y2

WinPopUp win, x1, y1, x2, y2, SINGLELINE, NORMAL, REVERSE, "ef"

END SUB

SUB FileWindowInit (a)
   
	fwin(a).x1 = 3
	fwin(a).y1 = 5
	fwin(a).x2 = 19
	fwin(a).y2 = 75
	fwin(a).length = fwin(a).x2 - fwin(a).x1 - 1
	fwin(a).wide = fwin(a).y2 - fwin(a).y1 - 1
	fwin(a).toplinefit = TRUE
   
	fwin(a).startline = memline(0).nline
	fwin(a).startchar = 1
   
	fwin(a).curx = 1
	fwin(a).cury = 1
	fwin(cwin).curline = fwin(cwin).startline
   
END SUB

SUB FileWindowNew

FOR a = 1 TO MAXFILEWINDOWS
	IF fwin(a).x1 = 0 THEN win = a: EXIT FOR
NEXT

FOR a = 1 TO MAXFILEWINDOWS
	IF desktop(a) = 0 THEN b = a: EXIT FOR
NEXT

IF b = 0 OR win = 0 THEN
	t$ = WinMessage$("ERROR", "You cannot open more than " + STR$(MAXFILEWINDOWS) + " windows.", "")
	EXIT SUB
END IF

desktop(b) = win
cwin = win

FileWindowInit win
fwin(win).desktopnum = b

FileWindowDraw win

END SUB

SUB FileWindowOpen (win)

IF fwin(win).x1 = 0 THEN EXIT SUB
IF win = cwin THEN EXIT SUB  'we are already in the window required

'erase windows upto the required window
FOR a = MAXFILEWINDOWS TO fwin(win).desktopnum STEP -1
	IF desktop(a) <> 0 THEN
		FileWindowErase desktop(a)
	END IF
NEXT

'redraw erased windows and the asked window
FOR a = fwin(win).desktopnum + 1 TO MAXFILEWINDOWS
	IF desktop(a) = 0 THEN EXIT FOR
	FileWindowDraw desktop(a)
NEXT

'update memory
FOR a = fwin(win).desktopnum TO MAXFILEWINDOWS
	IF a = MAXFILEWINDOWS THEN
		desktop(a) = win               'last window
		fwin(win).desktopnum = a
		EXIT FOR
	ELSEIF desktop(a + 1) = 0 THEN
		desktop(a) = win               'last window
		fwin(win).desktopnum = a
		EXIT FOR
	END IF
	desktop(a) = desktop(a + 1)
	fwin(desktop(a)).desktopnum = a
NEXT

'Zt$ = "Desktop No:"
'FOR a = 1 TO 5
'    Zt$ = Zt$ + STR$(desktop(a))
'NEXT
't$ = WinMessage$("a", Zt$, "")

cwin = win
FileWindowUpdate
FileWindowDraw cwin
DispFile

END SUB

SUB FileWindowUpdate

'for updating the new cwin window
'the logic is that the window tries to regain the original startline,
'or the original curline. If both have been deleted, then HOME

IF memline(fwin(cwin).startline).lastchar <> 0 THEN
	fwin(cwin).curx = 1
	fwin(cwin).curline = fwin(cwin).startline
ELSEIF memline(fwin(cwin).curline).lastchar <> 0 THEN
	fwin(cwin).curx = 1
	fwin(cwin).startline = fwin(cwin).curline
ELSE
	fwin(cwin).startchar = 1: fwin(cwin).startline = memline(0).nline
	fwin(cwin).curx = 1: fwin(cwin).cury = 1
	fwin(cwin).curline = fwin(cwin).startline
END IF

END SUB

SUB Initialize

FOR a = 1 TO MAXFILEWINDOWS + MAXOTHERWIND
	videomem(a, 1, 1).Colour = CHR$(1)
NEXT
FOR a = 1 TO 5
	READ menus(a, 0)
	FOR b = 1 TO 7
		READ menus(a, b)
		IF menus(a, b) = "" THEN EXIT FOR
	NEXT
NEXT

'Menuinfo array:
'First dimension:-   Menu number    eg. 1 for File, 2 for Edit etc.
'Second dimension:-  1 - Y-coor of title
'                    2 - Menubox height depending on the no of items
'                    3 - Menubox width depending on the max length of items

col = 5
FOR a = 1 TO 5
	menuinfo(a, 1) = col
	col = col + LEN(menus(a, 0)) + 4

	menuinfo(a, 2) = 7: mlen = 1
	FOR b = 1 TO 7
		IF menus(a, b) = "" THEN menuinfo(a, 2) = b - 1: EXIT FOR
		IF LEN(menus(a, b)) > mlen THEN
			mlen = LEN(menus(a, b))
		END IF
	NEXT
	IF mlen < 12 THEN mlen = 12
	menuinfo(a, 3) = mlen
NEXT

BasicDrawScreen

END SUB

SUB Main

ins = FALSE: LOCATE , , , 10, 11
BasicPrintStatus ""

DO      '****************MAIN LOOP OF THE EDITOR*******************

DispCursorPos
DispCursor

DO: Zchar = INKEY$: LOOP WHILE Zchar = ""

SELECT CASE Zchar
   
	'*navigation*
	CASE CHR$(0) + "K":     NaviLeft            'left arrow
	CASE CHR$(0) + "M":     NaviRight           'right arrow
	CASE CHR$(0) + "H":     NaviUp              'up arrow
	CASE CHR$(0) + "P":     NaviDown            'downarrow
	CASE CHR$(5):           NaviScrollUp        'ctrl + e
	CASE CHR$(19):          NaviScrollLeft      'ctrl + s
	CASE CHR$(4):           NaviScrollRight     'ctrl + d
	CASE CHR$(24):          NaviScrollDown      'ctrl + x
	CASE CHR$(0) + "G":     NaviHome            'Home
	CASE CHR$(0) + "O":     NaviEnd             'End
	CASE CHR$(0) + "s":     NaviWordLeft        'ctrl + left
	CASE CHR$(0) + "t":     NaviWordRight       'ctrl + right
	CASE CHR$(0) + "I":     NaviPgUp            'PgUp
	CASE CHR$(0) + "Q":     NaviPgDn            'PgDn
	CASE CHR$(0) + "w":     NaviStartOfFile     'ctrl + home
	CASE CHR$(0) + "u":     NaviEndOfFile       'ctrl+end
	CASE CHR$(0) + "v":     NaviScreenRight     'ctrl + pgdn
	CASE CHR$(0) + CHR$(132): NaviScreenLeft    'ctrl + pgup
	CASE CHR$(10):          NaviStaOfNxtLine    'ctrl + enter
   
	'*menu*
	CASE CHR$(0) + CHR$(33):     Menu 1         'alt + f
	CASE CHR$(0) + CHR$(18):     Menu 2         'alt + e
	CASE CHR$(0) + CHR$(31):     Menu 3         'alt + s
	CASE CHR$(0) + CHR$(17):     Menu 4         'alt + w
	CASE CHR$(0) + CHR$(24):     Menu 5         'alt + o
   
	'*function keys*
	CASE CHR$(0) + ";":     'F1
		FileWindowErase cwin
		fwin(cwin).x1 = 2: fwin(cwin).y1 = 1
		fwin(cwin).x2 = 23: fwin(cwin).y2 = 80
		fwin(cwin).length = fwin(cwin).x2 - fwin(cwin).x1 - 1
		fwin(cwin).wide = fwin(cwin).y2 - fwin(cwin).y1 - 1
		FileWindowDraw cwin

	CASE CHR$(0) + "<":     'F2
	CASE CHR$(0) + "=":     'F3
	CASE CHR$(0) + ">":     'F4
   
	'*edit*
	CASE CHR$(32) TO CHR$(255):                                 'Char
		IF ins THEN EditCharIns ASC(Zchar) ELSE EditCharNorm ASC(Zchar)
	CASE CHR$(13):          EditEnter                           'Enter
	CASE CHR$(14):          EditEnter: NaviUp                   'Ctrl + n
	CASE CHR$(0) + "S":     EditCharDel                         'Delete
	CASE CHR$(8):           EditCharBkSpc                       'Backspace
	CASE CHR$(9):           EditTab                             'Tab

	'*others*
	CASE CHR$(0) + "R":                                         'Insert
		ins = NOT ins
		IF ins THEN LOCATE , , , 4, 8 ELSE LOCATE , , , 10, 11
	CASE CHR$(27):          SYSTEM              'escape
END SELECT

LOOP

EXIT SUB

END SUB

SUB Menu (num)

DIM x1, y1, x2, y2

choice1 = num           'chosen menu number
choice2 = 1             'item chosen in the current menu

GOSUB DrawMenuBox             'draws a menu box acc. to choice1
GOSUB HighLightItem           'highlights the selected item

Colour NORMAL
DO
	DO: Zchar = INKEY$: LOOP WHILE Zchar = ""
	SELECT CASE Zchar
		CASE CHR$(0) + "H":         'up
			Colour REVERSE: GOSUB HighLightItem
			IF choice2 > 1 THEN
				choice2 = choice2 - 1
			ELSE
				choice2 = menuinfo(choice1, 2)
			END IF
			Colour NORMAL: GOSUB HighLightItem
		CASE CHR$(0) + "P":         'down
			Colour REVERSE: GOSUB HighLightItem
			IF choice2 = menuinfo(choice1, 2) THEN
				choice2 = 1
			ELSE
				choice2 = choice2 + 1
			END IF
			Colour NORMAL: GOSUB HighLightItem
		CASE CHR$(0) + "M":         'right
			choice2 = 1
			GOSUB EraseMenuBox
			IF choice1 = 5 THEN choice1 = 1 ELSE choice1 = choice1 + 1
			GOSUB DrawMenuBox: GOSUB HighLightItem
		CASE CHR$(0) + "K":         'left
			choice2 = 1
			GOSUB EraseMenuBox
			IF choice1 = 1 THEN choice1 = 5 ELSE choice1 = choice1 - 1
			GOSUB DrawMenuBox: GOSUB HighLightItem
		CASE CHR$(13), CHR$(27):
			IF Zchar = CHR$(27) THEN choice2 = 0
			EXIT DO
		CASE "a" TO "z", "A" TO "Z":
			Zchar = UCASE$(Zchar)
			FOR a = 1 TO menuinfo(choice1, 2)
				Ztext = menus(choice1, a)
				FOR b = 1 TO LEN(Ztext)
					c = ASC(MID$(Ztext, b, 1))
					IF c < 97 AND c <> 32 THEN
						IF ASC(Zchar) = c THEN
							choice2 = a
							EXIT DO
						END IF
						EXIT FOR
					END IF
				NEXT
			NEXT
	END SELECT
LOOP

GOSUB EraseMenuBox

SELECT CASE choice1
	CASE 1     'File
		SELECT CASE choice2
			CASE 1:     MenuFileOpen "Untitled"
			CASE 2:     MenuFileOpen ""
			CASE 3:     MenuFileSave
			CASE 4:     MenuFileSaveAs
			CASE 6:     MenuFileExit
		END SELECT
	CASE 2
	CASE 3
	CASE 4
		MenuWin choice2
	CASE 5
		IF choice2 = 2 THEN
			t$ = WinMessage$("About", "T H I S   I S   T H E   S M A L L   E D I T O R", "      Written by Gaurang Ramakant Khetan in MS-QBASIC")
		ELSE
		END IF
END SELECT

EXIT SUB

DrawMenuBox:
	x1 = 2: x2 = x1 + menuinfo(choice1, 2) + 1
	y1 = menuinfo(choice1, 1) - 3: y2 = y1 + menuinfo(choice1, 3) + 1
	WinPopUp 0, x1, y1, x2, y2, SINGLELINE, REVERSE, REVERSE, "dnf"
	Colour REVERSE
	FOR a = 1 TO menuinfo(choice1, 2)
		LOCATE x1 + a, menuinfo(choice1, 1)
		PRINT menus(choice1, a);
	NEXT
	Colour NORMAL
	LOCATE 1, menuinfo(choice1, 1) - 1
	PRINT " " + menus(choice1, 0) + " "
	RETURN

EraseMenuBox:
	Colour REVERSE
	LOCATE 1, menuinfo(choice1, 1) - 1
	PRINT " " + menus(choice1, 0) + " "
	WinPopUp 0, x1, y1, x2, y2, SINGLELINE, REVERSE, REVERSE, "enf"
	RETURN

HighLightItem:
	x = x1 + choice2
	y = menuinfo(choice1, 1) - 3
	FOR Iz = 1 TO menuinfo(choice1, 3)
		y = y + 1
		LOCATE x, y: PRINT CHR$(SCREEN(x, y))
	NEXT
	RETURN

END SUB

SUB MenuFileExit

t$ = WinMessage$("WARNING", "Press Y if you want to save file", "")
IF UCASE$(t$) = "Y" THEN
	MenuFileSave
END IF

SYSTEM

END SUB

SUB MenuFileNew

IF memline(0).nline THEN
	t$ = WinMessage$("WARNING", "File in memory will be lost.", "Press Y to save file")
	IF t$ = "y" OR t$ = "Y" THEN MenuFileSave

	FOR a = 1 TO MAXLINES   'release current memory
		memline(a).lastchar = 0
	NEXT
END IF

memfile.filename = "Untitled"
memfile.onlyfilename = "Untitled"
FileStatus = 2  'new file

ReadFile

FOR a = MAXFILEWINDOWS TO 2 STEP -1
	IF desktop(a) <> 0 THEN FileWindowClose
NEXT
IF desktop(1) THEN
	IF fwin(desktop(1)).x1 <> 0 THEN
		FileWindowErase desktop(1)
		fwin(1).x1 = 0
		desktop(1) = 0
	END IF
END IF

FileWindowNew

END SUB

SUB MenuFileOpen (Zname)

IF memline(0).nline THEN
	t$ = WinMessage$("WARNING", "File in memory will be lost.", "Press Y to save file")
	IF t$ = "y" OR t$ = "Y" THEN MenuFileSave
	FOR a = 1 TO MAXLINES
		memline(a).lastchar = 0
	NEXT
END IF

IF Zname = "Untitled" THEN
	memfile.filename = "Untitled"
	memfile.onlyfilename = "Untitled"
	FileStatus = 2  'new file
ELSE
	BasicGetFileName " FILE OPEN "
END IF

ReadFile

FOR a = MAXFILEWINDOWS TO 2 STEP -1
	IF desktop(a) <> 0 THEN FileWindowClose
NEXT
IF desktop(1) THEN
	IF fwin(desktop(1)).x1 <> 0 THEN
		FileWindowErase desktop(1)
		fwin(1).x1 = 0
		desktop(1) = 0
	END IF
END IF

FileWindowNew

END SUB

SUB MenuFileSave
' This sub saves the file currently in memory,if there is no name then
' asks for a name

IF RTRIM$(memfile.filename) = "Untitled" THEN
	newname = TRUE
	BasicGetFileName "SAVE"
END IF

BasicPrintStatus "Saving File . . ."
CLOSE : OPEN memfile.filename FOR OUTPUT AS #1
					 'in case file already open
lin = 0
DO
	lin = memline(lin).nline
	IF lin = memfile.tailline THEN
		IF memline(lin).lastchar = 1 THEN EXIT DO
	END IF
	num = 0
	DO
		num = num + 1
		char$ = MID$(memline(lin).text, num, 1)
		PRINT #1, char$;
		IF num = memline(lin).lastchar THEN
			PRINT #1, CHR$(10); : EXIT DO   'acc. to DOS convention.
		END IF                             'for details, see ReadLine
	LOOP
	IF lin = memfile.tailline THEN
		EXIT DO
	END IF
LOOP

CLOSE #1

IF newname = TRUE THEN
	FileWindowErase cwin
	FileWindowDraw cwin
END IF

BasicPrintStatus ""

END SUB

SUB MenuFileSaveAs

BasicGetFileName "Save As"
MenuFileSave

FileWindowErase cwin
FileWindowDraw cwin

END SUB

SUB MenuWin (choice)

SELECT CASE choice
	CASE 1:     FileWindowNew
	CASE 2:     MenuWinResize
	CASE 3:     MenuWinMove
	CASE 4:
		BasicPrintStatus "Press the number of the open window to be brought in front.."
		DO
			char$ = INPUT$(1)
			IF char$ = CHR$(27) THEN EXIT DO
		LOOP UNTIL char$ >= "1" AND char$ <= LTRIM$(STR$(MAXFILEWINDOWS))
		IF char$ <> CHR$(27) THEN FileWindowOpen VAL(char$)
		BasicPrintStatus ""
	CASE 5:     FileWindowClose
END SELECT

END SUB

SUB MenuWinMove

BasicPrintStatus " Arrow keys to move window ; Enter to indicate completion"

DIM boxvidmem(1 TO 210, 1 TO 2) AS INTEGER

x1 = fwin(cwin).x1: y1 = fwin(cwin).y1: x2 = fwin(cwin).x2: y2 = fwin(cwin).y2
x3 = x1: y3 = y1: x4 = x2: y4 = y2
GOSUB ScreenSave
BasicBox x1, y1, x2, y2, SINGLELINE, NORMAL

DO
	DO: char$ = INKEY$: LOOP WHILE char$ = ""
	SELECT CASE char$
		CASE CHR$(0) + "H":     IF x1 > 2 THEN x3 = x1 - 1: x4 = x2 - 1
		CASE CHR$(0) + "P":     IF x2 < 23 THEN x3 = x1 + 1: x4 = x2 + 1
		CASE CHR$(0) + "M":     IF y2 < 80 THEN y3 = y1 + 1: y4 = y2 + 1
		CASE CHR$(0) + "K":     IF y1 > 1 THEN y3 = y1 - 1: y4 = y2 - 1
		CASE CHR$(13):          EXIT DO
	END SELECT
	GOSUB ScreenRestore
	GOSUB ScreenSave
	BasicBox x3, y3, x4, y4, SINGLELINE, NORMAL
	x1 = x3: x2 = x4: y1 = y3: y2 = y4
LOOP

GOSUB ScreenRestore

FileWindowErase cwin
fwin(cwin).x1 = x1: fwin(cwin).y1 = y1
fwin(cwin).x2 = x2: fwin(cwin).y2 = y2
FileWindowDraw cwin

BasicPrintStatus ""

EXIT SUB

ScreenSave:
	count = 0
	FOR x = y3 TO y4
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x3, x, 1)  'colour
		boxvidmem(count, 2) = SCREEN(x3, x, 0)  'ascii
	NEXT
	FOR x = x3 + 1 TO x4
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x, y4, 1)
		boxvidmem(count, 2) = SCREEN(x, y4, 0)
	NEXT
	FOR x = y4 - 1 TO y3 STEP -1
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x4, x, 1)
		boxvidmem(count, 2) = SCREEN(x4, x, 0)
	NEXT
	FOR x = x4 - 1 TO x3 + 1 STEP -1
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x, y3, 1)
		boxvidmem(count, 2) = SCREEN(x, y3, 0)
	NEXT
	RETURN

ScreenRestore:
	count = 0
	FOR x = y1 TO y2
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x1, x: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	FOR x = x1 + 1 TO x2
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x, y2: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	FOR x = y2 - 1 TO y1 STEP -1
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x2, x: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	FOR x = x2 - 1 TO x1 + 1 STEP -1
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x, y1: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	RETURN

END SUB

SUB MenuWinResize

BasicPrintStatus "Press one arrow key to indicate side to be moved"

DIM boxvidmem(1 TO 210, 1 TO 2) AS INTEGER

x1 = fwin(cwin).x1: y1 = fwin(cwin).y1: x2 = fwin(cwin).x2: y2 = fwin(cwin).y2
x3 = x1: y3 = y1: x4 = x2: y4 = y2

GOSUB SaveScreen
BasicBox x1, y1, x2, y2, SINGLELINE, NORMAL

DO
	DO: char$ = INKEY$: LOOP WHILE char$ = ""
	SELECT CASE char$
		CASE CHR$(0) + "H":     side = 1    'UP
		CASE CHR$(0) + "P":     side = 2    'DOWN
		CASE CHR$(0) + "M":     side = 3    'RIGHT
		CASE CHR$(0) + "K":     side = 4    'LEFT
	END SELECT
	IF side THEN EXIT DO
LOOP

BasicPrintStatus "Arrow keys - to move the side chosen ; Enter - indicates completion"


DO
	DO: char$ = INKEY$: LOOP WHILE char$ = ""
	SELECT CASE char$
		CASE CHR$(0) + "H":                 'up
			IF side = 1 THEN                'top line
				IF x1 > 2 THEN x3 = x1 - 1
			ELSEIF side = 2 THEN            'bottom line
				IF x2 - x1 > 3 THEN x4 = x2 - 1
			END IF
		CASE CHR$(0) + "P":                 'down
			IF side = 1 THEN                'top line
				IF x2 - x1 > 3 THEN x3 = x1 + 1
			ELSEIF side = 2 THEN            'bottom line
				IF x2 < 23 THEN x4 = x2 + 1
			END IF
		CASE CHR$(0) + "M":                 'right
			IF side = 3 THEN                'right side
				IF y2 < 80 THEN y4 = y2 + 1
			ELSEIF side = 4 THEN            'left line
				IF y2 - y1 > 25 THEN y3 = y1 + 1
			END IF
		CASE CHR$(0) + "K":                 'left
			IF side = 3 THEN                'right line
				IF y2 - y1 > 25 THEN y4 = y2 - 1
			ELSEIF side = 4 THEN            'left line
				IF y1 > 1 THEN y3 = y1 - 1
			END IF
		CASE CHR$(13):  EXIT DO
	END SELECT
	GOSUB RestoreScreen
	GOSUB SaveScreen
	BasicBox x3, y3, x4, y4, SINGLELINE, NORMAL
	x1 = x3: x2 = x4: y1 = y3: y2 = y4
LOOP

GOSUB RestoreScreen

FileWindowErase cwin
fwin(cwin).x1 = x1: fwin(cwin).y1 = y1
fwin(cwin).x2 = x2: fwin(cwin).y2 = y2
fwin(cwin).length = x2 - x1 - 1
fwin(cwin).wide = y2 - y1 - 1
IF fwin(cwin).curx > fwin(cwin).length THEN
	fwin(cwin).curx = fwin(cwin).length
	curline = fwin(cwin).startline
	FOR a = 1 TO fwin(cwin).curx - 1
		curline = memline(curline).nline
	NEXT
	fwin(cwin).curline = curline
END IF
IF fwin(cwin).cury > fwin(cwin).wide THEN fwin(cwin).cury = fwin(cwin).wide
IF LEN(memfile.onlyfilename) + 16 < fwin(cwin).wide THEN
	fwin(cwin).toplinefit = TRUE
ELSE
	fwin(cwin).toplinefit = FALSE
END IF
FileWindowDraw cwin

BasicPrintStatus ""

EXIT SUB

SaveScreen:
	count = 0
	FOR x = y3 TO y4
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x3, x, 1)  'colour
		boxvidmem(count, 2) = SCREEN(x3, x, 0)  'ascii
	NEXT
	FOR x = x3 + 1 TO x4
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x, y4, 1)
		boxvidmem(count, 2) = SCREEN(x, y4, 0)
	NEXT
	FOR x = y4 - 1 TO y3 STEP -1
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x4, x, 1)
		boxvidmem(count, 2) = SCREEN(x4, x, 0)
	NEXT
	FOR x = x4 - 1 TO x3 + 1 STEP -1
		count = count + 1
		boxvidmem(count, 1) = SCREEN(x, y3, 1)
		boxvidmem(count, 2) = SCREEN(x, y3, 0)
	NEXT
	RETURN

RestoreScreen:
	count = 0
	FOR x = y1 TO y2
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x1, x: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	FOR x = x1 + 1 TO x2
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x, y2: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	FOR x = y2 - 1 TO y1 STEP -1
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x2, x: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	FOR x = x2 - 1 TO x1 + 1 STEP -1
		count = count + 1
		Colour boxvidmem(count, 1)
		LOCATE x, y1: PRINT CHR$(boxvidmem(count, 2));
	NEXT
	RETURN

END SUB

SUB NaviDown

IF fwin(cwin).curline = memfile.tailline THEN EXIT SUB
IF fwin(cwin).curx = fwin(cwin).length THEN NaviScrollDown

fwin(cwin).curx = fwin(cwin).curx + 1
fwin(cwin).curline = memline(fwin(cwin).curline).nline

END SUB

SUB NaviEnd

NaviGoYPos memline(fwin(cwin).curline).lastchar

END SUB

SUB NaviEndOfFile

winbotlinenum = memline(fwin(cwin).startline).linenum + fwin(cwin).length - 1
IF memfile.taillinenum > winbotlinenum THEN
	'end of file is not in the current window
	DO
		winbotlinenum = winbotlinenum + 1
		fwin(cwin).startline = memline(fwin(cwin).startline).nline
		IF memfile.taillinenum = winbotlinenum THEN EXIT DO
	LOOP
	fwin(cwin).startchar = 1: DispFile
ELSEIF fwin(cwin).startchar <> 1 THEN       'window scrolled towards right
	fwin(cwin).startchar = 1: DispFile
END IF

fwin(cwin).curline = memfile.tailline
fwin(cwin).curx = memfile.taillinenum - memline(fwin(cwin).startline).linenum + 1
fwin(cwin).cury = 1

END SUB

SUB NaviGoYPos (charpos)
'Takes the cursor to a y-position adjusting startchar if necessary.

IF charpos = fwin(cwin).startchar + fwin(cwin).cury - 1 THEN EXIT SUB

IF (charpos < fwin(cwin).startchar) OR (charpos > (fwin(cwin).startchar + fwin(cwin).wide - 1)) THEN
	'not in window
	grp = charpos \ fwin(cwin).wide
	IF charpos MOD fwin(cwin).wide = 0 THEN grp = grp - 1
	fwin(cwin).startchar = (grp * fwin(cwin).wide) + 1
	DispFile
END IF

fwin(cwin).cury = charpos - fwin(cwin).startchar + 1

END SUB

SUB NaviHome

'find the position where first nonblank character begins
CharNum = 0
DO UNTIL CharNum = memline(fwin(cwin).curline).lastchar
	CharNum = CharNum + 1
	IF ASC(MID$(memline(fwin(cwin).curline).text, CharNum, 1)) > 32 THEN EXIT DO
LOOP

NaviGoYPos CharNum

END SUB

SUB NaviLeft

IF fwin(cwin).startchar + fwin(cwin).cury - 1 = 1 THEN EXIT SUB
IF fwin(cwin).cury = 1 THEN NaviScrollLeft
fwin(cwin).cury = fwin(cwin).cury - 1

END SUB

SUB NaviPgDn

winbotlinenum = memline(fwin(cwin).startline).linenum + fwin(cwin).length - 1
IF memfile.taillinenum <= winbotlinenum THEN EXIT SUB

FOR a = 1 TO fwin(cwin).length
	winbotlinenum = winbotlinenum + 1
	fwin(cwin).startline = memline(fwin(cwin).startline).nline
	fwin(cwin).curline = memline(fwin(cwin).curline).nline
	IF memfile.taillinenum = winbotlinenum THEN EXIT FOR
NEXT

DispFile

END SUB

SUB NaviPgUp

IF fwin(cwin).startline = memline(0).nline THEN EXIT SUB

FOR a = 1 TO fwin(cwin).length
	fwin(cwin).curline = memline(fwin(cwin).curline).pline
	fwin(cwin).startline = memline(fwin(cwin).startline).pline
	IF fwin(cwin).startline = memline(0).nline THEN EXIT FOR
NEXT

DispFile

END SUB

SUB NaviRight

IF fwin(cwin).startchar + fwin(cwin).cury - 1 = MAXLEN THEN
	IF MID$(memline(fwin(cwin).curline).text, MAXLEN - 1, 1) = "_" THEN
		'an unfinished line
		NaviStaOfNxtLine
	END IF
	EXIT SUB
END IF
IF fwin(cwin).cury = fwin(cwin).wide THEN NaviScrollRight
fwin(cwin).cury = fwin(cwin).cury + 1

END SUB

SUB NaviScreenLeft

IF fwin(cwin).startchar = 1 THEN EXIT SUB

fwin(cwin).startchar = fwin(cwin).startchar - fwin(cwin).wide
IF fwin(cwin).startchar < 1 THEN fwin(cwin).startchar = 1

DispFile

END SUB

SUB NaviScreenRight

winrgtchar = fwin(cwin).startchar + fwin(cwin).wide - 1

IF winrgtchar = MAXLEN THEN EXIT SUB

FOR a = 1 TO fwin(cwin).wide
	winrgtchar = winrgtchar + 1
	fwin(cwin).startchar = fwin(cwin).startchar + 1
	IF winrgtchar = MAXLEN THEN EXIT FOR
NEXT

DispFile

END SUB

SUB NaviScrollDown

IF memfile.taillinenum <= memline(fwin(cwin).startline).linenum + fwin(cwin).length - 1 THEN
	EXIT SUB        'the last line is in the window.
END IF

fwin(cwin).startline = memline(fwin(cwin).startline).nline
IF fwin(cwin).curx = 1 THEN     'top of window
	'visual coord remains same but curline changes.
	fwin(cwin).curline = memline(fwin(cwin).curline).nline
ELSE
	'lies on the same line but visual coord changes.
	fwin(cwin).curx = fwin(cwin).curx - 1
END IF

DispFile

END SUB

SUB NaviScrollLeft

IF fwin(cwin).startchar = 1 THEN EXIT SUB

fwin(cwin).startchar = fwin(cwin).startchar - 1
IF fwin(cwin).cury < fwin(cwin).wide THEN fwin(cwin).cury = fwin(cwin).cury + 1

DispFile

END SUB

SUB NaviScrollRight

IF fwin(cwin).startchar = MAXLEN - fwin(cwin).wide + 1 THEN EXIT SUB

fwin(cwin).startchar = fwin(cwin).startchar + 1
IF fwin(cwin).cury <> 1 THEN fwin(cwin).cury = fwin(cwin).cury - 1

DispFile

END SUB

SUB NaviScrollUp

IF fwin(cwin).startline = memline(0).nline THEN EXIT SUB

fwin(cwin).startline = memline(fwin(cwin).startline).pline
IF fwin(cwin).curx <> fwin(cwin).length THEN
	fwin(cwin).curx = fwin(cwin).curx + 1
ELSE
	fwin(cwin).curline = memline(fwin(cwin).curline).pline
END IF

DispFile

END SUB

SUB NaviStaOfNxtLine

NaviDown
NaviHome

END SUB

SUB NaviStartOfFile

fwin(cwin).curx = 1: fwin(cwin).cury = 1
fwin(cwin).curline = memline(0).nline
IF fwin(cwin).startline <> memline(0).nline OR fwin(cwin).startchar <> 1 THEN
	fwin(cwin).startline = memline(0).nline: fwin(cwin).startchar = 1
	DispFile
END IF

END SUB

SUB NaviUp

IF fwin(cwin).curline = memline(0).nline THEN EXIT SUB      'first file line
IF fwin(cwin).curx = 1 THEN NaviScrollUp
fwin(cwin).curx = fwin(cwin).curx - 1
fwin(cwin).curline = memline(fwin(cwin).curline).pline

END SUB

SUB NaviWordLeft

CharNum = fwin(cwin).startchar + fwin(cwin).cury - 1
IF CharNum = 1 THEN EXIT SUB

DO
	CharNum = CharNum - 1
	IF ASC(MID$(memline(fwin(cwin).curline).text, CharNum, 1)) > 32 THEN
		EXIT DO
	END IF
	IF CharNum = 1 THEN EXIT SUB
LOOP
DO
	CharNum = CharNum - 1
	IF ASC(MID$(memline(fwin(cwin).curline).text, CharNum, 1)) < 33 THEN
		CharNum = CharNum + 1: EXIT DO
	END IF
	IF CharNum = 1 THEN EXIT DO
LOOP
NaviGoYPos CharNum

END SUB

SUB NaviWordRight

CharNum = fwin(cwin).startchar + fwin(cwin).cury - 1
IF CharNum = memline(fwin(cwin).curline).lastchar THEN EXIT SUB 'also MAXLEN
IF CharNum > memline(fwin(cwin).curline).lastchar THEN
	NaviEnd
	EXIT SUB
END IF

DO
	IF ASC(MID$(memline(fwin(cwin).curline).text, CharNum, 1)) < 33 THEN EXIT DO
	CharNum = CharNum + 1
LOOP

DO
	IF CharNum >= memline(fwin(cwin).curline).lastchar THEN EXIT DO
	CharNum = CharNum + 1
	IF ASC(MID$(memline(fwin(cwin).curline).text, CharNum, 1)) > 32 THEN EXIT DO
LOOP
NaviGoYPos CharNum

END SUB

SUB ReadFile

done = FALSE
GOSUB dispmessbox

memfile.tailline = 1

memline(0).text = SPACE$(MAXLEN)
memline(0).pline = 0
memline(0).nline = 1

IF FileStatus <> 2 THEN
	OPEN memfile.filename FOR INPUT AS #1

	DIM Ztext, linecount
	linecount = 0: flag = FALSE
	'the flow in the following loop has been made such that an extra line
	'containing an ENTER is inserted at the end of file.
	DO
		linecount = linecount + 1
		IF flag THEN Ztext = CHR$(13) ELSE Ztext = ReadLine$(1)
		memline(linecount - 1).nline = linecount
		memline(linecount).pline = linecount - 1
		memline(linecount).text = Ztext
		memline(linecount).linenum = linecount
		memline(linecount).lastchar = LEN(Ztext)
		IF linecount = MAXLINES THEN flag = TRUE
		IF flag THEN EXIT DO
		IF EOF(1) THEN flag = TRUE
	LOOP
	memfile.tailline = linecount
	memfile.taillinenum = linecount
	CLOSE #1
	IF linecount = MAXLINES THEN
		t$ = WinMessage$("error", "Too long file to fit in memory!", "File should be less than " + STR$(MAXLINES) + " lines in length. RESTARTING...")
		RUN
	END IF
ELSE
	memline(1).text = CHR$(13)
	memline(1).lastchar = 1
	memline(1).linenum = 1
	memline(1).pline = 0
	memfile.tailline = 1
	memfile.taillinenum = 1
END IF
done = TRUE
GOSUB dispmessbox

EXIT SUB

dispmessbox:
	IF done THEN
		BasicPrintStatus ""
		'LOCATE 12, 57
		'PRINT "done."
		'FOR a = 1 TO 10000: NEXT
		'WinPopUp 0, 11, 19, 13, 63, DOUBLELINE, REVERSE, REVERSE, "ef"
	END IF
	IF NOT done THEN
		BasicPrintStatus "Reading File..."
	   
		'WinPopUp 0, 11, 19, 13, 63, DOUBLELINE, REVERSE, REVERSE, "dyf"
		'LOCATE 12, 20: Colour REVERSE
		'PRINT "File is being read into memory . . ."
	END IF
	RETURN

END SUB

'
'   Dos separates each line with enter(13) and linefeed(10),in that order.
'   Our editor will separate each line with only enter(13) in memory.
'   While saving, it will again add linefeed at the end of each line.
FUNCTION ReadLine$ (filenum)

DIM Zchar, Ztemp, count
count = 0
DO UNTIL EOF(1)
	count = count + 1
	Zchar = INPUT$(1, filenum)
	Ztemp = Ztemp + Zchar
	IF Zchar = CHR$(13) THEN
		Zchar = INPUT$(1, filenum)      'skip the following linefeed.
		EXIT DO
	END IF
	IF count = MAXLEN THEN              'the line does not fit
		MID$(Ztemp, MAXLEN - 1, 2) = "_" + CHR$(13)
		SEEK filenum, SEEK(filenum) - 2
	END IF
LOOP

ReadLine$ = Ztemp

END FUNCTION

SUB WinBox (x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr)
'Draws a box also painting it's interior

BasicBox x1, y1, x2, y2, ZBrdrLine, BrdrClr

'*paint interior
Colour ConClr
FOR a = (x1 + 1) TO (x2 - 1)
	LOCATE a, y1 + 1
	PRINT SPACE$(y2 - y1 - 1);
NEXT

END SUB

'
'   This sub will draw a popup box
'   It will be titled as 'title'
'   'msg1','msg2' will be printed
'   Press any key to continue
'   The width of the box will be set according to msg and paktc
'   The box will be moveable
'
FUNCTION WinMessage$ (Ztitle, Zmsg1, Zmsg2)

DIM x1, y1, x2, y2
DIM BoxWidth, BoxLength
DIM char AS STRING, side AS STRING * 1

'Decide X & Y coordinates Of The Box
	len1 = LEN(Zmsg1): len2 = LEN(Zmsg2)
	IF len1 < len2 THEN len0 = len2 ELSE len0 = len1
	IF len0 < 22 THEN BoxWidth = 27 ELSE BoxWidth = len0 + 5
	y1 = 41 - (BoxWidth \ 2): y2 = y1 + BoxWidth
	x1 = 8
	IF Zmsg2 = "" THEN BoxLength = 6 ELSE BoxLength = 8
	x2 = x1 + BoxLength

'Default settings
	ZBrdrLine = DOUBLELINE: BrdrClr = REVERSE: ConClr = REVERSE
   
	FOR a = MAXFILEWINDOWS + 1 TO MAXFILEWINDOWS + MAXOTHERWIND
		IF videomem(a, 1, 1).Colour = CHR$(1) THEN win = a: EXIT FOR
	NEXT
	IF win = 0 THEN
		ERROR 1
		'PRINT "!!!ERROR!!!"
		'PRINT "!!!No Memory left for dialog boxes.Ending...!!!"
		'SYSTEM
	END IF
	nx = x1: ny = y1
	LOCATE , , 0
	DO: char = INKEY$: LOOP UNTIL char = ""
'main loop
WinPopUp win, x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr, "dyf"
DO
	BasicCenter x1, y1, y2, " " + UCASE$(Ztitle) + " "
	BasicCenter x1 + 3, y1, y2, Zmsg1
	BasicCenter x1 + 4, y1, y2, Zmsg2
	LOCATE x1, y1 + 1: PRINT " " + CHR$(27) + CHR$(24) + CHR$(25) + CHR$(26) + " "
	LOCATE x2 - 1, y2 - 25: PRINT "Press one key to continue"
   
		DO: char = INKEY$: LOOP WHILE char = ""'"  "
		SELECT CASE char
			CASE CHR$(0) + "H"  'up
				IF x1 > 2 THEN
					nx = x1 - 1: side = "u"
				ELSE
					side = " "
				END IF
			CASE CHR$(0) + "M"  'right
				IF y2 < 79 THEN
					ny = y1 + 2: side = "r"
				ELSE
					side = " "
				END IF
			CASE CHR$(0) + "P"  'down
				IF x2 < 23 THEN
					nx = x1 + 1: side = "d"
				ELSE
					side = " "
				END IF
			CASE CHR$(0) + "K"  'left
				IF y1 > 2 THEN
					ny = y1 - 2: side = "l"
				ELSE
					side = " "
				END IF
			CASE ELSE
				WinMessage$ = char
				EXIT DO
		END SELECT
	IF side <> " " THEN
		WinPopUp win, x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr, "e" + side
		x1 = nx: y1 = ny: x2 = x1 + BoxLength: y2 = y1 + BoxWidth
		WinPopUp win, x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr, "dn" + side
	END IF
LOOP

WinPopUp win, x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr, "ef"

END FUNCTION

' This subroutine draws or erases a box storing the screen behind it.
' Parameter func:
'1>   "d" - draw, "e" - erase
'2>   "y" - inflate, "n" - simply draw
'3>   "f" - full box; "l","r","u","d" - box moved left,right,up or down
SUB WinPopUp (win, x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr, Zfunc) STATIC

LOCATE , , 0
IF win = 0 THEN win = MAXFILEWINDOWS + 1

SELECT CASE LEFT$(Zfunc, 1)
	CASE "d":
		videomem(win, 1, 1).Colour = CHR$(2)
		GOSUB store
		IF MID$(Zfunc, 2, 1) = "y" THEN     'make PopUp
			Boxcenterx = x1 + (x2 - x1) \ 2: halfx = x2 - Boxcenterx
			Boxcentery = y1 + (y2 - y1) \ 2: halfy = y2 - Boxcentery
			stepy = 0
			DO
				stepy = stepy + 1
				ny1 = Boxcentery - stepy: ny2 = Boxcentery + stepy
				stepx = CINT((stepy / halfy) * halfx)
				nx1 = Boxcenterx - stepx: nx2 = Boxcenterx + stepx
				IF nx1 < x1 THEN nx1 = x1
				WinBox nx1, ny1, nx2, ny2, ZBrdrLine, BrdrClr, ConClr
			LOOP UNTIL stepy = halfy - 1
			WinBox x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr
		ELSE    'simply draw the box
			WinBox x1, y1, x2, y2, ZBrdrLine, BrdrClr, ConClr
		END IF

	CASE "e":                        'restore screen
		SELECT CASE RIGHT$(Zfunc, 1)
			CASE "f":   a1 = x1: a2 = x2: b1 = y1: b2 = y2
			CASE "u":   a1 = x2: a2 = x2: b1 = y1: b2 = y2
			CASE "d":   a1 = x1: a2 = x1: b1 = y1: b2 = y2
			CASE "l":   a1 = x1: a2 = x2: b1 = y2 - 1: b2 = y2
			CASE "r":   a1 = x1: a2 = x2: b1 = y1: b2 = y1 + 1
		END SELECT
		FOR b = b1 TO b2: FOR a = a1 TO a2
			Colour ASC(videomem(win, a, b).Colour)
			LOCATE a, b: PRINT videomem(win, a, b).character
			videomem(win, a, b).Colour = " ": videomem(win, a, b).character = " "
		NEXT a, b
		IF RIGHT$(Zfunc, 1) = "f" THEN videomem(win, 1, 1).Colour = CHR$(1)
											   'render it reusable
END SELECT

EXIT SUB

store:
	SELECT CASE RIGHT$(Zfunc, 1)
		CASE "f":
			FOR a = x1 TO x2: FOR b = y1 TO y2
				videomem(win, a, b).Colour = CHR$(SCREEN(a, b, 1))
				videomem(win, a, b).character = CHR$(SCREEN(a, b, 0))
			NEXT b, a
		CASE "u":
			FOR a = y1 TO y2
				videomem(win, x1, a).Colour = CHR$(SCREEN(x1, a, 1))
				videomem(win, x1, a).character = CHR$(SCREEN(x1, a, 0))
			NEXT
		CASE "d":
			FOR a = y1 TO y2
				videomem(win, x2, a).Colour = CHR$(SCREEN(x2, a, 1))
				videomem(win, x2, a).character = CHR$(SCREEN(x2, a, 0))
			NEXT
		CASE "l":
			FOR a = x1 TO x2
				videomem(win, a, y1).Colour = CHR$(SCREEN(a, y1, 1))
				videomem(win, a, y1).character = CHR$(SCREEN(a, y1, 0))
				videomem(win, a, y1 + 1).Colour = CHR$(SCREEN(a, y1 + 1, 1))
				videomem(win, a, y1 + 1).character = CHR$(SCREEN(a, y1 + 1, 0))
			NEXT
		CASE "r":
			FOR a = x1 TO x2
				videomem(win, a, y2).Colour = CHR$(SCREEN(a, y2, 1))
				videomem(win, a, y2).character = CHR$(SCREEN(a, y2, 0))
				videomem(win, a, y2 - 1).Colour = CHR$(SCREEN(a, y2 - 1, 1))
				videomem(win, a, y2 - 1).character = CHR$(SCREEN(a, y2 - 1, 0))
			NEXT
	END SELECT
	RETURN

END SUB

