'******* DRAW.BAS *******
'CONTENT:
'   This program is a tiny drawing tool.
'
'NOTE:
'   This program consists of laboriously worked out routines of drawing
' lines, boxes and ellipses, without using the library routines available.
' This was done because the portion of the screen hidden by these elements
' was to be stored which was not possible by the library routines. These
' routines are highly instructive and should be observed as a guideline
' for any graphics program being made.
'   After carefully understanding the run-time storage technique employed in
' storing images, this program can serve as an icon maker to be used in
' graphics programs especially games. After drawing and saving the icon here
' the file can be read during the game and drawn on the screen. Then it
' should be stored in memory using the command provided in that language,
' and the image can then be easily used during the game.
'
' Program : Gaurang Khetan
'
DEFINT A-Z
TYPE hiddentype
    x AS INTEGER
    y AS INTEGER
    Colour AS INTEGER
END TYPE
TYPE menuitemtype
    Descrip AS STRING * 8
    NextInMenu AS INTEGER
    NextMenu AS INTEGER
    MainLetter AS STRING * 1
END TYPE
CONST TRUE = -1, FALSE = 0
CONST SCRNX1 = 0, SCRNY1 = 16, SCRNX2 = 639, SCRNY2 = 190
CONST MAXX = SCRNX2 - SCRNX1 - 1, MAXY = SCRNY2 - SCRNY1 - 1
CONST DELETE = 1, STOREDRAW = 2, NORMAL = 3 'for CursorDraw
CONST SEND = 1, NOSEND = 2  'for Ear1 etc.
CONST ALLOWDEC = 1, NODEC = 2  'for GetNum etc.
CONST TOTMENUITEMS = 21

DIM SHARED HiddenLine(0 TO 700) AS hiddentype
DIM SHARED HiddenBox(1 TO 1700)  AS hiddentype
DIM SHARED HiddenEllipse(1 TO 1700) AS hiddentype
DIM SHARED Menu(1 TO 30) AS menuitemtype
DIM SHARED NameOfFile AS STRING * 12, Mode, Colour
DIM SHARED CursorVisible
DIM SHARED ChangedMode  'if shell "mode co80" has been executed
DIM SHARED MenuInvoked
DIM SHARED ErrFlag      'flagging ON ERROR errors

DECLARE FUNCTION Ear1 (func)
DECLARE FUNCTION Ear2 (func)
DECLARE SUB Center (row, Text AS STRING)
DECLARE SUB DrawScreen ()
DECLARE SUB CursorDraw (x, y, func)
DECLARE SUB Main ()
DECLARE SUB PrintMode ()
DECLARE SUB PrintPos (x, y)
DECLARE SUB PrintStatus (Text AS STRING)
DECLARE SUB PaintArea (x, y)
DECLARE SUB DrawEllipse (x, y)
DECLARE SUB DrawLine (x1, y1, x2, y2, func)
DECLARE SUB DrawBox (x1, y1, x2, y2, func)
DECLARE SUB DrawEllipseSub (a, B, r, sa!, ea!, Aspect!, func)
DECLARE SUB SaveFigure ()
DECLARE SUB RestoreFigure (filename$, x1, y2, x2, y2)
DECLARE SUB LoadFigure ()
DECLARE SUB StoreFigure (filename$, x1, y1, x2, y2)
DECLARE SUB PrintColour (col%)
DECLARE FUNCTION Ear ()
DECLARE FUNCTION GetNum! (row, col, prompt AS STRING, maxdigit, decstatus)
DECLARE FUNCTION NotStoredBefore% (x AS SINGLE, y AS SINGLE, max)
DECLARE FUNCTION UserInput$ (row, col, prompt$, maxlen)
DECLARE FUNCTION realx% (x%)
DECLARE FUNCTION realy% (y%)
DECLARE FUNCTION userx% (x%)
DECLARE FUNCTION usery% (y%)
DECLARE SUB ModeLine ()
DECLARE SUB ModeBox ()
DECLARE SUB ModeEllipse ()
DECLARE SUB ModeFreHnd ()
DECLARE SUB ModePaint ()

'initialise
ON ERROR GOTO ScreenModeError
SCREEN 2
ON ERROR GOTO 0

FOR a = 1 TO TOTMENUITEMS
READ Menu(a).Descrip, Menu(a).NextInMenu, Menu(a).NextMenu, Menu(a).MainLetter
NEXT
NameOfFile = "UNTITLED"
Mode = 1
Colour = 1
CursorVisible = TRUE
ErrFlag = FALSE

DrawScreen
Main

IF ChangedMode THEN SHELL "mode mono"
SYSTEM

ScreenModeError:
    IF ChangedMode THEN PRINT "Monitor does not support graphics!!!": SYSTEM
    ChangedMode = TRUE
    SHELL "mode co80"
    RESUME

ChangeCursorStatus:
    CursorVisible = NOT CursorVisible
    RETURN

ChangeDrawColour:
    IF Colour = 1 THEN Colour = 0 ELSE Colour = 1
    PrintColour Colour
    RETURN

FileErr:
    ErrFlag = TRUE
    RESUME NEXT

DATA "File",7,2,"F","New",3,100,"N","Open",4,101,"O","Save",5,102,"S","saveAs",6,103,"A","eXit",0,104,"X"
DATA "Mode",13,8,"M","Line",9,105,"L","Box",10,106,"B","Ellipse",11,107,"E","Freehand",12,108,"F","Paint",0,109,"P"
DATA "View",17,14,"V","clearScrn",15,110,"S","Nocursor",16,111,"N","Chngcolour",0,112,"C"
DATA "Edit",0,18,"E","cuT",19,113,"T","coPy",20,114,"P","paSte",21,115,"S","Clear",0,116,"C"

SUB Center (row, Text AS STRING)

LOCATE row, 41 - LEN(Text) / 2
PRINT Text;

END SUB

'
'   Handles the drawing and erasing of cursor.
'   It also remembers the screen behind the cursor
'   Possible values of func: DELETE, STOREDRAW, NORMAL
'
SUB CursorDraw (newx, newy, func)

STATIC x, y         'holds real coordinates of cursor
STATIC hidscrn AS STRING * 12  'representing the twelve colours behind cursor
IF hidscrn = "            " THEN hidscrn = "000000000000"

IF func = DELETE OR func = NORMAL THEN
    ' restore screen on previous position of cursor
    FOR a = 1 TO 7: PSET (x - 4 + a, y), VAL(MID$(hidscrn, a, 1)): NEXT
    FOR a = 1 TO 5: PSET (x, y - 3 + a), VAL(MID$(hidscrn, 7 + a, 1)): NEXT
END IF

IF func = DELETE THEN EXIT SUB

'store screen on current cursor position

IF newx THEN x = realx(newx): y = realy(newy)

FOR a = 1 TO 7: MID$(hidscrn, a, 1) = CHR$(48 + POINT(x - 4 + a, y)): NEXT
FOR a = 1 TO 5: MID$(hidscrn, 7 + a, 1) = CHR$(48 + POINT(x, y - 3 + a)): NEXT

'draw cursor on current postion
FOR a = 1 TO 7
    IF VAL(MID$(hidscrn, a, 1)) THEN
        PSET (x - 4 + a, y), 0
    ELSE
        PSET (x - 4 + a, y), 1
    END IF
NEXT
FOR a = 1 TO 5
    IF VAL(MID$(hidscrn, 7 + a, 1)) THEN
        PSET (x, y - 3 + a), 0
    ELSE
        PSET (x, y - 3 + a), 1
    END IF
NEXT

DIM Text AS STRING * 7
Text = LTRIM$(STR$(userx(x))) + "," + LTRIM$(STR$(usery(y)))
LOCATE 1, 73: PRINT Text;

END SUB

SUB DrawBox (x1, y1, x2, y2, func)

DIM x3, x4, y3, y4

IF func = DELETE OR func = NORMAL THEN
    'restore previous screen
    a = 1
    DO UNTIL HiddenBox(a).Colour = -1
        PSET (HiddenBox(a).x, HiddenBox(a).y), HiddenBox(a).Colour
        a = a + 1
    LOOP
    HiddenBox(1).Colour = -1
END IF

IF func = DELETE THEN EXIT SUB

'store and draw
IF x1 < x2 THEN x3 = x1: x4 = x2 ELSE x3 = x2: x4 = x1
IF y1 < y2 THEN y3 = y1: y4 = y2 ELSE y3 = y2: y4 = y1
x3 = realx(x3): y3 = realy(y3): x4 = realx(x4): y4 = realy(y4)

'plain lines - horizontal and vertical
IF y3 = y4 THEN
    FOR a = 1 TO (x4 - x3 + 1)
        HiddenBox(a).y = y3
        HiddenBox(a).x = x3 + a - 1
        HiddenBox(a).Colour = POINT(HiddenBox(a).x, HiddenBox(a).y)
        PSET (HiddenBox(a).x, HiddenBox(a).y), Colour
    NEXT
    HiddenBox(x4 - x3 + 2).Colour = -1
    EXIT SUB
END IF

IF x3 = x4 THEN
    FOR a = 1 TO (y4 - y3 + 1)
        HiddenBox(a).x = x3
        HiddenBox(a).y = y3 + a - 1
        HiddenBox(a).Colour = POINT(HiddenBox(a).x, HiddenBox(a).y)
        PSET (HiddenBox(a).x, HiddenBox(a).y), Colour
    NEXT
    HiddenBox(y4 - y3 + 2).Colour = -1
    EXIT SUB
END IF

'now it is a box
'first horizontal line
a = 0
DO
     a = a + 1
     HiddenBox(a).y = y3: HiddenBox(a).x = x3 + a
     HiddenBox(a).Colour = POINT(HiddenBox(a).x, HiddenBox(a).y)
     PSET (HiddenBox(a).x, HiddenBox(a).y), Colour
     IF HiddenBox(a).x = x4 THEN EXIT DO
LOOP
B = 0
DO
    a = a + 1: B = B + 1
    HiddenBox(a).x = x4: HiddenBox(a).y = y3 + B
    HiddenBox(a).Colour = POINT(HiddenBox(a).x, HiddenBox(a).y)
    PSET (HiddenBox(a).x, HiddenBox(a).y), Colour
    IF HiddenBox(a).y = y4 THEN EXIT DO
LOOP
B = 0
DO
     a = a + 1: B = B + 1
     HiddenBox(a).y = y4: HiddenBox(a).x = x3 + B - 1
     HiddenBox(a).Colour = POINT(HiddenBox(a).x, HiddenBox(a).y)
     PSET (HiddenBox(a).x, HiddenBox(a).y), Colour
     IF HiddenBox(a).x = x4 - 1 THEN EXIT DO
LOOP
B = 0
DO
    a = a + 1: B = B + 1
    HiddenBox(a).x = x3: HiddenBox(a).y = y3 + B - 1
    HiddenBox(a).Colour = POINT(HiddenBox(a).x, HiddenBox(a).y)
    PSET (HiddenBox(a).x, HiddenBox(a).y), Colour
    IF HiddenBox(a).y = y4 - 1 THEN EXIT DO
LOOP
HiddenBox(a + 1).Colour = -1

END SUB

SUB DrawEllipse (x, y)

KEY(9) OFF

PrintStatus " "

Radius = GetNum(2, 30, "Radius(Default = 30):", 3, NODEC)
LOCATE 2, 30: PRINT SPACE$(42)

StartAngle! = GetNum(2, 25, "Starting Angle(Default = 0 deg):", 3, ALLOWDEC)
LOCATE 2, 25: PRINT SPACE$(45)

EndAngle! = GetNum(2, 25, "Ending Angle(Default = 360 deg):", 3, ALLOWDEC)
LOCATE 2, 25: PRINT SPACE$(45)

AspectRatio! = GetNum(2, 25, "AspectRatio(Default = 0.5):", 4, ALLOWDEC)
LOCATE 2, 25: PRINT SPACE$(45)

HiddenEllipse(1).Colour = -1
'CursorDraw x, y, x, y, DELETE

IF Radius = 0 THEN Radius = 30
IF EndAngle! = 0 THEN EndAngle! = 360
IF AspectRatio! = 0 THEN AspectRatio! = .5
DrawEllipseSub x, y, Radius, StartAngle!, EndAngle!, AspectRatio!, NORMAL

prevx = x: curx = x: prevy = y: cury = y
LOCATE 2, 9
PRINT USING "X: ### Y: ### Radius: ### SAngle: ### EAngle: ### Aspect: #.## "; curx; cury; Radius; StartAngle!; EndAngle!; AspectRatio!

DO
    DO: LOOP UNTIL INKEY$ = ""
    DO: Inp$ = INKEY$: LOOP WHILE Inp$ = ""
    SELECT CASE Inp$
        CASE CHR$(0) + "H": IF prevy > SCRNY1 + 1 THEN cury = prevy - 1 'up
        CASE CHR$(0) + "P": IF prevy < SCRNY2 - 1 THEN cury = prevy + 1 'down
        CASE CHR$(0) + "K": IF prevx > SCRNX1 + 1 THEN curx = prevx - 1 'left
        CASE CHR$(0) + "M": IF prevx < SCRNX2 - 1 THEN curx = prevx + 1 'right
        CASE CHR$(0) + "s":     'ctrllft
            IF prevx > SCRNX1 + 4 THEN curx = prevx - 4 ELSE curx = SCRNX1 + 1
        CASE CHR$(0) + "t":     'ctrlrgt
            IF prevx < SCRNX2 - 4 THEN curx = prevx + 4 ELSE curx = SCRNX2 - 1
       
        CASE CHR$(0) + "A": IF Radius > 1 THEN Radius = Radius - 1  'F7
        CASE CHR$(0) + "B": Radius = Radius + 1                     'F8

        CASE CHR$(0) + "C": IF AspectRatio! > .2 THEN AspectRatio! = AspectRatio! - .1
        CASE CHR$(0) + "D": AspectRatio! = AspectRatio! + .1        'F10
       
        'F11,F12,Shift+F11,Shift+F12
        CASE CHR$(0) + "": StartAngle! = StartAngle! - 2
                            IF StartAngle! < 0 THEN StartAngle! = 0
        CASE CHR$(0) + "": StartAngle! = StartAngle! + 2
                            IF StartAngle! > 360 THEN StartAngle! = 360
        CASE CHR$(0) + "": EndAngle! = EndAngle! - 2
                            IF EndAngle! < 1 THEN EndAngle! = 1
        CASE CHR$(0) + "": EndAngle! = EndAngle! + 2
                            IF EndAngle! > 720 THEN StartAngle! = 720

        CASE CHR$(13):      EXIT DO
        CASE CHR$(27):      EXIT SUB
        CASE ELSE:          notdone = TRUE
    END SELECT
    IF NOT notdone THEN
        LOCATE 2, 9
        PRINT USING "X: ### Y: ### Radius: ### SAngle: ### EAngle: ### Aspect: #.## "; curx; cury; Radius; StartAngle!; EndAngle!; AspectRatio!
        DrawEllipseSub curx, cury, Radius, StartAngle!, EndAngle!, AspectRatio!, NORMAL
    END IF
    prevy = cury: prevx = curx
    notdone = FALSE
LOOP

'CursorDraw x, y, x, y, STOREDRAW
PrintStatus ""

ON KEY(9) GOSUB ChangeDrawColour
KEY(9) ON

END SUB

SUB DrawEllipseSub (a, B, r, sa!, ea!, Aspect!, func)

'delete previous ellipse
IF func = DELETE OR func = NORMAL THEN
    t = 1
    DO UNTIL HiddenEllipse(t).Colour = -1
        PSET (HiddenEllipse(t).x, HiddenEllipse(t).y), HiddenEllipse(t).Colour
        t = t + 1
    LOOP
    HiddenEllipse(1).Colour = -1
END IF

IF func = DELETE THEN EXIT SUB

'store and draw required ellipse

DIM steps AS SINGLE, Angle AS SINGLE, AngleRad AS SINGLE
DIM x AS SINGLE, y AS SINGLE

k! = 3.14159 / 180
IF Aspect! > 1 THEN steps = 50 / (r * Aspect!) ELSE steps = 50 / r
t = 0
FOR Angle = sa! TO ea! STEP steps
    AngleRad = Angle * k!
    x = r * COS(AngleRad)
    y = r * SIN(AngleRad) * Aspect!
    x = CINT(a + x): y = CINT(B - y)
    IF y > SCRNY1 AND y < SCRNY2 THEN
        IF x > SCRNX1 AND x < SCRNX2 THEN
            IF NotStoredBefore(x, y, t) THEN
                t = t + 1
                HiddenEllipse(t).x = x: HiddenEllipse(t).y = y
                HiddenEllipse(t).Colour = POINT(x, y)
                PSET (x, y), Colour
            END IF
        END IF
    END IF
NEXT
HiddenEllipse(t + 1).Colour = -1

END SUB

SUB DrawLine (x1, y1, x2, y2, func)

'delete previous line
IF func = DELETE OR func = NORMAL THEN
    IF HiddenLine(0).Colour THEN
        FOR a = 1 TO HiddenLine(0).Colour
            PSET (HiddenLine(a).x, HiddenLine(a).y), HiddenLine(a).Colour
        NEXT
        HiddenLine(0).Colour = 0
    END IF
END IF

IF func = DELETE THEN EXIT SUB

DIM x, y, dx, dy, s1, s2
DIM i, e, Interchange

'Bresenham's Algorithm

x = realx(x1): y = realy(y1)
dx = ABS(x2 - x1): dy = ABS(y2 - y1)
s1 = SGN(x2 - x1): s2 = SGN(y2 - y1)

IF dy > dx THEN
    SWAP dx, dy
    Interchange = 1
ELSE
    Interchange = 0
END IF

e = (2 * dy) - dx

HiddenLine(0).Colour = dx

FOR i = 1 TO dx
    HiddenLine(i).x = x: HiddenLine(i).y = y
    HiddenLine(i).Colour = POINT(x, y)
    PSET (x, y)
   
    WHILE (e >= 0)
        IF Interchange THEN x = (x + s1) ELSE y = (y + s2)
        e = e - (2 * dx)
    WEND
    IF Interchange THEN y = (y + s2) ELSE x = (x + s1)
    e = e + (2 * dy)
NEXT i

END SUB

SUB DrawScreen

CLS
LOCATE 1, 1: PRINT "FILE: "; NameOfFile;
LOCATE 1, 24: PRINT "Mode: "; : PrintMode
LOCATE 1, 43: PRINT "Colour: "; Colour
LOCATE 1, 65: PRINT "Cursor: "

LINE (SCRNX1, SCRNY1)-(SCRNX2, SCRNY2), , B

END SUB

'   This is the main input engine of the program.
'   It manages the cursor movement. It returns specific
'   codes: 0 for cursor movement, 1 for escape, 2 for enter, 3 for "/"
'   It returns coordinates on the next two calls if enter was pressed
'   It also does the same if Mode was SEND and cursor movement was done
'   Possible values of Mode: SEND, NOSEND
'
FUNCTION Ear1 (func)

STATIC tosend1, tosend2
STATIC curx, cury       'user coordinates
IF curx = 0 THEN
    curx = (SCRNX2 - SCRNX1) / 2
    cury = (SCRNY2 - SCRNY1) / 2
END IF
IF tosend1 THEN
    Ear1 = tosend1: tosend1 = 0
    EXIT FUNCTION
ELSEIF tosend2 THEN
    Ear1 = tosend2: tosend2 = 0
    EXIT FUNCTION
END IF

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    t = 0
    SELECT CASE char$
        CASE CHR$(0) + "H": IF cury > 1 THEN cury = cury - 1        'up
        CASE CHR$(0) + "P": IF cury < MAXY THEN cury = cury + 1     'down
        CASE CHR$(0) + "K": IF curx > 1 THEN curx = curx - 1        'left
        CASE CHR$(0) + "M": IF curx < MAXX THEN curx = curx + 1     'right
        CASE CHR$(0) + "s":                                         'ctrllft
            IF curx > 4 THEN curx = curx - 4 ELSE curx = 1
        CASE CHR$(0) + "t":                                         'ctrlrgt
            IF curx < MAXX - 4 THEN curx = curx + 4 ELSE curx = MAXX
        CASE CHR$(27):      t = 1
        CASE CHR$(13):      t = 2
        CASE "/":           t = 3
        CASE ELSE:          t = 4
    END SELECT
    IF (t = 0 AND func = SEND) OR t = 2 THEN
        tosend1 = curx: tosend2 = cury
    END IF
    IF t = 0 AND CursorVisible THEN CursorDraw curx, cury, NORMAL
LOOP WHILE t = 4

Ear1 = t

END FUNCTION

' Menu enabled version of Ear1
' If Menu key "/" pressed then returns 3 and returns the command code
' on the next call
FUNCTION Ear2 (func)

STATIC tosend
IF tosend THEN
    Ear2 = tosend: tosend = 0
    EXIT FUNCTION
END IF

t = Ear1(func)
IF t = 3 THEN
    PrevMenu = 0
    MenuStart = 1
    DO UNTIL MenuStart > TOTMENUITEMS
        MatchFound = 0
        LOCATE 2, 2: PRINT SPACE$(79); : LOCATE 2, 2
        CurItem = MenuStart
        DO
            PRINT RTRIM$((Menu(CurItem).Descrip)); " ";
            CurItem = Menu(CurItem).NextInMenu
        LOOP WHILE CurItem
        DO
            DO: keypress$ = INKEY$: LOOP WHILE keypress$ = ""
            keypress$ = UCASE$(keypress$)
            IF keypress$ = CHR$(27) THEN
                IF PrevMenu THEN
                    MatchFound = FALSE
                    MenuStart = PrevMenu
                    PrevMenu = 0
                    EXIT DO
                ELSE
                    LOCATE 2, 1: PRINT SPACE$(79); : LOCATE 2, 1
                    Ear2 = Ear2(func)
                    EXIT FUNCTION
                END IF
            END IF
            Temp = MenuStart
            MatchFound = FALSE
            DO
                IF Menu(Temp).MainLetter = keypress$ THEN
                    MatchFound = Temp: EXIT DO
                ELSE
                    Temp = Menu(Temp).NextInMenu
                    IF Temp = 0 THEN EXIT DO
                END IF
            LOOP
            IF MatchFound THEN EXIT DO
        LOOP
        IF MatchFound THEN
            PrevMenu = MenuStart
            MenuStart = Menu(MatchFound).NextMenu
            MatchFound = 0
        END IF
    LOOP
    tosend = MenuStart
    LOCATE 2, 1: PRINT SPACE$(79); : LOCATE 2, 1
END IF

Ear2 = t

END FUNCTION

FUNCTION GetNum! (row, col, prompt AS STRING, maxdigit, decstatus)

LOCATE row, col: PRINT prompt
ans$ = "": r = row: C = col + LEN(prompt)
LOCATE r, C: PRINT ans$; "_"

DO
    Inp$ = INPUT$(1)
    SELECT CASE Inp$
        CASE "0" TO "9":      ' ".":
            IF LEN(ans$) < maxdigit THEN
                ans$ = ans$ + Inp$
                LOCATE r, C: PRINT ans$; "_"
            END IF
        CASE ".":
            IF decstatus = ALLOWDEC THEN
                IF LEN(ans$) < maxdigit THEN
                    ans$ = ans$ + Inp$
                    LOCATE r, C: PRINT ans$; "_"
                END IF
            END IF
        CASE CHR$(8):
            IF LEN(ans$) > 1 THEN
                ans$ = LEFT$(ans$, LEN(ans$) - 1)
                LOCATE r, C: PRINT ans$; "_"; " "
            ELSEIF LEN(ans$) = 1 THEN
                ans$ = ""
                LOCATE r, C: PRINT ans$; "_"; " "
            END IF
        CASE CHR$(13):
            GetNum! = VAL(ans$)
            EXIT FUNCTION
    END SELECT
LOOP
END FUNCTION

SUB LoadFigure

DIM Temp AS STRING * 1
DIM x1, y1, x2, y2

Start:

ON ERROR GOTO FileErr
DO
    LOCATE 2, 10: PRINT SPACE$(60)
    filename$ = UserInput$(2, 20, "Enter image's file name: ", 12)
    IF INSTR(filename$, ".") = 0 THEN filename$ = filename$ + ".IMG"

    ErrFlag = FALSE
    OPEN filename$ FOR INPUT AS #1
    CLOSE
LOOP WHILE ErrFlag
ON ERROR GOTO 0

OPEN filename$ FOR BINARY AS #1

IF LOF(1) < 9 THEN GOTO Start

FOR a = 1 TO 8
    GET #1, , Temp
    SELECT CASE a
        CASE 1: x1 = ASC(Temp):         CASE 2: x1 = x1 + (ASC(Temp) * 256)
        CASE 3: y1 = ASC(Temp):         CASE 4: y1 = y1 + (ASC(Temp) * 256)
        CASE 5: x2 = ASC(Temp):         CASE 6: x2 = x2 + (ASC(Temp) * 256)
        CASE 7: y2 = ASC(Temp):         CASE 8: y2 = y2 + (ASC(Temp) * 256)
    END SELECT
NEXT

x1 = realx(x1): y1 = realy(y1): x2 = realx(x2): y2 = realy(y2)

IF x1 < SCRNX1 + 1 OR x2 < SCRNX1 + 1 OR x1 > SCRNX2 - 1 OR x2 > SCRNX2 - 1 THEN
    GOTO Start
END IF
IF y1 < SCRNY1 + 1 OR y2 < SCRNY1 + 1 OR y1 > SCRNY2 - 1 OR y2 > SCRNY2 - 1 THEN
    GOTO Start
END IF
IF x1 > x2 OR y1 > y2 THEN
    GOTO Start
END IF

CLOSE #1

PrintStatus "Drawing..."

CursorDraw 0, 0, DELETE

RestoreFigure filename$, x1, y1, x2, y2

CursorDraw 0, 0, STOREDRAW

PrintStatus ""

END SUB

SUB Main

'center cursor at start
CursorDraw ((SCRNX2 - SCRNX1) \ 2), ((SCRNY2 - SCRNY1) \ 2), STOREDRAW
MenuInvoked = FALSE

DO
    IF MenuInvoked THEN
        Command = Ear2(NOSEND)
        SELECT CASE Command
            CASE 104:   EXIT DO
            CASE 105:   Mode = 1: PrintMode
            CASE 106:   Mode = 2: PrintMode
            CASE 108:   Mode = 4: PrintMode
            CASE 109:   Mode = 5: PrintMode
            CASE 102:   SaveFigure
            CASE 101:   LoadFigure
            CASE ELSE:  LOCATE 1, 1: PRINT "Comm="; Command;
        END SELECT
        MenuInvoked = FALSE
    END IF

    SELECT CASE Mode
        CASE 1:     ModeLine
        CASE 2:     ModeBox
        CASE 3:     ModeEllipse
        CASE 4:     ModeFreHnd
        CASE 5:     ModePaint
    END SELECT
LOOP

END SUB

SUB Main1

DIM prevx, prevy, curx, cury
DIM freehand, box
DIM x1, y1, x2, y2
DIM startedline, startedbox

prevx = (SCRNX1 + SCRNX2) / 2: prevy = (SCRNY1 + SCRNY2) / 2
curx = prevx: cury = prevy
freehand = FALSE: box = FALSE: startedbox = FALSE: startedline = FALSE
HiddenLine(1).Colour = -1: HiddenBox(1).Colour = -1
'CursorDraw prevx, prevy, curx, cury, STOREDRAW
PrintMode
PrintColour 1

ON KEY(5) GOSUB ChangeCursorStatus
ON KEY(9) GOSUB ChangeDrawColour
KEY(5) ON: KEY(9) ON

DO
    PrintPos prevx, prevy
   
    DO: Inp$ = INKEY$: LOOP WHILE Inp$ = ""
    SELECT CASE Inp$
        CASE CHR$(0) + "H": IF prevy > SCRNY1 + 1 THEN cury = prevy - 1 'up
        CASE CHR$(0) + "P": IF prevy < SCRNY2 - 1 THEN cury = prevy + 1 'down
        CASE CHR$(0) + "K": IF prevx > SCRNX1 + 1 THEN curx = prevx - 1 'left
        CASE CHR$(0) + "M": IF prevx < SCRNX2 - 1 THEN curx = prevx + 1 'right
        CASE CHR$(0) + "s":     'ctrllft
            IF prevx > SCRNX1 + 4 THEN curx = prevx - 4 ELSE curx = SCRNX1 + 1
        CASE CHR$(0) + "t":     'ctrlrgt
            IF prevx < SCRNX2 - 4 THEN curx = prevx + 4 ELSE curx = SCRNX2 - 1
           
        CASE CHR$(0) + "@":         'F6- save image
            'CursorDraw prevx, prevy, curx, cury, DELETE
            SaveFigure
            'CursorDraw prevx, prevy, curx, cury, STOREDRAW
       
        CASE CHR$(0) + CHR$(65):        'F7- retreive image
            'CursorDraw prevx, prevy, curx, cury, DELETE
            LoadFigure
            'CursorDraw prevx, prevy, curx, cury, STOREDRAW
           
        CASE CHR$(0) + CHR$(66):        'F8 - clears the screen
            DrawScreen
            'CursorDraw prevx, prevy, curx, cury, STOREDRAW
       
        CASE CHR$(13):                                              'enter
            IF NOT freehand THEN
                IF box THEN
                    IF startedbox THEN
                        startedbox = FALSE
                        HiddenBox(1).Colour = -1
                        PrintStatus ""
                    ELSE
                        startedbox = TRUE
                        x1 = prevx: y1 = prevy
                        PrintStatus "(" + LTRIM$(STR$(userx(x1))) + "," + LTRIM$(STR$(usery(y1))) + ")-"
                    END IF
                ELSE
                    IF startedline THEN
                        startedline = FALSE
                        HiddenLine(1).Colour = -1
                        PrintStatus ""
                    ELSE
                        startedline = TRUE
                        x1 = prevx: y1 = prevy
                        PrintStatus "(" + LTRIM$(STR$(userx(x1))) + "," + LTRIM$(STR$(usery(y1))) + ")-"
                    END IF
                END IF
            END IF
        CASE CHR$(0) + CHR$(59):                                        'F1
            'Freehand
            IF NOT (startedline OR startedbox) THEN
                box = FALSE
                freehand = NOT freehand
                IF freehand THEN PrintMode ELSE PrintMode
            END IF
        CASE CHR$(0) + CHR$(60):                                    'F2
            IF NOT (startedline OR startedbox) THEN
                PaintArea prevx, prevy
            END IF
        CASE CHR$(0) + CHR$(61):                                    'F3
            IF NOT (startedline OR startedbox) THEN
                freehand = FALSE: box = FALSE
                PrintMode
                DrawEllipse prevx, prevy
                PrintMode
            END IF
        CASE CHR$(0) + CHR$(62):                                  'F4
            'Box
            IF NOT (startedline OR startedbox) THEN
                freehand = FALSE
                box = NOT box
                IF box THEN PrintMode ELSE PrintMode
            END IF
        CASE CHR$(27):                                              'escape
            IF ChangedMode THEN SHELL "mode mono"
            SYSTEM
    END SELECT
    IF NOT (prevx = curx AND prevy = cury) THEN
        IF freehand THEN
            'CursorDraw prevx, prevy, curx, cury, DELETE
            LINE (prevx, prevy)-(curx, cury), Colour
            'CursorDraw prevx, prevy, curx, cury, STOREDRAW
        ELSE
            IF startedline THEN
                'CursorDraw prevx, prevy, curx, cury, DELETE
                DrawLine x1, y1, prevx, prevy, DELETE
                IF NOT (curx = x1 AND cury = y1) THEN
                    DrawLine x1, y1, curx, cury, STOREDRAW
                END IF
                'CursorDraw prevx, prevy, curx, cury, STOREDRAW
            ELSEIF startedbox THEN
                'CursorDraw prevx, prevy, curx, cury, DELETE
                DrawBox x1, y1, prevx, prevy, DELETE
                IF NOT (curx = x1 AND cury = y1) THEN
                    DrawBox x1, y1, curx, cury, STOREDRAW
                END IF
                'CursorDraw prevx, prevy, curx, cury, STOREDRAW
            ELSE
                'CursorDraw prevx, prevy, curx, cury, NORMAL
            END IF
        END IF
        prevx = curx: prevy = cury
    END IF
LOOP
END SUB

SUB ModeBox

DIM t, x1, y1, x2, y2

DO
    t = Ear2(NOSEND)
    IF t = 3 THEN
        MenuInvoked = TRUE
        EXIT SUB
    END IF
LOOP UNTIL t = 2
x1 = Ear2(NOSEND): y1 = Ear2(NOSEND)

CursorVisible = FALSE
CursorDraw 0, 0, DELETE
FirstDraw = TRUE  'this was introduced because when one line is drawn for the
   'first time (below in case 0) the line drawn before gets erased because
   'normal implies delete and storedraw in which delete actually deletes the
   ' line drawn previously
DO
    t = Ear1(SEND)
    SELECT CASE t
        CASE 0:   'cursor movement
            x2 = Ear1(SEND): y2 = Ear1(SEND)
            IF FirstDraw THEN
                DrawBox x1, y1, x2, y2, STOREDRAW
                FirstDraw = FALSE
            ELSE
                DrawBox x1, y1, x2, y2, NORMAL
            END IF
        CASE 1:       'escape
            DrawBox x1, y1, x2, y2, DELETE
            EXIT DO
        CASE 2:       'enter
            EXIT DO
        CASE 3:
            'no response to menu now
    END SELECT
LOOP

CursorVisible = TRUE
CursorDraw x2, y2, STOREDRAW

END SUB

SUB ModeEllipse


END SUB

SUB ModeFreHnd

DO
    t = Ear2(NOSEND)
    IF t = 3 THEN
        MenuInvoked = TRUE
        EXIT SUB
    END IF
LOOP UNTIL t = 2

CursorVisible = FALSE
CursorDraw 0, 0, DELETE

PSET (realx(Ear2(NOSEND)), realy(Ear2(NOSEND))), Colour
DO
    t = Ear1(SEND)
    IF t = 0 THEN
        x = realx(Ear2(NOSEND)): y = realy(Ear2(NOSEND))
        PSET (x, y), Colour
    END IF
LOOP UNTIL t = 2 OR t = 1

CursorDraw userx(x), usery(y), STOREDELETE
CursorVisible = TRUE

END SUB

SUB ModeLine

DIM t, x1, y1, x2, y2

DO
    t = Ear2(NOSEND)
    IF t = 3 THEN
        MenuInvoked = TRUE
        EXIT SUB
    END IF
LOOP UNTIL t = 2
x1 = Ear2(NOSEND): y1 = Ear2(NOSEND)

CursorVisible = FALSE
CursorDraw 0, 0, DELETE
FirstDraw = TRUE  'this was introduced because when one line is drawn for the
   'first time (below in case 0) the line drawn before gets erased because
   'normal implies delete and storedraw in which delete actually deletes the
   ' line drawn previously
DO
    t = Ear1(SEND)
    SELECT CASE t
        CASE 0:   'cursor movement
            x2 = Ear1(SEND): y2 = Ear1(SEND)
            IF FirstDraw THEN
                DrawLine x1, y1, x2, y2, STOREDRAW
                FirstDraw = FALSE
            ELSE
                DrawLine x1, y1, x2, y2, NORMAL
            END IF
        CASE 1:       'escape
            DrawLine x1, y1, x2, y2, DELETE
            EXIT DO
        CASE 2:       'enter
            EXIT DO
        CASE 3: 
            'no response to menu now
    END SELECT
LOOP

CursorVisible = TRUE
IF t = 1 THEN CursorDraw x1, y1, STOREDRAW ELSE CursorDraw x2, y2, STOREDRAW

END SUB

SUB ModePaint

DO
    t = Ear2(NOSEND)
    IF t = 3 THEN
        MenuInvoked = TRUE
        EXIT SUB
    END IF
LOOP UNTIL t = 2
x1 = Ear2(NOSEND): y1 = Ear2(NOSEND)

PaintArea x1, y1

END SUB

FUNCTION NotStoredBefore (x AS SINGLE, y AS SINGLE, max)

FOR t = 1 TO max
    IF x = HiddenEllipse(t).x THEN
        IF y = HiddenEllipse(t).y THEN
            NotStoredBefore = FALSE
            EXIT FUNCTION
        END IF
    END IF
NEXT

NotStoredBefore = TRUE

END FUNCTION

SUB PaintArea (x, y)

LOCATE 2, 1: PRINT "Whether completely Filled or Half filled?(F/H)"

DO
    DO: char$ = INKEY$: LOOP WHILE char$ = ""
    char$ = UCASE$(char$)
LOOP UNTIL char$ = "F" OR char$ = "H"

CursorDraw 0, 0, DELETE
SELECT CASE char$
    CASE "F":       PAINT (realx(x), realy(y)), 1, 1
    CASE "H":       PAINT (realx(x), realy(y)), CHR$(2), 1
END SELECT

CursorDraw 0, 0, STOREDRAW

LOCATE 2, 1: PRINT SPACE$(79);

END SUB

SUB PrintColour (col)

LOCATE 1, 50: PRINT SPACE$(2)
LOCATE 1, 50: PRINT col

END SUB

SUB PrintMode

DIM Text AS STRING * 8
SELECT CASE Mode
    CASE 1:     Text = "Line"
    CASE 2:     Text = "Box"
    CASE 3:     Text = "Ellipse"
    CASE 4:     Text = "FreeHand"
    CASE 5:     Text = "Paint"
END SELECT

LOCATE 1, 30: PRINT Text

END SUB

SUB PrintPos (x, y)

Text$ = LTRIM$(STR$(userx(x))) + "," + LTRIM$(STR$(usery(y)))
LOCATE 1, 73: PRINT Text$; SPACE$(7 - LEN(Text$));

END SUB

SUB PrintStatus (Text AS STRING)

LOCATE 2, 1
PRINT SPACE$(79)

IF Text <> "" THEN Center 2, Text

END SUB

FUNCTION realx (x)
realx = x + SCRNX1
END FUNCTION

FUNCTION realy (y)
realy = y + SCRNY1
END FUNCTION

SUB RestoreFigure (filename$, x1, y1, x2, y2)

DIM Temp AS STRING * 1

OPEN filename$ FOR BINARY AS #1

SEEK #1, 9      'to skip 8 bytes telling the coordinates of image

curbit = 1: x = x1: y = y1
DO
    GET #1, , Temp
    cursum = ASC(Temp)
    FOR z = 1 TO cursum
       
        IF curbit THEN PSET (x, y), curbit
       
        IF x = x2 THEN
            x = x1
            IF y = y2 THEN
                IF (z <> cursum) OR (LOC(1) <> LOF(1)) THEN
                    PrintStatus "EOF not where expected. Maybe corrupted. Press a key."
                    t$ = INPUT$(1)
                END IF
                EXIT DO
            ELSE
                y = y + 1
            END IF
        ELSE
            x = x + 1
        END IF
    NEXT
    IF curbit = 1 THEN curbit = 0 ELSE curbit = 1
LOOP

CLOSE #1

END SUB

SUB SaveFigure

'first find image-box coordinates

LOCATE 2, 1
PRINT "Goto Top-Left corner of image to be stored and press enter..."

DO
    t = Ear1(NOSEND)
LOOP UNTIL t = 2
x1 = Ear1(NOSEND): y1 = Ear1(NOSEND)

LOCATE 2, 1
PRINT "Goto Bottom-Right corner of image to be stored and press enter..."

DO
    t = Ear1(NOSEND)
LOOP UNTIL t = 2
x2 = Ear1(NOSEND): y2 = Ear1(NOSEND)

LOCATE 2, 1: PRINT SPACE$(79)

CursorDraw 0, 0, DELETE

ON ERROR GOTO FileErr
DO
    LOCATE 2, 20: PRINT SPACE$(40);
    filename$ = UserInput$(2, 20, "Name of file: ", 12)
    IF NOT INSTR(filename$, ".") THEN filename$ = filename$ + ".IMG"

    ErrFlag = FALSE
    OPEN filename$ FOR APPEND AS #1
    CLOSE
    IF NOT ErrFlag THEN EXIT DO
LOOP
ON ERROR GOTO 0
KILL filename$      'erase previously stored file

LOCATE 2, 1: PRINT SPACE$(79)

'''save image to file
StoreFigure filename$, x1, y1, x2, y2

CursorDraw 0, 0, STOREDRAW

END SUB

SUB StoreFigure (filename$, x1, y1, x2, y2)

DIM Temp AS STRING * 1      'put requires a one-byte string

OPEN filename$ FOR BINARY AS #1

'store coordinates of image
Temp = LEFT$(MKI$(x1), 1): PUT #1, , Temp
Temp = RIGHT$(MKI$(x1), 1): PUT #1, , Temp
Temp = LEFT$(MKI$(y1), 1): PUT #1, , Temp
Temp = RIGHT$(MKI$(y1), 1): PUT #1, , Temp
Temp = LEFT$(MKI$(x2), 1): PUT #1, , Temp
Temp = RIGHT$(MKI$(x2), 1): PUT #1, , Temp
Temp = LEFT$(MKI$(y2), 1): PUT #1, , Temp
Temp = RIGHT$(MKI$(y2), 1): PUT #1, , Temp

x1 = realx(x1): y1 = realy(y1): x2 = realx(x2): y2 = realy(y2)

curbit = 1: cursum = 0: x = x1: y = y1
DO
    IF POINT(x, y) = curbit THEN
        IF cursum = 255 THEN
            Temp = CHR$(255): PUT #1, , Temp
            Temp = CHR$(0): PUT #1, , Temp
            cursum = 0
        END IF
        cursum = cursum + 1
    ELSE
        Temp = CHR$(cursum): PUT #1, , Temp
        IF curbit = 1 THEN curbit = 0 ELSE curbit = 1
        cursum = 1
    END IF
   
    IF x = x2 THEN
        x = x1
        IF y = y2 THEN
            Temp = CHR$(cursum): PUT #1, , Temp
            EXIT DO
        ELSE
            y = y + 1
        END IF
    ELSE
        x = x + 1
    END IF
LOOP

CLOSE #1

END SUB

FUNCTION UserInput$ (row, col, prompt$, maxlen)

DIM char AS STRING, ans AS STRING

LOCATE row, col
PRINT prompt$; SPACE$(maxlen + 1);
LOCATE row, col + LEN(prompt$)
PRINT "_"

DO
    DO: char = INKEY$: LOOP WHILE char = ""
    SELECT CASE char
        CASE "a" TO "z", "A" TO "Z", "0" TO "9", ".":
                        IF LEN(ans) < maxlen THEN ans = ans + char
        CASE CHR$(27):  CLS : SYSTEM
        CASE CHR$(13):  EXIT DO
        CASE CHR$(8):   IF LEN(ans) > 0 THEN ans = LEFT$(ans, LEN(ans) - 1)
        CASE ELSE:  BEEP
    END SELECT
    LOCATE row, col + LEN(prompt$)
    PRINT ans; "_"; " ";
LOOP

LOCATE row, col + LEN(prompt$) + LEN(ans): PRINT " ";
UserInput$ = ans

LOCATE row, col: PRINT SPACE$(LEN(prompt$) + maxlen)

END FUNCTION

FUNCTION userx (x)
userx = x - SCRNX1
END FUNCTION

FUNCTION usery (y)
usery = y - SCRNY1
END FUNCTION

