'******COPY.BAS*****************
'
' This program functions partly as the COPY statement.
' The difference is that it checks whether the file already exists.
' The main disadvantage is that it can not work with
' BINARY files (executables).
' Thus it should be used with only BASIC files.
'
'  This file is called by the batch file update.bat.
' Generally, the batch file update.bat itself is called by
' another batch file updtall.bat using call. It uses a FOR
' command to process all files in the current directory.
'  Learnable is how this file and batch files update1.bat and
' update.bat are used in conjunction to update all files in the
' current directory

' PROCEDURE:
'0> Verify validity of input data.
'   Also, if it has an exe,com or sys extention, then exit program
'1> Check whether the file exists in the destination path
'   If it does not exist, copy the file and exit the program.
'   If it exists, then proceed.
'2> Check whether it has the same size as input file.
'   If it has the same size, then exit the program.
'   If they are not the the same, then copy this file to where required.
'3> Exit.
'
' Program : Gaurang Khetan
'

'declarations
    DEFINT A-Z
    CONST TRUE = -1, FALSE = 0
    DECLARE SUB Copy (file1$, file2$)
   
'code
DIM flag, stepno

filename$ = ENVIRON$("FILENAME")
updatepath$ = ENVIRON$("DESTPATH")
IF filename$ = "" THEN
    CLS
    PRINT "  PROGRAM :- UPDATE FILE TO THE SPECIFIED DESTINATION"
    PRINT
    INPUT "Which file to be copied"; filename$
    INPUT "Where is the file to be copied"; updatepath$
END IF
PRINT "Dealing with file: "; filename$

ON ERROR GOTO ErrorHandler

'check whether given file is acceptable
    stepno = 1
    OPEN filename$ FOR INPUT AS #1
    CLOSE #1

'check whether given path is accessible
    stepno = 2
    OPEN updatepath$ + "\zzz.zzz" FOR INPUT AS #1
    CLOSE #1

DO
    pslashpos = slashpos
    slashpos = INSTR(pslashpos + 1, filename$, "\")
LOOP WHILE slashpos

destfile$ = updatepath$ + "\" + MID$(filename$, pslashpos + 1)

'check whether file has an exe,sys or com extention
' if yes then exit program
dotpos = INSTR(MID$(filename$, pslashpos + 1), ".")
IF dotpos THEN
    ext$ = UCASE$(MID$(filename$, pslashpos + dotpos + 1))
    IF ext$ = "EXE" OR ext$ = "COM" OR ext$ = "SYS" THEN
        PRINT "Can't deal with binary files."
        SYSTEM
    END IF
END IF

'check whether file exists at the destination path.
    stepno = 3: flag = TRUE
    OPEN destfile$ FOR INPUT AS #1
    CLOSE #1

'if it does not exist, copy the file and exit
    stepno = 4
    IF flag = FALSE THEN
        PRINT "File does not exist at the destination."
        Copy filename$, destfile$
        SYSTEM
    END IF

'check the sizes of the source and the target file
    stepno = 5
    OPEN filename$ FOR INPUT AS #1
    OPEN destfile$ FOR INPUT AS #2
    IF LOF(1) = LOF(2) THEN flag = TRUE ELSE flag = FALSE
    CLOSE #1, #2

'if they are same then exit
    IF flag THEN
        PRINT "The files "; filename$; " and "; destfile$; " are same."
        SYSTEM
    END IF

'if they are not same then copy
    stepno = 6
    IF NOT flag THEN
        PRINT "The file "; destfile$; " and "; filename$; " are different."
        Copy filename$, destfile$
    END IF

SYSTEM

ErrorHandler:
    SELECT CASE stepno
        CASE 1:
            PRINT "Error("; ERR; ") during finding the file. Program terminated."
            SYSTEM
        CASE 2:
            IF ERR = 71 THEN
                PRINT "Enter disk in a:. Then press any key . . ."
                DO: LOOP UNTIL INKEY$ = ""
                SLEEP
                IF INKEY$ = CHR$(27) THEN PRINT "ABORTED.": SYSTEM
                RESUME
            ELSEIF ERR = 53 THEN
                RESUME NEXT
            ELSE
                PRINT "Error("; ERR; ").  Path inaccessible.  Program Terminated."
                SYSTEM
            END IF
        CASE 3:
            flag = FALSE
            RESUME NEXT
        CASE ELSE:
            PRINT "Unexpected Error("; ERR; ").  Program terminated."
            SYSTEM
    END SELECT
    RESUME

SUB Copy (file1$, file2$)

PRINT "Copying "; file1$; "...";

OPEN file1$ FOR INPUT AS #1
OPEN file2$ FOR OUTPUT AS #2

length& = LOF(1)

IF length& < 256 THEN
    strlngth = length&
    count& = 1
ELSE
    strlngth = 255
    count& = length& \ 255
END IF

FOR a& = 1 TO count&
    char$ = INPUT$(strlngth, #1)
    PRINT #2, char$;
NEXT

IF length& MOD strlngth THEN
    char$ = INPUT$(length& MOD strlngth, #1)
    PRINT #2, char$;
END IF

CLOSE #1, #2

PRINT " completed."

END SUB

