'
' CONTENT:
'       A program to solve the famous problem :-
'  How will you place 8 queens on a chessboard so that
'  no queen is attacked by the remaining 7 queens?
'       In other words :-
'  Which 8 squares will you select in a 8 X 8 square grid
'  so that not even one is in the line of others, a line being
'  vertical or horizontal or diagonal?

' NOTE:
'   There are 92 solutions to the above problem.
'   There is nothing special used in this program, but one could
' learn from the program, about how to manipulate output to the
' printer.
'
'

DEFINT A-Z
CONST EMPTY = 0, FILLED = -1
CONST FALSE = 0, TRUE = -1
CONST PRINTER = 1, CONSOLE = 2
DIM SHARED board(1 TO 8, 1 TO 8)

DECLARE FUNCTION isvalid (c, r)

ON ERROR GOTO ErrorHandler

CLS
WIDTH LPRINT 132

DO
    PRINT "Output Device? (S for monitor, P for printer)"
    outdevi$ = UCASE$(INPUT$(1))
LOOP UNTIL outdevi$ = "P" OR outdevi$ = "S"
IF outdevi$ = "S" THEN outdev = CONSOLE ELSE outdev = PRINTER

FOR a = 1 TO 8: FOR b = 1 TO 8
    board(a, b) = EMPTY
NEXT b, a

FOR a = 1 TO 8
  board(a, 1) = FILLED
  FOR b = 1 TO 8
    IF isvalid(b, 2) THEN
    board(b, 2) = FILLED
    FOR c = 1 TO 8
      IF isvalid(c, 3) THEN
      board(c, 3) = FILLED
      FOR d = 1 TO 8
        IF isvalid(d, 4) THEN
        board(d, 4) = FILLED
        FOR e = 1 TO 8
          IF isvalid(e, 5) THEN
          board(e, 5) = FILLED
          FOR f = 1 TO 8
            IF isvalid(f, 6) THEN
            board(f, 6) = FILLED
            FOR g = 1 TO 8
              IF isvalid(g, 7) THEN
              board(g, 7) = FILLED
              FOR h = 1 TO 8
                IF isvalid(h, 8) THEN
                board(h, 8) = FILLED
                GOSUB PrintPattern
                board(h, 8) = EMPTY
                END IF
              NEXT h
              board(g, 7) = EMPTY
              END IF
            NEXT g
            board(f, 6) = EMPTY
            END IF
          NEXT f
          board(e, 5) = EMPTY
          END IF
        NEXT e
        board(d, 4) = EMPTY
        END IF
      NEXT d
      board(c, 3) = EMPTY
      END IF
    NEXT c
    board(b, 2) = EMPTY
    END IF
  NEXT b
  board(a, 1) = EMPTY
NEXT a
              
END

PrintPattern:
    count = count + 1
    SELECT CASE outdev
        CASE PRINTER
            IF count MOD 2 = 1 THEN LPRINT  ELSE LPRINT "             ";
            LPRINT "Pattern No."; count; " :-";
            FOR x = 1 TO 8: FOR y = 1 TO 8
                IF board(x, y) = FILLED THEN
                    LPRINT CHR$(96 + x); LTRIM$(STR$(y)); "  ";
                END IF
            NEXT y, x
        CASE CONSOLE
            IF count MOD 20 = 0 THEN
                PRINT "Press any key ..."
                SLEEP
                CLS
            END IF
            PRINT count; ". ";
            FOR x = 1 TO 8: FOR y = 1 TO 8
                IF board(x, y) = FILLED THEN
                    PRINT CHR$(96 + x); LTRIM$(STR$(y)); "  ";
                END IF
            NEXT y, x
            PRINT
    END SELECT
    RETURN

ErrorHandler:
    IF ERR = 25 THEN
        PRINT "Error in accessing printer!?!"
    ELSE
        PRINT "Unexpected error: "; ERR; " occured."
    END IF
    SYSTEM

FUNCTION isvalid (c, r)

isvalid = FALSE
'check for column matching
    FOR y = 1 TO 8
        IF board(c, y) = FILLED THEN EXIT FUNCTION
    NEXT

'check for positive slope diagonal matching
    FOR x = 1 TO 8
        y = x - c + r
        IF y < 9 AND y > 0 THEN
            IF board(x, y) = FILLED THEN EXIT FUNCTION
        END IF
    NEXT

'check for negative slope diagonal matching
    FOR x = 1 TO 8
        y = r + c - x
        IF y < 9 AND y > 0 THEN
            IF board(y, x) = FILLED THEN EXIT FUNCTION
        END IF
    NEXT
'else
isvalid = TRUE

END FUNCTION

