
DEFINT A-Z
CONST TRUE = -1, FALSE = 0
CONST MEDIUM = 1, DARK = 2, BRIGHT = 3
CONST NORMAL = 4, PRESSED = 5
CONST UPPERLEFT = 6, LOWERRIGHT = 7, BOTH = 8
CONST BUTTONCOLOR = MEDIUM, SHINING = BRIGHT, SHADOW = DARK

DECLARE SUB Center (r, c1, c2, text$)
DECLARE SUB box (x1, y1, x2, y2, state)
DECLARE SUB Button (r, c, textlen, text$, state)
DECLARE FUNCTION Answer (prompt1$, prompt2$, ans1$, ans2$, ans3$, ans4$)

CLS
SCREEN 1

ans = Answer("Do you want to continue . . .", "", "YES", "NO", "", "")

END

FUNCTION Answer (prompt1$, prompt2$, ans1$, ans2$, ans3$, ans4$)

DIM boxwidth, boxheight, anscount

anscount = 4
IF ans4$ = "" THEN anscount = anscount - 1
IF ans3$ = "" THEN anscount = anscount - 1
IF ans2$ = "" THEN anscount = anscount - 1

IF LEN(prompt1$) > LEN(prompt2$) THEN
    boxwidth = LEN(prompt1$) * 8 + 32
ELSE
    boxwidth = LEN(prompt2$) * 8 + 32
END IF

IF prompt2$ = "" THEN boxheight = 32 ELSE boxheight = 40

IF boxwidth < (anscount * 75) THEN boxwidth = (anscount * 75)

x1 = 160 - boxwidth / 2: x2 = x1 + boxwidth
y1 = 100 - boxheight / 2: y2 = y1 + boxheight

box x1, y1, x2, y2, BOTH
LOCATE y1 \ 8 + 2, x1 \ 8 + 2
PRINT prompt1$


DO
    SLEEP 1
    Button y2 \ 8, ((x1 + x2) \ 2) \ 8 - 4, 8, ans1$, NORMAL
    SLEEP 1
    Button y2 \ 8, ((x1 + x2) \ 2) \ 8 - 4, 8, ans1$, PRESSED
LOOP

END FUNCTION

SUB box (x1, y1, x2, y2, state)

SELECT CASE state
    CASE UPPERLEFT:     col1 = SHINING: col2 = SHADOW
    CASE LOWERRIGHT:    col2 = SHINING: col1 = SHADOW
    CASE BOTH:          col1 = BUTTONCOLOR: col2 = BUTTONCOLOR
END SELECT

LINE (x1, y1)-(x2, y1), col1
LINE (x1, y1)-(x1, y2), col1

LINE (x2, y1 + 1)-(x2, y2), col2
LINE (x1 + 1, y2)-(x2, y2), col2

END SUB

SUB Button (r, c, textlen, text$, state)

buttwidth = (textlen * 8)
buttheight = 11
y1 = (r - 1) * 8 - 3
x1 = (c - 1) * 8
x2 = x1 + buttwidth + 1
y2 = y1 + buttheight + 1

IF LEN(text$) > textlen THEN text$ = LEFT$(text$, textlen - 2) + ".."

SELECT CASE state
    CASE NORMAL:    z = UPPERLEFT
    CASE PRESSED:   z = LOWERRIGHT
END SELECT

box x1, y1, x2, y2, z
box x1 - 1, y1 - 1, x2 + 1, y2 + 1, z

box x1 + 1, y1 + 1, x2 - 1, y2 - 1, BOTH
PAINT ((x1 + x2) / 2, (y1 + y2) / 2), BUTTONCOLOR

Center r, c, c + textlen + 1, text$

END SUB

SUB Center (r, c1, c2, text$)

LOCATE r, INT(((c1 + c2) / 2) - (LEN(text$) / 2))
PRINT text$;

END SUB

