DECLARE FUNCTION DidBallBrkCol% (r%, c%, ballcol AS SINGLE, ballrow AS SINGLE)
' BRICKS!

DEFINT A-Z
CONST PI = 3.14159, HALFPI = PI / 2                      'some real constants
CONST ONEHALFPI = 1.5 * PI, TWICEPI = 2 * PI
CONST TRUE = -1, FALSE = 0
CONST ONLYDRAW = 1, ONLYERASE = 2, ERASEDRAW = 3          'parameters to subs
CONST VERTICAL = 1, HORIZONTAL = 2                     'return values of func
CONST BRKHGHT = 6, BRKWDTH = 17                             'bricks
CONST BRKLINES = 15, BRKSINLINE = 16
CONST WALLWDTH = 10, WALLGAPROW = 173, WALLGAPCOL = 288     'wall
CONST WALLSTARTCOL = 5, WALLSTARTROW = 17
CONST PADHGHT = 2, PADWDTH = 30                             'paddle
CONST PADROW = WALLSTARTROW + WALLWDTH + WALLGAPROW - PADHGHT, PADSPEED = 4
CONST BALLRAD = 3, BALLINC = 1, BALLSLOWNESS = 1            'ball
CONST BALLWDTH = (2 * BALLRAD)
CONST PADCLR = 1, BRKCLR = 2, WALLCLR = 3, BALLCLR = 3      'colors
CONST FACTOR = HALFPI / (PADWDTH / 3)

DECLARE SUB Initialize ()
DECLARE SUB SetLevel ()
DECLARE SUB Main ()
DECLARE SUB BrickDraw (r, c)
DECLARE SUB BrickErase (r, c)
DECLARE SUB OfBall (c, r, parameter)
DECLARE SUB OfPaddle (c, parameter)
DECLARE SUB GameEnd ()
DECLARE SUB DrawLevel ()
DECLARE SUB BallNext (x AS SINGLE, y AS SINGLE, padpos, balldirctn AS SINGLE)
DEF FNhORI! (direction AS SINGLE) = TWICEPI - direction
DEF FNvERT! (direction AS SINGLE) = ((2 + SGN(direction - PI)) * PI) - direction

DIM SHARED paddle(1 TO 18)      'if pad, brk and ball dimensions are changed
DIM SHARED brick(1 TO 17)       'then change these array sizes also
DIM SHARED ball(1 TO 13)
DIM SHARED bricks(1 TO BRKLINES, 1 TO BRKSINLINE)

Initialize
Main

GameEnd

SUB BallNext (x AS SINGLE, y AS SINGLE, padpos, balldirctn AS SINGLE)

IF y >= (WALLGAPROW - BALLWDTH - PADHGHT + 1) THEN
    temp = PADWDTH \ 3          'if ball has touched the paddle
    SELECT CASE x
        CASE padpos TO (padpos + temp)
            balldirctn = (PI - .1) - (FACTOR * (x - padpos))
        CASE (padpos + temp) TO (padpos + (2 * temp))
            balldirctn = FNhORI!(balldirctn)
        CASE (padpos + (2 * temp)) TO (padpos + PADWDTH)
            balldirctn = FACTOR * ((padpos + PADWDTH) - x)
    END SELECT
END IF

p = INT(y / (BRKHGHT + 1)): q = INT(x / (BRKWDTH + 1))
FOR a = 0 TO 2
    FOR b = 0 TO 2
        r = p + a: s = q + b
        IF r <> 0 AND r < BRKLINES AND c <> 0 AND c < BRKSINLINE THEN
            IF bricks(p + a, q + b) THEN
                collision = DidBallBrkCol(p + a, q + b, x, y)
                IF collision THEN
                    bricks(p + a, q + b) = FALSE
                    BrickErase p + a, q + b
                    IF collision = HORIZONTAL THEN
                        balldirctn = FNhORI!(balldirctn)
                    ELSEIF collision = VERTICAL THEN
                        balldirctn = FNvERT!(balldirctn)
                    END IF
                END IF
            END IF
        END IF
    NEXT
NEXT

IF y < ((BRKLINES * (BRKHGHT + 1)) + WALLWDTH + WALLSTARTROW) THEN
    FOR a = 1 TO BRKLINES
        FOR b = 1 TO BRKSINLINE
            IF bricks(a, b) THEN
                collision = DidBallBrkCol(a, b, x, y)
                IF collision THEN
                    bricks(a, b) = FALSE
                    BrickErase a, b
                    IF collision = HORIZONTAL THEN
                        balldirctn = FNhORI!(balldirctn)
                    ELSEIF collision = VERTICAL THEN
                        balldirctn = FNvERT!(balldirctn)
                    END IF
                END IF
            END IF
        NEXT
    NEXT
END IF

DIM x1 AS SINGLE, y1 AS SINGLE
 
x1 = x + (BALLINC * COS(balldirctn))
y1 = y - (BALLINC * SIN(balldirctn))

IF (x1 < 1) OR (x1 > WALLGAPCOL - BALLWDTH) THEN
    balldirctn = FNvERT!(balldirctn)
    BallNext x, y, padpos, balldirctn
    EXIT SUB
ELSEIF (y1 < 1) THEN
    balldirctn = FNhORI!(balldirctn)
    BallNext x, y, padpos, balldirctn
    EXIT SUB
ELSEIF y1 > (WALLGAPROW - BALLWDTH + 1) THEN
    LOCATE 1, 1: PRINT "You Lost"
    SLEEP: GameEnd
END IF


x = x1: y = y1

END SUB

SUB BrickDraw (r, c)
'draws the brick given it's array coordinates

x = (WALLSTARTCOL + WALLWDTH + 1) + ((c - 1) * (BRKWDTH + 1))
y = (WALLSTARTROW + WALLWDTH + 1) + ((r - 1) * (BRKHGHT + 1))

PUT (x, y), brick

END SUB

SUB BrickErase (r, c)
'erases the brick given it's array coordinates

BrickDraw r, c

END SUB

FUNCTION DidBallBrkCol (r, c, ballcol AS SINGLE, ballrow AS SINGLE)

DidBallBrkCol = FALSE

kx1 = (WALLSTARTCOL + WALLWDTH + 1) + ((c - 1) * (BRKWDTH + 1))
ky1 = (WALLSTARTROW + WALLWDTH + 1) + ((r - 1) * (BRKHGHT + 1))
kx2 = kx1 + BRKWDTH: ky2 = ky1 + BRKHGHT
lx1 = ballcol + WALLSTARTCOL + WALLWDTH: ly1 = WALLSTARTROW + WALLWDTH + ballrow
lx2 = lx1 + BALLWDTH: ly2 = ly1 + BALLWDTH

IF lx1 > kx2 THEN EXIT FUNCTION
IF lx2 < kx1 THEN EXIT FUNCTION
IF ly1 > ky2 THEN EXIT FUNCTION
IF ly2 < ky1 THEN EXIT FUNCTION

IF (lx1 - kx2) < 1 OR (kx1 - lx2) < 1 THEN
    DidBallBrkCol = VERTICAL
ELSE
    DidBallBrkCol = HORIZONTAL
END IF

END FUNCTION

SUB DrawLevel

FOR a = 1 TO BRKLINES
    FOR b = 1 TO BRKSINLINE
        IF bricks(a, b) THEN BrickDraw a, b
    NEXT
NEXT

END SUB

SUB GameEnd

'CLS
SYSTEM

END SUB

SUB Initialize

CLS
SCREEN 1, 1
    
'*get paddle in array
LINE (1, 1)-(PADWDTH, PADHGHT), PADCLR, BF
GET (1, 1)-(PADWDTH, PADHGHT), paddle
PUT (1, 1), paddle

'*get brick in array
LINE (1, 1)-(BRKWDTH, BRKHGHT), BRKCLR, B
PAINT (2, 2), CHR$(10) + CHR$(100), BRKCLR
GET (1, 1)-(BRKWDTH, BRKHGHT), brick
PUT (1, 1), brick

'*get ball in array
CIRCLE (160, 100), BALLRAD
PAINT (160, 100), BALLCLR
GET (160 - BALLRAD, 100 - BALLRAD + 1)-(160 + BALLRAD, 100 + BALLRAD - 1), ball
PUT (160 - BALLRAD, 100 - BALLRAD + 1), ball

'*draw walls
x1 = WALLSTARTCOL: y1 = WALLSTARTROW
x2 = x1 + WALLGAPCOL + (2 * WALLWDTH): y2 = y1 + WALLWDTH
x3 = x1 + WALLWDTH: y3 = y2
x4 = x1: y4 = WALLSTARTROW + WALLWDTH + WALLGAPROW
x5 = x2 - WALLWDTH: y5 = y3
x6 = x2: y6 = y4
LINE (x1, y1)-(x2, y2), WALLCLR, BF     'draw top slab
LINE (x3, y3)-(x4, y4), WALLCLR, BF     'draw left slab
LINE (x5, y5)-(x6, y6), WALLCLR, BF     'draw right slab

'*draw bricks
SetLevel
DrawLevel

END SUB

SUB Main

'these coor are relative to corresponding references -- see their draw subs
DIM padcol AS INTEGER, ballcol AS SINGLE, ballrow AS SINGLE
DIM prevdrawtime AS SINGLE, elaptime AS SINGLE, balltime AS SINGLE 'time ball
DIM balldirctn AS SINGLE    'in radians from 0 to 6.28

'intial values
padcol = 1
ballrow = WALLGAPROW \ 2: ballcol = WALLGAPCOL \ 2
balltime = 0
balldirctn = .5
prevdrawtime = TIMER

OfPaddle padcol, ONLYDRAW             'draw ball & paddle
OfBall CINT(ballcol), CINT(ballrow), ONLYDRAW     'in initial positions

DO  '* MAIN LOOP OF BRICKS
   
    '*for paddle
    SELECT CASE INKEY$
        CASE CHR$(0) + "M":     padcol = padcol + PADSPEED
        CASE CHR$(0) + "K":     padcol = padcol - PADSPEED
        CASE CHR$(27):          GameEnd
    END SELECT
    IF padcol < 1 THEN padcol = 1
    IF padcol > (WALLGAPCOL - PADWDTH) THEN padcol = WALLGAPCOL - PADWDTH
    OfPaddle padcol, ERASEDRAW

    '*for ball
    elaptime = TIMER - prevdrawtime
    'LOCATE 1, 1: PRINT elaptime
    IF elaptime >= balltime THEN
        BallNext ballcol, ballrow, padcol, balldirctn  'brain of program
        OfBall CINT(ballcol), CINT(ballrow), ERASEDRAW
        prevdrawtime = TIMER
    END IF
LOOP

END SUB

SUB OfBall (c, r, parameter)
'parameter: ONLYERASE, ONLYDRAW, ERASEDRAW

STATIC prevcol, prevrow AS INTEGER

IF parameter <> ONLYDRAW THEN
    PUT (prevcol, prevrow), ball        'erase
END IF
IF parameter = ONLYERASE THEN EXIT SUB

'redraw
col = WALLSTARTCOL + WALLWDTH + c
row = WALLSTARTROW + WALLWDTH + r
PUT (col, row), ball

prevcol = col: prevrow = row

END SUB

SUB OfPaddle (c, parameter)
'parameter: ONLYDRAW, ONLYERASE, ERASEDRAW
STATIC prevcol AS INTEGER

realc = WALLSTARTCOL + WALLWDTH + c

IF parameter = ERASEDRAW THEN           'if paddle has not changed it's pos
    IF prevcol = realc THEN EXIT SUB    'then there is no need to redraw
END IF                                  ' it in the same pos

IF parameter <> ONLYDRAW THEN
    PUT (prevcol, PADROW), paddle       'if paddle was drawn then erase it
END IF
IF parameter = ONLYERASE THEN EXIT SUB

'redraw in new position
PUT (realc, PADROW), paddle

prevcol = realc

END SUB

SUB SetLevel

STATIC level AS INTEGER
level = level + 1

SELECT CASE level
    CASE 1:
        FOR a = 4 TO 10
            FOR b = 1 TO BRKSINLINE
                bricks(a, b) = TRUE
            NEXT
        NEXT
END SELECT

END SUB

