
'*To draw lines and circles using Bresenham's algorithm

DECLARE SUB DrawLine (x1 AS INTEGER, y1 AS INTEGER, x2 AS INTEGER, y2 AS INTEGER)
DECLARE SUB DrawCircle (x1 AS INTEGER, y1 AS INTEGER, rad AS INTEGER)

DEFINT A-Z
SCREEN 2


SLEEP
DrawLine 10, 190, 500, 10
DrawCircle 320, 100, 50

SUB DrawCircle (x1 AS INTEGER, y1 AS INTEGER, rad AS INTEGER)

DIM x AS INTEGER, y AS INTEGER, d AS INTEGER
DIM limit AS INTEGER
DIM delta1 AS INTEGER, delta2 AS INTEGER

'**** THE STANDARD BRESENHAM'S ALGOTRITHM FOR A CIRCLE*****
x = 0: y = rad
d = 2 * (1 - rad)
limit = 0

1   PSET (2 * x, y)             'x is multiplied by 2 because for this screen,
    IF y <= limit THEN EXIT SUB         'x-division is half that of y-division
    IF d < 0 THEN 2
    IF d > 0 THEN 3
    IF d = 0 THEN 20

2   delta1 = (2 * d) + (2 * y) - 1
    IF delta1 <= 0 THEN 10
    IF delta1 > 0 THEN 20

3   delta2 = (2 * d) - (2 * x) - 1
    IF delta2 <= 0 THEN 20
    IF delta2 > 0 THEN 30

10  x = x + 1
    d = d + (2 * x) + 1
    GOTO 1

20  x = x + 1
    y = y - 1
    d = d + (2 * x) - (2 * y) + 2
    GOTO 1

30  y = y - 1
    d = d - (2 * y) + 1
    GOTO 1

4
END SUB

SUB DrawLine (x1 AS INTEGER, y1 AS INTEGER, x2 AS INTEGER, y2 AS INTEGER)

DIM x AS INTEGER, y AS INTEGER, dx AS INTEGER, dy AS INTEGER
DIM s1 AS INTEGER, s2 AS INTEGER
DIM i AS INTEGER
DIM Interchange AS INTEGER
DIM e AS INTEGER

''*** THE STANDARD BRESENHAM'S ALGORITHM FOR A LINE *****

'initialize variables
x = x1: y = y1
dx = ABS(x2 - x1): dy = ABS(y2 - y1)
s1 = SGN(x2 - x1): s2 = SGN(y2 - y1)

'interchange dx and dy depending on the slope of line
IF dy > dx THEN
    SWAP dx, dy
    Interchange = 1
ELSE
    Interchange = 0
END IF

'initialize error term to compensate for a nonzero interrupt
e = (2 * dy) - dx

'main loop
FOR i = 1 TO dx
    PSET (x, y)
    WHILE (e >= 0)
        IF Interchange THEN x = (x + s1) ELSE y = (y + s2)
        e = e - (2 * dx)
    WEND
    IF Interchange THEN y = (y + s2) ELSE x = (x + s1)
    e = e + (2 * dy)
NEXT i

END SUB

