'
' CONTENT:
'   This program lets you play brainvita on a computer. It will provide
' much more scope than the ordinary game. It has two preset designs to
' play on. Morever, one can create his own designs.
'
' NOTE:
'   In this program, the use of map of holes is illustrative. Due to this,
' one is able to store and draw different designs efficiently and easily.
'
'

'* Info About Variables *
DEFINT A-Z
CONST TRUE = -1, FALSE = NOT TRUE  'i.e 0
CONST NOPAWNHOLE = 0, PAWNHOLE = 1, CURSOR = 3
TYPE ScreenMapType
    hole AS INTEGER
    pawn AS INTEGER
END TYPE
DIM SHARED ScreenMap(1 TO 10, 1 TO 16) AS ScreenMapType
DIM SHARED ScreenMapCursorX
DIM SHARED ScreenMapCursorY
DIM SHARED fig1(65)
DIM SHARED fig2(65)
DIM SHARED fig3(120)
DIM SHARED ChangedMode

'* Declare Sub-routines and Functions *
DECLARE SUB GetFigures ()
DECLARE SUB SetDesign (Design)
DECLARE SUB DrawScreen ()
DECLARE SUB DrawFigure (Row, Col, Figure)
DECLARE SUB GetHole (Row, Col)
DECLARE SUB PlayGame ()
DECLARE SUB PlayMove (x1, y1, x2, y2)
DECLARE FUNCTION Valid (x1, y1, x2, y2)
DECLARE FUNCTION MovesPossible ()
DECLARE FUNCTION PawnsPresent ()

'* Intro of Game *
CLS
LOCATE 5, 10
PRINT "Welcome To The Game Of Brainvita!"
PRINT
PRINT TAB(10); "You can play brainvita on two preset designs "
PRINT TAB(10); "Or you can create your own design."
PRINT TAB(10); "Design 1 is the ordinary design."
PRINT TAB(10); "Design 2 is a square of holes."
PRINT TAB(10); "If you want to create your own design,"
PRINT TAB(10); "it will be Design 3."
DO
    PRINT TAB(10); : INPUT "Enter Design number(1,2, or 3; 4 to quit):", DesignNum
LOOP UNTIL DesignNum < 5 AND DesignNum > 0
DesignNum = INT(DesignNum)
IF DesignNum = 4 THEN SYSTEM

'* Set Mode *      to set screen to mode CO80
ON ERROR GOTO ModeError
SCREEN 2
ON ERROR GOTO 0

GetFigures

DO
    SetDesign DesignNum
    DrawScreen
    PlayGame
    DO
    PRINT TAB(10); : INPUT "Enter Design number(1,2,or 3;4 to end):", DesignNum
    LOOP UNTIL DesignNum < 5 AND DesignNum > 0
    DesignNum = INT(DesignNum)
LOOP UNTIL DesignNum = 4

IF ChangedMode THEN SHELL "mode mono"
SYSTEM

ModeError:
    ' screen is not in graphics mode
    ChangedMode = TRUE
    SHELL "mode co80"
    SCREEN 2
    RESUME

SUB DrawFigure (Row, Col, Figure)

SELECT CASE Figure
    CASE NOPAWNHOLE
        x = ((Col - 1) * 40) + 4
        y = ((Row - 1) * 20) + 1
        PUT (x, y), fig1
    CASE PAWNHOLE
        x = ((Col - 1) * 40) + 4
        y = ((Row - 1) * 20) + 1
        PUT (x, y), fig2
    CASE CURSOR
        x = ((Col - 1) * 40)
        y = ((Row - 1) * 20) - 1
        PUT (x, y), fig3
END SELECT

END SUB

SUB DrawScreen

CLS

FOR x = 1 TO 10: FOR y = 1 TO 16
    IF ScreenMap(x, y).hole THEN
        IF ScreenMap(x, y).pawn THEN
            DrawFigure x, y, PAWNHOLE
        ELSE
            DrawFigure x, y, NOPAWNHOLE
        END IF
    END IF
NEXT y, x

END SUB

SUB GetFigures

    CLS

    CIRCLE (320, 100), 16
    GET (304, 92)-(336, 108), fig1

    PAINT (320, 100)
    GET (304, 92)-(336, 108), fig2
    PUT (304, 92), fig2

    LINE (300, 90)-(340, 110), , B
    GET (300, 90)-(340, 110), fig3
    PUT (300, 90), fig3

END SUB

SUB GetHole (Row, Col)

x = Row: y = Col
nx = x: ny = y

DO
    DO: Inp$ = INKEY$: LOOP WHILE Inp$ = ""
    SELECT CASE Inp$
        CASE CHR$(0) + "H":
            IF x > 1 THEN
                IF ScreenMap(x - 1, y).hole THEN nx = x - 1 'up
            END IF
        CASE CHR$(0) + "P":
            IF x < 10 THEN
                IF ScreenMap(x + 1, y).hole THEN nx = x + 1 'down
            END IF
        CASE CHR$(0) + "M":
            IF y < 16 THEN
                IF ScreenMap(x, y + 1).hole THEN ny = y + 1 'right
            END IF
        CASE CHR$(0) + "K":
            IF y > 1 THEN
                IF ScreenMap(x, y - 1).hole THEN ny = y - 1 'left
            END IF
        CASE CHR$(13):      Row = x: Col = y: EXIT SUB                  'enter
        CASE CHR$(27):
                CLS
                IF ChangedMode THEN SHELL "mode mono"
                SYSTEM
    END SELECT
    DrawFigure x, y, CURSOR
    DrawFigure nx, ny, CURSOR
    x = nx: y = ny
LOOP

END SUB

FUNCTION MovesPossible

count = 0

FOR x = 1 TO 10: FOR y = 1 TO 16
    IF ScreenMap(x, y).hole THEN
        IF Valid(x, y, x - 2, y) THEN count = count + 1
        IF Valid(x, y, x + 2, y) THEN count = count + 1
        IF Valid(x, y, x, y - 2) THEN count = count + 1
        IF Valid(x, y, x, y + 2) THEN count = count + 1
    END IF
NEXT y, x

MovesPossible = count

END FUNCTION

FUNCTION PawnsPresent

count = 0
FOR a = 1 TO 10: FOR b = 1 TO 16
    IF ScreenMap(a, b).pawn THEN count = count + 1
NEXT b, a

PawnsPresent = count

END FUNCTION

SUB PlayGame

Row = ScreenMapCursorX
Col = ScreenMapCursorY
MovPos = MovesPossible
DrawFigure Row, Col, CURSOR

DO
    LOCATE 1, 50: PRINT "Moves Possible: "; MovPos
   
1  'ask for starting hole
    Complete = FALSE
    DO
        GetHole Row, Col
        x1 = Row: y1 = Col
        IF ScreenMap(Row, Col).pawn THEN Complete = TRUE
    LOOP UNTIL Complete

    LOCATE 1, 1: PRINT "Started"

    'ask for ending hole
    Complete = FALSE
    DO
        GetHole Row, Col
        x2 = Row: y2 = Col
        IF x1 = x2 AND y1 = y2 THEN
            LOCATE 1, 1: PRINT "        "
            GOTO 1
        END IF
        IF Valid(x1, y1, x2, y2) THEN Complete = TRUE
    LOOP UNTIL Complete

    LOCATE 1, 1: PRINT "         "

    PlayMove x1, y1, x2, y2
   
    MovPos = MovesPossible
    

LOOP UNTIL MovPos = 0

CLS
LOCATE 5, 10: PRINT "END OF GAME. PAWNS LEFT: "; PawnsPresent

END SUB

SUB PlayMove (x1, y1, x2, y2)

x3 = (x1 + x2) / 2: y3 = (y1 + y2) / 2

DrawFigure x1, y1, PAWNHOLE
DrawFigure x1, y1, NOPAWNHOLE
ScreenMap(x1, y1).pawn = FALSE

DrawFigure x3, y3, PAWNHOLE
DrawFigure x3, y3, NOPAWNHOLE
ScreenMap(x3, y3).pawn = FALSE

DrawFigure x2, y2, NOPAWNHOLE
DrawFigure x2, y2, PAWNHOLE
ScreenMap(x2, y2).pawn = TRUE

END SUB

SUB SetDesign (Design)

FOR x = 1 TO 10: FOR y = 1 TO 16
    ScreenMap(x, y).hole = FALSE
    ScreenMap(x, y).pawn = FALSE
NEXT y, x

SELECT CASE Design
    CASE 1:          'Normal
        FOR x = 2 TO 8: FOR y = 7 TO 9
            ScreenMap(x, y).hole = TRUE
            ScreenMap(x, y).pawn = TRUE
        NEXT y, x
        FOR x = 4 TO 6: FOR y = 5 TO 6
            ScreenMap(x, y).hole = TRUE
            ScreenMap(x, y).pawn = TRUE
        NEXT y, x
        FOR x = 4 TO 6: FOR y = 10 TO 11
            ScreenMap(x, y).hole = TRUE
            ScreenMap(x, y).pawn = TRUE
        NEXT y, x
        ScreenMap(5, 8).pawn = FALSE
        ScreenMapCursorX = 5
        ScreenMapCursorY = 8
    CASE 2:         'Square
        FOR x = 2 TO 10: FOR y = 4 TO 12
            ScreenMap(x, y).hole = TRUE
            ScreenMap(x, y).pawn = TRUE
        NEXT y, x
        ScreenMap(6, 8).pawn = FALSE
        ScreenMapCursorX = 6
        ScreenMapCursorY = 8
    CASE 3:         'User-created
        CLS
        LOCATE 1, 1: PRINT "DESIGN:-    space:toggle    arrow:move    enter:complete   esc:cancel"
        x = 5: y = 8: nx = x: ny = y
        DrawFigure x, y, CURSOR
        DO
            DO: Inp$ = INKEY$: LOOP WHILE Inp$ = ""
            SELECT CASE Inp$
                CASE CHR$(0) + "H":     IF x > 2 THEN nx = x - 1    'up
                CASE CHR$(0) + "P":     IF x < 9 THEN nx = x + 1   'down
                CASE CHR$(0) + "K":     IF y > 1 THEN ny = y - 1    'left
                CASE CHR$(0) + "M":     IF y < 15 THEN ny = y + 1   'right
                CASE CHR$(13):      'enter:completion of design
                    IF MovesPossible THEN
                        EXIT DO
                    ELSE
                        LOCATE 24, 1: PRINT "Invalid Design!";
                        PRINT "Press a key";
                        a$ = INPUT$(1)
                        LOCATE 24, 1: PRINT SPACE$(30);
                    END IF
                CASE CHR$(32):      'space:toggle states
                    IF ScreenMap(x, y).hole = FALSE THEN
                        ScreenMap(x, y).hole = TRUE
                        DrawFigure x, y, NOPAWNHOLE
                    ELSEIF ScreenMap(x, y).pawn THEN
                        ScreenMap(x, y).hole = FALSE
                        ScreenMap(x, y).pawn = FALSE
                        DrawFigure x, y, PAWNHOLE   'erase
                    ELSE
                        ScreenMap(x, y).pawn = TRUE
                        DrawFigure x, y, NOPAWNHOLE 'erase
                        DrawFigure x, y, PAWNHOLE
                    END IF
                CASE CHR$(27):      'escape
                    CLS
                    LOCATE 5, 10
                    DO
                        PRINT TAB(10); : INPUT "Enter Design number(1,2,or 3;4 to end):", DesignNum
                    LOOP UNTIL DesignNum < 5 AND DesignNum > 0
                    DesignNum = INT(DesignNum)
                    IF DesignNum = 4 THEN
                        IF ChangedMode THEN SHELL "mode mono"
                        SYSTEM
                    END IF
                    SetDesign DesignNum
                    EXIT SUB
            END SELECT
            DrawFigure x, y, CURSOR
            DrawFigure nx, ny, CURSOR
            x = nx: y = ny
        LOOP
        IF ScreenMap(x, y).hole THEN
            ScreenMapCursorX = x
            ScreenMapCursorY = y
        ELSE
            FOR x = 2 TO 9: FOR y = 1 TO 15
                IF ScreenMap(x, y).hole THEN
                    ScreenMapCursorX = x
                    ScreenMapCursorY = y
                END IF
            NEXT y, x
        END IF
END SELECT

END SUB

FUNCTION Valid (x1, y1, x2, y2)

Valid = FALSE

IF x1 < 1 OR x1 > 10 OR x2 < 1 OR x2 > 10 THEN EXIT FUNCTION
IF y1 < 1 OR y1 > 16 OR y2 < 1 OR y2 > 16 THEN EXIT FUNCTION
IF x1 = x2 THEN
    IF ABS(y2 - y1) <> 2 THEN EXIT FUNCTION
ELSEIF y1 = y2 THEN
    IF ABS(x2 - x1) <> 2 THEN EXIT FUNCTION
ELSE
    EXIT FUNCTION
END IF
x3 = (x1 + x2) / 2: y3 = (y1 + y2) / 2

IF NOT ScreenMap(x1, y1).hole THEN EXIT FUNCTION
IF NOT ScreenMap(x2, y2).hole THEN EXIT FUNCTION
IF NOT ScreenMap(x3, y3).hole THEN EXIT FUNCTION
IF NOT ScreenMap(x1, y1).pawn THEN EXIT FUNCTION
IF NOT ScreenMap(x3, y3).pawn THEN EXIT FUNCTION
IF ScreenMap(x2, y2).pawn THEN EXIT FUNCTION

Valid = TRUE

END FUNCTION

