'
' Here's
'                       A GAME OF BASKET BALL
'                                                    -- Gaurang Khetan
'
'

'variables and constants
    DEFDBL D: DEFSNG S: DEFINT I: DEFSTR C: DEFLNG L
   
    CONST CONVERT = .33, GRAVITY = 9.8, PI = 3.141592654#
    CONST TRUE = -1, FALSE = 0
    CONST ANG3D = 12 * PI / 180
    CONST FIELDBOTTOM = 175, FIELDWIDTH = 200, POSTHEIGHT = 90
    CONST PLAYERHEIGHT = 40

    DIM SHARED ball(1 TO 100)  AS INTEGER
    DIM SHARED goal(1 TO 100) AS INTEGER
    DIM SHARED player(1 TO 200) AS INTEGER
    DIM SHARED Ic1x, Ic1y, Ic2x, Ic2y, Ic3x, Ic3y, Ic4x, Ic4y

'declarations
    DECLARE SUB ZDrawScreen ()
    DECLARE SUB ZPlayGame ()
   
    DECLARE FUNCTION IplotParabola (Istartx, Istarty, Svel, Sangle, Swind)
    DECLARE FUNCTION Ixshift (Iup)
    DECLARE FUNCTION Iyshift (Iup)
    DECLARE FUNCTION Inormx (Igridx, Igridy)
    DECLARE FUNCTION Inormy (Igridx, Igridy)

'code
   
    ZDrawScreen
   
    ZPlayGame

    
   

'end
    IF Ichangedmode THEN SHELL "mode mono"
    SYSTEM

FUNCTION Inormx (Igridx, Igridy)

Inormx = Ic1x + Igridx + Ixshift(Igridy)

END FUNCTION

FUNCTION Inormy (Igridx, Igridy)

Inormy = Ic1y - Iyshift(Igridy)

END FUNCTION

'
FUNCTION IplotParabola (Istartx, Istarty, Svel, Sangle, Swind)

Stime = 0: Sinctime = .02

DO
    Stime = Stime + Sinctime
    Ix = (Svel * COS(Sangle * PI / 180) * Stime) + Istartx
    Iy = ((Svel * SIN(Sangle * PI / 180)) * Stime) - (.5 * GRAVITY * ((Stime) ^ 2))
    Iy = Istarty - (Iy * CONVERT)
    IF Iy > Istarty THEN
        IplotParabola = Ix
        PUT (Ipx, Ipy), ball
        EXIT DO
    END IF
    Ix = Ix - (Ix * Swind)
    IF Ipx THEN PUT (Ipx, Ipy), ball
    PUT (Ix, Iy), ball
    Ipx = Ix: Ipy = Iy
    'PSET (Ix, Iy)
LOOP

END FUNCTION

FUNCTION Ixshift (Iup)

Ixshift = Iup * COS(ANG3D)

END FUNCTION

FUNCTION Iyshift (Iup)

Iyshift = Iup * SIN(ANG3D)

END FUNCTION

SUB ZDrawScreen

    CLS
    SCREEN 2

    LOCATE 2, 34: PRINT "BASKET - BALL"
   
'get the figure of ball into an array
    CIRCLE (320, 100), 15
    PAINT (320, 100), 1
    GET (305, 94)-(335, 106), ball
    PUT (305, 94), ball
   
'prepare the ground field
    Ic1x = 25: Ic1y = FIELDBOTTOM
    Ic2x = Ic1x + Ixshift(FIELDWIDTH): Ic2y = Ic1y - Iyshift(FIELDWIDTH)
    Ic3x = 615: Ic3y = Ic2y
    Ic4x = Ic3x - Ic2x + Ic1x: Ic4y = Ic1y
   
    LINE (Ic1x, Ic1y)-(Ic2x, Ic2y): LINE (Ic2x, Ic2y)-(Ic3x, Ic3y)
    LINE (Ic3x, Ic3y)-(Ic4x, Ic4y): LINE (Ic4x, Ic4y)-(Ic1x, Ic1y)
   
'get the figure of goalpost into an array and display at both sides
    CIRCLE (600, 80), 25, , , , .13             'upper circle
    CIRCLE (600, 80), 25, , 3.14, 4.2, .5       'side line left
    CIRCLE (600, 80), 25, , 5.2, , .5           'side line right
    CIRCLE (600, 90), 15, , , , .1              'bottom circle
    GET (575, 77)-(625, 92), goal
    PUT (575, 77), goal         'erase
   
    Ipostftx = Ic1x + Ixshift(FIELDWIDTH / 2)
    Ipostfty = Ic1y - Iyshift(FIELDWIDTH / 2)
   
    LINE (Ipostftx, Ipostfty)-(Ipostftx, Ipostfty - POSTHEIGHT)
    LINE (Ipostftx + Ic4x - Ic1x, Ipostfty)-(Ipostftx + Ic4x - Ic1x, Ipostfty - POSTHEIGHT)
    LINE (Ipostftx, Ipostfty - POSTHEIGHT)-(Ipostftx + 10, Ipostfty - POSTHEIGHT)
    LINE (Ipostftx + Ic4x - Ic1x, Ipostfty - POSTHEIGHT)-(Ipostftx + Ic4x - Ic1x - 10, Ipostfty - POSTHEIGHT)
    PUT (Ipostftx + 10, Ipostfty - POSTHEIGHT), goal               'draw left
    PUT (Ipostftx + Ic4x - Ic1x - 10 - 50, Ipostfty - POSTHEIGHT), goal'draw right

'get figure of player into an array
    LINE (320, 100)-(320, 100 - PLAYERHEIGHT)
    LINE (305, 100 - PLAYERHEIGHT)-(335, 100 - PLAYERHEIGHT)
    LINE (300, 100 - (PLAYERHEIGHT / 2))-(340, 100 - (PLAYERHEIGHT / 2))
    GET (300, 100)-(340, 100 - PLAYERHEIGHT), player
    PUT (300, 100 - PLAYERHEIGHT), player

   
END SUB

SUB ZPlayGame

Ix1 = 100: Iy1 = 100: Inx1 = Ix1: Iny1 = Iy1
Ix2 = 350: Iy2 = 100: Inx2 = Ix2: Iny2 = Iy2
PUT (Inormx(Ix1, Iy1) - 20, Inormy(Ix1, Iy1) - PLAYERHEIGHT), player
PUT (Inormx(Ix2, Iy2) - 20, Inormy(Ix2, Iy2) - PLAYERHEIGHT), player

DO
    DO: Cchar = INKEY$: LOOP WHILE Cchar = ""
    SELECT CASE Cchar
      
       'player 1
        CASE "S", "s":  IF Iy1 >= 10 THEN Iny1 = Iy1 - 10
        CASE "W", "w":  IF Iy1 <= FIELDWIDTH - 10 THEN Iny1 = Iy1 + 10
        CASE "A", "a":  IF Ix1 >= 10 THEN Inx1 = Ix1 - 10
        CASE "D", "d":  IF Ix1 <= Ic4x - Ic1x - 10 THEN Inx1 = Ix1 + 10
       
       'player 2
        CASE CHR$(0) + "P":  IF Iy2 >= 10 THEN Iny2 = Iy2 - 10
        CASE CHR$(0) + "H":  IF Iy2 <= FIELDWIDTH - 10 THEN Iny2 = Iy2 + 10
        CASE CHR$(0) + "K":  IF Ix2 >= 10 THEN Inx2 = Ix2 - 10
        CASE CHR$(0) + "M":  IF Ix2 <= Ic4x - Ic1x - 10 THEN Inx2 = Ix2 + 10
       
        CASE CHR$(27): END

    END SELECT
   
    IF Inx1 <> Ix1 OR Iny1 <> Iy1 THEN
        PUT (Inormx(Ix1, Iy1) - 20, Inormy(Ix1, Iy1) - PLAYERHEIGHT), player
        PUT (Inormx(Inx1, Iny1) - 20, Inormy(Inx1, Iny1) - PLAYERHEIGHT), player
        Ix1 = Inx1: Iy1 = Iny1
    END IF

    IF Inx2 <> Ix2 OR Iny2 <> Iy2 THEN
        PUT (Inormx(Ix2, Iy2) - 20, Inormy(Ix2, Iy2) - PLAYERHEIGHT), player
        PUT (Inormx(Inx2, Iny2) - 20, Inormy(Inx2, Iny2) - PLAYERHEIGHT), player
        Ix2 = Inx2: Iy2 = Iny2
    END IF

LOOP
    
END SUB

